/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt.element;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.klimt.shape.URectangle;

public class Skeleton {
    private final List<Entry> entries = new ArrayList<Entry>();

    public void add(double x, double y) {
        this.entries.add(new Entry(x, y));
    }

    public void draw(UGraphic ug, double x, double y) {
        for (int i = 0; i < this.entries.size(); ++i) {
            Entry en = this.entries.get(i);
            if (i + 1 < this.entries.size() && this.entries.get(i + 1).xpos > en.xpos) {
                en.drawRectangle(ug);
            }
            Entry parent = null;
            for (int j = 0; j < i; ++j) {
                Entry en0 = this.entries.get(j);
                if (!(en0.xpos < en.xpos)) continue;
                parent = en0;
            }
            if (parent == null) continue;
            this.drawChild(ug, parent, en);
        }
    }

    private void drawChild(UGraphic ug, Entry parent, Entry child) {
        double dy = child.ypos - parent.ypos - 2.0;
        ug.apply(new UTranslate(parent.xpos + 1.0, parent.ypos + 3.0)).draw(ULine.vline(dy));
        double dx = child.xpos - parent.xpos - 2.0;
        ug.apply(new UTranslate(parent.xpos + 1.0, child.ypos + 1.0)).draw(ULine.hline(dx));
    }

    static class Entry {
        private final double xpos;
        private final double ypos;

        public Entry(double x, double y) {
            this.xpos = x;
            this.ypos = y;
        }

        public void drawRectangle(UGraphic ug) {
            ug.apply(new UTranslate(this.xpos, this.ypos)).draw(URectangle.build(2.0, 2.0));
        }
    }
}

