/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sudoku;

import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.sudoku.GraphicsSudoku;
import net.sourceforge.plantuml.sudoku.ISudoku;
import net.sourceforge.plantuml.sudoku.SudokuDLX;

public class PSystemSudoku
extends AbstractPSystem {
    private final ISudoku sudoku;

    @Override
    protected final ImageData exportDiagramNow(OutputStream os, int num, FileFormatOption fileFormat) throws IOException {
        GraphicsSudoku sud = new GraphicsSudoku(this.sudoku);
        if (fileFormat.getFileFormat() == FileFormat.EPS) {
            return sud.writeImageEps(os);
        }
        if (fileFormat.getFileFormat() == FileFormat.LATEX || fileFormat.getFileFormat() == FileFormat.LATEX_NO_PREAMBLE) {
            return sud.writeImageLatex(os, fileFormat.getFileFormat());
        }
        if (fileFormat.getFileFormat() == FileFormat.SVG) {
            return sud.writeImageSvg(os);
        }
        return sud.writeImagePng(os);
    }

    @Override
    public void exportDiagramGraphic(UGraphic ug) {
        GraphicsSudoku sud = new GraphicsSudoku(this.sudoku);
        sud.drawInternal(ug);
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Sudoku)");
    }

    public PSystemSudoku(UmlSource source, Long seed) {
        super(source);
        this.sudoku = new SudokuDLX(seed);
    }
}

