/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project3;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import net.sourceforge.plantuml.project3.ComplementColors;
import net.sourceforge.plantuml.project3.Instant;
import net.sourceforge.plantuml.project3.InstantDay;
import net.sourceforge.plantuml.project3.Load;
import net.sourceforge.plantuml.project3.LoadInDays;
import net.sourceforge.plantuml.project3.LoadPlanable;
import net.sourceforge.plantuml.project3.PlanUtils;
import net.sourceforge.plantuml.project3.Resource;
import net.sourceforge.plantuml.project3.Solver3;
import net.sourceforge.plantuml.project3.Task;
import net.sourceforge.plantuml.project3.TaskAttribute;
import net.sourceforge.plantuml.project3.TaskCode;
import net.sourceforge.plantuml.project3.TaskDraw;

public class TaskImpl
implements Task,
LoadPlanable {
    private final TaskCode code;
    private final Solver3 solver;
    private final Set<Resource> resources = new LinkedHashSet<Resource>();
    private final LoadPlanable defaultPlan;
    private TaskDraw taskDraw;
    private ComplementColors colors;

    public TaskImpl(TaskCode code, LoadPlanable defaultPlan) {
        this.code = code;
        this.defaultPlan = defaultPlan;
        this.solver = new Solver3(this);
        this.setStart(new InstantDay(0));
        this.setLoad(LoadInDays.inDay(1));
    }

    @Override
    public int getLoadAt(Instant instant) {
        LoadPlanable plan1 = this.defaultPlan;
        if (this.resources.size() > 0) {
            plan1 = PlanUtils.minOf(plan1, this.getRessourcePlan());
        }
        return PlanUtils.minOf(this.getLoad(), plan1).getLoadAt(instant);
    }

    public int loadForResource(Resource res, Instant i) {
        if (this.resources.contains(res) && i.compareTo(this.getStart()) >= 0 && i.compareTo(this.getEnd()) <= 0) {
            if (res.getLoadAt(i) == 0) {
                return 0;
            }
            int size = 0;
            for (Resource r : this.resources) {
                if (r.getLoadAt(i) <= 0) continue;
                ++size;
            }
            return this.getLoadAt(i) / size;
        }
        return 0;
    }

    private LoadPlanable getRessourcePlan() {
        if (this.resources.size() == 0) {
            throw new IllegalStateException();
        }
        return new LoadPlanable(){

            @Override
            public int getLoadAt(Instant instant) {
                int result = 0;
                for (Resource res : TaskImpl.this.resources) {
                    result += res.getLoadAt(instant);
                }
                return result;
            }
        };
    }

    public String getPrettyDisplay() {
        if (this.resources.size() > 0) {
            StringBuilder result = new StringBuilder(this.code.getSimpleDisplay());
            result.append(" ");
            Iterator<Resource> it = this.resources.iterator();
            while (it.hasNext()) {
                result.append("{");
                result.append(it.next().getName());
                result.append("}");
                if (!it.hasNext()) continue;
                result.append(" ");
            }
            return result.toString();
        }
        return this.code.getSimpleDisplay();
    }

    public String toString() {
        return this.code.toString();
    }

    public String debug() {
        return "" + this.getStart() + " ---> " + this.getEnd() + "   [" + this.getLoad() + "]";
    }

    @Override
    public TaskCode getCode() {
        return this.code;
    }

    @Override
    public Instant getStart() {
        Instant result = (Instant)this.solver.getData(TaskAttribute.START);
        while (this.getLoadAt(result) == 0) {
            result = result.increment();
        }
        return result;
    }

    @Override
    public Instant getEnd() {
        return (Instant)this.solver.getData(TaskAttribute.END);
    }

    @Override
    public Load getLoad() {
        return (Load)this.solver.getData(TaskAttribute.LOAD);
    }

    @Override
    public void setLoad(Load load) {
        this.solver.setData(TaskAttribute.LOAD, load);
    }

    @Override
    public void setStart(Instant start) {
        this.solver.setData(TaskAttribute.START, start);
    }

    @Override
    public void setEnd(Instant end) {
        this.solver.setData(TaskAttribute.END, end);
    }

    @Override
    public void setTaskDraw(TaskDraw taskDraw) {
        taskDraw.setColors(this.colors);
        this.taskDraw = taskDraw;
    }

    @Override
    public TaskDraw getTaskDraw() {
        return this.taskDraw;
    }

    @Override
    public void setColors(ComplementColors colors) {
        this.colors = colors;
    }

    @Override
    public void addResource(Resource resource) {
        this.resources.add(resource);
    }
}

