/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.activitydiagram3.Branch;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond.FtileSwitchNude;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;

public class FtileSwitchWithDiamonds
extends FtileSwitchNude {
    private static final double SUPP15 = 15.0;
    protected final Ftile diamond1;
    protected final Ftile diamond2;
    protected final List<Branch> branches;
    protected final Mode mode;
    private final double w13;
    private final double w9;

    public FtileSwitchWithDiamonds(List<Ftile> tiles, List<Branch> branches, Swimlane in, Ftile diamond1, Ftile diamond2, StringBounder stringBounder) {
        super(tiles, in);
        this.branches = branches;
        this.diamond1 = diamond1;
        this.diamond2 = diamond2;
        this.w13 = diamond1.calculateDimension(stringBounder).getWidth() - tiles.get(0).calculateDimension(stringBounder).getRight() - tiles.get(tiles.size() - 1).calculateDimension(stringBounder).getLeft();
        this.w9 = this.getW9(stringBounder);
        this.mode = this.w13 > this.w9 ? Mode.BIG_DIAMOND : Mode.SMALL_DIAMOND;
    }

    private double getW9(StringBounder stringBounder) {
        double result = 0.0;
        for (int i = 1; i < this.tiles.size() - 1; ++i) {
            result += ((Ftile)this.tiles.get(i)).calculateDimension(stringBounder).getWidth();
        }
        return result;
    }

    @Override
    public final Collection<Ftile> getMyChildren() {
        ArrayList<Ftile> result = new ArrayList<Ftile>(super.getMyChildren());
        result.add(this.diamond1);
        result.add(this.diamond2);
        return Collections.unmodifiableCollection(result);
    }

    protected double getYdelta1a(StringBounder stringBounder) {
        return 20.0;
    }

    protected final double getYdelta1b(StringBounder stringBounder) {
        return 10.0;
    }

    @Override
    protected final FtileGeometry calculateDimensionInternalSlow(StringBounder stringBounder) {
        FtileGeometry dim1 = this.diamond1.calculateDimension(stringBounder);
        FtileGeometry dim2 = this.diamond2.calculateDimension(stringBounder);
        double nudeHeight = super.calculateDimensionInternalSlow(stringBounder).getHeight();
        if (this.mode == Mode.BIG_DIAMOND) {
            double height = dim1.getHeight() + nudeHeight + dim2.getHeight() + this.getYdelta1a(stringBounder) + this.getYdelta1b(stringBounder);
            FtileGeometry tile0 = ((Ftile)this.tiles.get(0)).calculateDimension(stringBounder);
            double width = tile0.getWidth() + 15.0 + this.w13 + 15.0 + ((Ftile)this.tiles.get(this.tiles.size() - 1)).calculateDimension(stringBounder).getWidth();
            return new FtileGeometry(width, height, tile0.getLeft() + 15.0 + dim1.getLeft(), 0.0, height);
        }
        FtileGeometry dimNude = super.calculateDimensionInternalSlow(stringBounder);
        FtileGeometry all = dim1.appendBottom(dimNude).appendBottom(dim2);
        return all.addDim(0.0, this.getYdelta1a(stringBounder) + this.getYdelta1b(stringBounder));
    }

    @Override
    public final void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        ug.apply(this.getTranslateDiamond1(stringBounder)).draw(this.diamond1);
        if (this.mode == Mode.BIG_DIAMOND) {
            for (Ftile tile : this.tiles) {
                tile.drawU(ug.apply(this.getTranslateOf(tile, stringBounder)));
            }
        } else {
            super.drawU(ug.apply(this.getTranslateMain(stringBounder)));
        }
        if (this.calculateDimension(stringBounder).hasPointOut()) {
            ug.apply(this.getTranslateDiamond2(stringBounder)).draw(this.diamond2);
        }
    }

    protected final UTranslate getTranslateOf(Ftile tile, StringBounder stringBounder) {
        UTranslate main = this.getTranslateMain(stringBounder);
        if (this.mode == Mode.BIG_DIAMOND) {
            double dx = 0.0;
            double suppx = (this.w13 - this.w9) / (double)(this.tiles.size() - 1);
            for (int i = 0; i < this.tiles.size() - 1; ++i) {
                if (tile == this.tiles.get(i)) {
                    return main.compose(UTranslate.dx(dx));
                }
                dx += ((Ftile)this.tiles.get(i)).calculateDimension(stringBounder).getWidth() + suppx;
            }
            if (tile == this.tiles.get(this.tiles.size() - 1)) {
                double dx9 = ((Ftile)this.tiles.get(0)).calculateDimension(stringBounder).getWidth() + this.w13 + 15.0 + 15.0;
                return main.compose(UTranslate.dx(dx9));
            }
            throw new IllegalArgumentException();
        }
        return this.getTranslateNude(tile, stringBounder).compose(main);
    }

    protected final UTranslate getTranslateMain(StringBounder stringBounder) {
        FtileGeometry dimDiamond1 = this.diamond1.calculateDimension(stringBounder);
        double dy1 = dimDiamond1.getHeight() + this.getYdelta1a(stringBounder);
        return UTranslate.dy(dy1);
    }

    protected final UTranslate getTranslateDiamond1(StringBounder stringBounder) {
        double y1 = 0.0;
        FtileGeometry dimTotal = this.calculateDimensionInternal(stringBounder);
        FtileGeometry dimDiamond1 = this.diamond1.calculateDimension(stringBounder);
        double x1 = dimTotal.getLeft() - dimDiamond1.getLeft();
        return new UTranslate(x1, 0.0);
    }

    protected final UTranslate getTranslateDiamond2(StringBounder stringBounder) {
        FtileGeometry dimTotal = this.calculateDimensionInternal(stringBounder);
        FtileGeometry dimDiamond2 = this.diamond2.calculateDimension(stringBounder);
        double y2 = dimTotal.getHeight() - dimDiamond2.getHeight();
        double x2 = dimTotal.getLeft() - dimDiamond2.getWidth() / 2.0;
        return new UTranslate(x2, y2);
    }

    static enum Mode {
        BIG_DIAMOND,
        SMALL_DIAMOND;

    }
}

