/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

public class QuadraticEquation {
    private final double a;
    private final double b;
    private final double c;

    public QuadraticEquation(double a, double b, double c) {
        this.a = a;
        this.b = b;
        this.c = c;
    }

    public double[] solve() {
        double delta = this.b * this.b - 4.0 * this.a * this.c;
        double x0 = (-this.b - Math.sqrt(delta)) / 2.0 / this.a;
        double x1 = (-this.b + Math.sqrt(delta)) / 2.0 / this.a;
        return new double[]{x0, x1};
    }

    public double getV(double x) {
        return this.a * x * x + this.b * x + this.c;
    }
}

