/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim.iterator;

import java.util.Collections;
import java.util.Map;
import net.sourceforge.plantuml.preproc.Sub;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.text.TLineType;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.EaterExceptionLocated;
import net.sourceforge.plantuml.tim.EaterStartsub;
import net.sourceforge.plantuml.tim.TContext;
import net.sourceforge.plantuml.tim.TMemory;
import net.sourceforge.plantuml.tim.iterator.AbstractCodeIterator;
import net.sourceforge.plantuml.tim.iterator.CodeIterator;
import net.sourceforge.plantuml.tim.iterator.CodeIteratorImpl;

public class CodeIteratorSub
extends AbstractCodeIterator {
    private final Map<String, Sub> subs;
    private CodeIterator readingInProgress;
    private final TMemory memory;
    private final TContext context;

    public CodeIteratorSub(CodeIterator source, Map<String, Sub> subs, TContext context, TMemory memory) {
        super(source);
        this.context = context;
        this.memory = memory;
        this.subs = subs;
    }

    public Map<String, Sub> getSubs() {
        return Collections.unmodifiableMap(this.subs);
    }

    @Override
    public StringLocated peek() throws EaterException, EaterExceptionLocated {
        if (this.readingInProgress != null) {
            return this.readingInProgress.peek();
        }
        StringLocated result = this.source.peek();
        if (result == null) {
            return null;
        }
        if (result.getType() == TLineType.STARTSUB) {
            EaterStartsub eater = new EaterStartsub(result.getTrimmed());
            eater.analyze(this.context, this.memory);
            Sub created = new Sub(eater.getSubname());
            this.subs.put(eater.getSubname(), created);
            this.source.next();
            StringLocated s = null;
            while ((s = this.source.peek()) != null) {
                if (s.getType() == TLineType.STARTSUB) {
                    throw EaterException.located("Cannot nest sub");
                }
                if (s.getType() == TLineType.ENDSUB) {
                    this.source.next();
                    this.readingInProgress = new CodeIteratorImpl(created.lines());
                    break;
                }
                created.add(s);
                this.source.next();
            }
        }
        if (this.readingInProgress != null) {
            return this.readingInProgress.peek();
        }
        return result;
    }

    @Override
    public void next() throws EaterException, EaterExceptionLocated {
        if (this.readingInProgress == null) {
            this.source.next();
            return;
        }
        this.readingInProgress.next();
        if (this.readingInProgress.peek() == null) {
            this.readingInProgress = null;
        }
    }
}

