/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFColorSpace;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.PDFName;
import org.apache.fop.pdf.PDFObject;

public class PDFCIELabColorSpace
extends PDFArray
implements PDFColorSpace {
    public PDFCIELabColorSpace(float[] whitePoint, float[] blackPoint) {
        this.add(new PDFName("Lab"));
        PDFDictionary dict = new PDFDictionary();
        dict.put("WhitePoint", this.toPDFArray("White point", whitePoint));
        if (whitePoint[1] != 1.0f) {
            throw new IllegalArgumentException("The white point's Y coordinate must be 1.0");
        }
        if (blackPoint != null) {
            dict.put("BlackPoint", this.toPDFArray("Black point", blackPoint));
        }
        dict.put("Range", new PDFArray((PDFObject)dict, new int[]{-128, 128, -128, 128}));
        this.add(dict);
    }

    private PDFArray toPDFArray(String name, float[] whitePoint) {
        PDFArray wp = new PDFArray();
        if (whitePoint == null || whitePoint.length != 3) {
            throw new IllegalArgumentException(name + " must be given an have 3 components");
        }
        for (int i = 0; i < 3; ++i) {
            wp.add(whitePoint[i]);
        }
        return wp;
    }

    @Override
    public String getName() {
        return "CS" + this.getObjectNumber();
    }

    @Override
    public int getNumComponents() {
        return 3;
    }

    @Override
    public boolean isCMYKColorSpace() {
        return false;
    }

    @Override
    public boolean isDeviceColorSpace() {
        return false;
    }

    @Override
    public boolean isGrayColorSpace() {
        return false;
    }

    @Override
    public boolean isRGBColorSpace() {
        return false;
    }
}

