/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.timingdiagram.Player;
import net.sourceforge.plantuml.timingdiagram.TimingDiagram;

public class CommandDefineStateShort
extends SingleLineCommand2<TimingDiagram> {
    public CommandDefineStateShort() {
        super(CommandDefineStateShort.getRegexConcat());
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("PLAYER", "([\\p{L}0-9_.@]+)"), new RegexLeaf("[%s]+has[%s]+"), new RegexLeaf("STATE", "([\\p{L}0-9_.@]+)"), new RegexLeaf("$"));
    }

    @Override
    protected final CommandExecutionResult executeArg(TimingDiagram diagram, RegexResult arg) {
        String playerCode = arg.get("PLAYER", 0);
        Player player = diagram.getPlayer(playerCode);
        if (player == null) {
            return CommandExecutionResult.error("Unknown " + playerCode);
        }
        String stateCode = arg.get("STATE", 0);
        player.defineState(stateCode, stateCode);
        return CommandExecutionResult.ok();
    }
}

