/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.AParentFolderRegular;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.CharSequence2;
import net.sourceforge.plantuml.DefinitionsContainer;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.preproc.FileWithSuffix;
import net.sourceforge.plantuml.preproc.ImportedFiles;
import net.sourceforge.plantuml.preproc.ReadLineNumbered;
import net.sourceforge.plantuml.preproc.ReadLineReader;
import net.sourceforge.plantuml.preproc.UncommentReadLine;
import net.sourceforge.plantuml.preproc2.Preprocessor2;
import net.sourceforge.plantuml.utils.StartUtils;

public final class BlockUmlBuilder
implements DefinitionsContainer {
    private final List<BlockUml> blocks = new ArrayList<BlockUml>();
    private Set<FileWithSuffix> usedFiles = new HashSet<FileWithSuffix>();
    private final UncommentReadLine reader2;
    private final Defines defines;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockUmlBuilder(List<String> config, String charset, Defines defines, Reader reader, File newCurrentDir, String desc) throws IOException {
        Closeable includer = null;
        this.defines = defines;
        try {
            this.reader2 = new UncommentReadLine(ReadLineReader.create(reader, desc));
            includer = new Preprocessor2(config, this.reader2, charset, defines, this, ImportedFiles.createImportedFiles(new AParentFolderRegular(newCurrentDir)));
            this.init((ReadLineNumbered)includer);
        }
        finally {
            if (includer != null) {
                includer.close();
                this.usedFiles = includer.getFilesUsed();
            }
        }
    }

    public BlockUmlBuilder(List<String> config, String charset, Defines defines, Reader reader) throws IOException {
        this(config, charset, defines, reader, null, null);
    }

    private void init(ReadLineNumbered includer) throws IOException {
        CharSequence2 s = null;
        ArrayList<CharSequence2> current2 = null;
        boolean paused = false;
        while ((s = includer.readLine()) != null) {
            CharSequence2 append;
            if (StartUtils.isArobaseStartDiagram(s)) {
                current2 = new ArrayList<CharSequence2>();
                paused = false;
            }
            if (StartUtils.isArobasePauseDiagram(s)) {
                paused = true;
                this.reader2.setPaused(true);
            }
            if (StartUtils.isExit(s)) {
                paused = true;
                this.reader2.setPaused(true);
            }
            if (current2 != null && !paused) {
                current2.add(s);
            } else if (paused && (append = StartUtils.getPossibleAppend(s)) != null) {
                current2.add(append);
            }
            if (StartUtils.isArobaseUnpauseDiagram(s)) {
                paused = false;
                this.reader2.setPaused(false);
            }
            if (!StartUtils.isArobaseEndDiagram(s) || current2 == null) continue;
            if (paused) {
                current2.add(s);
            }
            this.blocks.add(new BlockUml(current2, this.defines.cloneMe()));
            current2 = null;
            this.reader2.setPaused(false);
        }
    }

    public List<BlockUml> getBlockUmls() {
        return Collections.unmodifiableList(this.blocks);
    }

    public final Set<FileWithSuffix> getIncludedFiles() {
        return Collections.unmodifiableSet(this.usedFiles);
    }

    @Override
    public List<? extends CharSequence> getDefinition(String name) {
        for (BlockUml block : this.blocks) {
            if (!block.isStartDef(name)) continue;
            this.defines.importFrom(block.getLocalDefines());
            return block.getDefinition(false);
        }
        return Collections.emptyList();
    }
}

