/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.util.ArrayList;
import java.util.List;
import org.apache.fop.pdf.PDFDocument;

public class PDFWArray {
    private List entries = new ArrayList();

    public PDFWArray() {
    }

    public PDFWArray(int[] metrics) {
        this.addEntry(0, metrics);
    }

    public void addEntry(int start, int[] metrics) {
        this.entries.add(new Entry(start, metrics));
    }

    public void addEntry(int first, int last, int width) {
        this.entries.add(new int[]{first, last, width});
    }

    public void addEntry(int first, int last, int width, int posX, int posY) {
        this.entries.add(new int[]{first, last, width, posX, posY});
    }

    public byte[] toPDF() {
        return PDFDocument.encode(this.toPDFString());
    }

    public String toPDFString() {
        StringBuffer p = new StringBuffer();
        p.append("[ ");
        int len = this.entries.size();
        for (Object entry : this.entries) {
            if (entry instanceof int[]) {
                int[] line;
                for (int aLine : line = (int[])entry) {
                    p.append(aLine);
                    p.append(" ");
                }
                continue;
            }
            ((Entry)entry).fillInPDF(p);
        }
        p.append("]");
        return p.toString();
    }

    private static class Entry {
        private int start;
        private int[] metrics;

        public Entry(int s, int[] m) {
            this.start = s;
            this.metrics = m;
        }

        public void fillInPDF(StringBuffer p) {
            p.append(this.start);
            p.append(" [");
            for (int metric : this.metrics) {
                p.append(metric);
                p.append(" ");
            }
            p.append("] ");
        }
    }
}

