/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.CharSequence2;
import net.sourceforge.plantuml.ErrorUml;
import net.sourceforge.plantuml.ErrorUmlType;
import net.sourceforge.plantuml.PSystemError;
import net.sourceforge.plantuml.command.PSystemAbstractFactory;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.DiagramType;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.utils.StartUtils;
import net.sourceforge.plantuml.version.IteratorCounter2;

public abstract class PSystemSingleLineFactory
extends PSystemAbstractFactory {
    protected abstract AbstractPSystem executeLine(String var1);

    protected PSystemSingleLineFactory() {
        super(DiagramType.UML);
    }

    @Override
    public final Diagram createSystem(UmlSource source) {
        if (source.getTotalLineCount() != 3) {
            return null;
        }
        IteratorCounter2 it = source.iterator2();
        if (source.isEmpty()) {
            return this.buildEmptyError(source, it.peek().getLocation());
        }
        CharSequence2 startLine = (CharSequence2)it.next();
        if (!StartUtils.isArobaseStartDiagram(startLine)) {
            throw new UnsupportedOperationException();
        }
        if (!it.hasNext()) {
            return this.buildEmptyError(source, startLine.getLocation());
        }
        CharSequence2 s = (CharSequence2)it.next();
        if (StartUtils.isArobaseEndDiagram(s)) {
            return this.buildEmptyError(source, s.getLocation());
        }
        AbstractPSystem sys = this.executeLine(s.toString2());
        if (sys == null) {
            ErrorUml err = new ErrorUml(ErrorUmlType.SYNTAX_ERROR, "Syntax Error?", s.getLocation());
            return new PSystemError(source, err, null);
        }
        sys.setSource(source);
        return sys;
    }
}

