/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.util.Collection;
import net.sourceforge.plantuml.klimt.geom.Rankdir;
import net.sourceforge.plantuml.klimt.geom.RectangleArea;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;

public class FrontierCalculator {
    private static final double DELTA = 18.0;
    private RectangleArea core;
    private final RectangleArea initial;

    public FrontierCalculator(RectangleArea initial, Collection<RectangleArea> insides, Collection<XPoint2D> points, Rankdir rankdir) {
        this.initial = initial;
        for (RectangleArea in : insides) {
            if (this.core == null) {
                this.core = in;
                continue;
            }
            this.core = this.core.merge(in);
        }
        if (this.core == null) {
            XPoint2D center = initial.getPointCenter();
            this.core = new RectangleArea(center.getX() - 1.0, center.getY() - 1.0, center.getX() + 1.0, center.getY() + 1.0);
        }
        for (XPoint2D p : points) {
            this.core = this.core.merge(p);
        }
        boolean touchMinX = false;
        boolean touchMaxX = false;
        boolean touchMinY = false;
        boolean touchMaxY = false;
        for (XPoint2D p : points) {
            if (p.getX() == this.core.getMinX()) {
                touchMinX = true;
            }
            if (p.getX() == this.core.getMaxX()) {
                touchMaxX = true;
            }
            if (p.getY() == this.core.getMinY()) {
                touchMinY = true;
            }
            if (p.getY() != this.core.getMaxY()) continue;
            touchMaxY = true;
        }
        if (!touchMinX) {
            this.core = this.core.withMinX(initial.getMinX());
        }
        if (!touchMaxX) {
            this.core = this.core.withMaxX(initial.getMaxX());
        }
        if (!touchMinY) {
            this.core = this.core.withMinY(initial.getMinY());
        }
        if (!touchMaxY) {
            this.core = this.core.withMaxY(initial.getMaxY());
        }
        boolean pushMinX = false;
        boolean pushMaxX = false;
        boolean pushMinY = false;
        boolean pushMaxY = false;
        for (XPoint2D p : points) {
            if (p.getY() == this.core.getMinY() || p.getY() == this.core.getMaxY()) {
                if (Math.abs(p.getX() - this.core.getMaxX()) < 18.0) {
                    pushMaxX = true;
                }
                if (Math.abs(p.getX() - this.core.getMinX()) < 18.0) {
                    pushMinX = true;
                }
            }
            if (p.getX() != this.core.getMinX() && p.getX() != this.core.getMaxX()) continue;
            if (Math.abs(p.getY() - this.core.getMaxY()) < 18.0) {
                pushMaxY = true;
            }
            if (!(Math.abs(p.getY() - this.core.getMinY()) < 18.0)) continue;
            pushMinY = true;
        }
        for (XPoint2D p : points) {
            if (rankdir == Rankdir.LEFT_TO_RIGHT) {
                if (p.getX() == this.core.getMinX() && (p.getY() == this.core.getMinY() || p.getY() == this.core.getMaxY())) {
                    pushMinX = false;
                }
                if (p.getX() != this.core.getMaxX() || p.getY() != this.core.getMinY() && p.getY() != this.core.getMaxY()) continue;
                pushMaxX = false;
                continue;
            }
            if (p.getY() == this.core.getMinY() && (p.getX() == this.core.getMinX() || p.getX() == this.core.getMaxX())) {
                pushMinY = false;
            }
            if (p.getY() != this.core.getMaxY() || p.getX() != this.core.getMinX() && p.getX() != this.core.getMaxX()) continue;
            pushMaxY = false;
        }
        if (pushMaxX) {
            this.core = this.core.addMaxX(18.0);
        }
        if (pushMinX) {
            this.core = this.core.addMinX(-18.0);
        }
        if (pushMaxY) {
            this.core = this.core.addMaxY(18.0);
        }
        if (pushMinY) {
            this.core = this.core.addMinY(-18.0);
        }
    }

    public RectangleArea getSuggestedPosition() {
        return this.core;
    }

    public void ensureMinWidth(double minWidth) {
        double delta = this.core.getMaxX() - this.core.getMinX() - minWidth;
        if (delta < 0.0) {
            double newMinX = this.core.getMinX() + delta / 2.0;
            double newMaxX = this.core.getMaxX() - delta / 2.0;
            double error = newMinX - this.initial.getMinX();
            if (error < 0.0) {
                newMinX -= error;
                newMaxX -= error;
            }
            this.core = this.core.withMinX(newMinX);
            this.core = this.core.withMaxX(newMaxX);
        }
    }
}

