/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command.regex;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.command.regex.RegexComposed;
import net.sourceforge.plantuml.command.regex.RegexPartialMatch;

public class RegexOr
extends RegexComposed
implements IRegex {
    private final Pattern2 full;
    private final String name;

    public RegexOr(IRegex ... partial) {
        this((String)null, partial);
    }

    public RegexOr(String name, IRegex ... partial) {
        super(partial);
        this.name = name;
        StringBuilder sb = new StringBuilder("(");
        if (name == null) {
            sb.append("?:");
        }
        for (IRegex p : partial) {
            sb.append(p.getPattern());
            sb.append("|");
        }
        sb.setLength(sb.length() - 1);
        sb.append(')');
        this.full = MyPattern.cmpileNockeck(sb.toString());
    }

    @Override
    protected Pattern2 getFull() {
        return this.full;
    }

    @Override
    protected int getStartCount() {
        return 1;
    }

    @Override
    public final Map<String, RegexPartialMatch> createPartialMatch(Iterator<String> it) {
        HashMap<String, RegexPartialMatch> result = new HashMap<String, RegexPartialMatch>();
        String fullGroup = this.name == null ? null : it.next();
        result.putAll(super.createPartialMatch(it));
        if (this.name != null) {
            RegexPartialMatch m = new RegexPartialMatch(this.name);
            m.add(fullGroup);
            result.put(this.name, m);
        }
        return result;
    }
}

