/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.svg;

import java.awt.Dimension;
import org.apache.fop.render.intermediate.IFContext;
import org.apache.fop.render.intermediate.IFException;
import org.apache.fop.render.intermediate.IFPainter;
import org.apache.fop.render.svg.AbstractSVGDocumentHandler;
import org.apache.fop.render.svg.SVGPainter;
import org.apache.fop.util.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SVGPrintDocumentHandler
extends AbstractSVGDocumentHandler {
    public SVGPrintDocumentHandler(IFContext context) {
        super(context);
    }

    public boolean supportsPagesOutOfOrder() {
        return false;
    }

    public String getMimeType() {
        return "image/svg+xml;profile=print";
    }

    public void startDocument() throws IFException {
        super.startDocument();
        try {
            this.handler.startDocument();
            this.handler.startPrefixMapping("", "http://www.w3.org/2000/svg");
            this.handler.startPrefixMapping("xlink", "http://www.w3.org/1999/xlink");
            this.handler.startPrefixMapping("if", "http://xmlgraphics.apache.org/fop/intermediate");
            AttributesImpl atts = new AttributesImpl();
            XMLUtil.addAttribute((AttributesImpl)atts, (String)"version", (String)"1.2");
            this.handler.startElement("svg", (Attributes)atts);
        }
        catch (SAXException e) {
            throw new IFException("SAX error in startDocument()", (Exception)e);
        }
    }

    public void endDocument() throws IFException {
        try {
            this.handler.endElement("svg");
            this.handler.endDocument();
        }
        catch (SAXException e) {
            throw new IFException("SAX error in endDocument()", (Exception)e);
        }
    }

    public void startPageSequence(String id) throws IFException {
        try {
            AttributesImpl atts = new AttributesImpl();
            if (id != null) {
                atts.addAttribute("http://www.w3.org/XML/1998/namespace", "id", "xml:id", "CDATA", id);
            }
            this.handler.startElement("pageSet", (Attributes)atts);
        }
        catch (SAXException e) {
            throw new IFException("SAX error in startPageSequence()", (Exception)e);
        }
    }

    public void endPageSequence() throws IFException {
        try {
            this.handler.endElement("pageSet");
        }
        catch (SAXException e) {
            throw new IFException("SAX error in endPageSequence()", (Exception)e);
        }
    }

    public void startPage(int index, String name, String pageMasterName, Dimension size) throws IFException {
        try {
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("http://xmlgraphics.apache.org/fop/intermediate", "width", "if:width", "CDATA", Integer.toString(size.width));
            atts.addAttribute("http://xmlgraphics.apache.org/fop/intermediate", "height", "if:height", "CDATA", Integer.toString(size.height));
            atts.addAttribute("http://xmlgraphics.apache.org/fop/intermediate", "viewBox", "if:viewBox", "CDATA", "0 0 " + Integer.toString(size.width) + " " + Integer.toString(size.height));
            this.handler.startElement("page", (Attributes)atts);
        }
        catch (SAXException e) {
            throw new IFException("SAX error in startPage()", (Exception)e);
        }
    }

    public void startPageHeader() throws IFException {
    }

    public void endPageHeader() throws IFException {
    }

    public IFPainter startPageContent() throws IFException {
        try {
            this.handler.startElement("g");
        }
        catch (SAXException e) {
            throw new IFException("SAX error in startPageContent()", (Exception)e);
        }
        return new SVGPainter(this, this.handler);
    }

    public void endPageContent() throws IFException {
        try {
            this.handler.endElement("g");
        }
        catch (SAXException e) {
            throw new IFException("SAX error in endPageContent()", (Exception)e);
        }
    }

    public void startPageTrailer() throws IFException {
    }

    public void endPageTrailer() throws IFException {
    }

    public void endPage() throws IFException {
        try {
            this.handler.endElement("page");
        }
        catch (SAXException e) {
            throw new IFException("SAX error in endPage()", (Exception)e);
        }
    }
}

