/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import org.scilab.forge.jlatexmath.Box;

public class GeoGebraLogoBox
extends Box {
    private static final Color gray = new Color(102, 102, 102);
    private static final Color blue = new Color(153, 153, 255);
    private static final BasicStroke st = new BasicStroke(3.8f, 0, 0, 4.0f);

    public GeoGebraLogoBox(float w, float h) {
        this.depth = 0.0f;
        this.height = h;
        this.width = w;
        this.shift = 0.0f;
    }

    @Override
    public void draw(Graphics2D g2, float x, float y) {
        AffineTransform oldAt = g2.getTransform();
        Color oldC = g2.getColor();
        Stroke oldS = g2.getStroke();
        g2.translate(x + 0.25f * this.height / 2.15f, y - 0.81395346f * this.height);
        g2.setColor(gray);
        g2.setStroke(st);
        g2.scale(0.05f * this.height / 2.15f, 0.05f * this.height / 2.15f);
        g2.rotate(-0.4537856055185257, 20.5, 17.5);
        g2.drawArc(0, 0, 43, 32, 0, 360);
        g2.rotate(0.4537856055185257, 20.5, 17.5);
        g2.setStroke(oldS);
        GeoGebraLogoBox.drawCircle(g2, 16.0f, -5.0f);
        GeoGebraLogoBox.drawCircle(g2, -1.0f, 7.0f);
        GeoGebraLogoBox.drawCircle(g2, 5.0f, 28.0f);
        GeoGebraLogoBox.drawCircle(g2, 27.0f, 24.0f);
        GeoGebraLogoBox.drawCircle(g2, 36.0f, 3.0f);
        g2.setStroke(oldS);
        g2.setTransform(oldAt);
        g2.setColor(oldC);
    }

    private static void drawCircle(Graphics2D g2, float x, float y) {
        g2.setColor(blue);
        g2.translate(x, y);
        g2.fillArc(0, 0, 8, 8, 0, 360);
        g2.setColor(Color.BLACK);
        g2.drawArc(0, 0, 8, 8, 0, 360);
        g2.translate(-x, -y);
    }

    @Override
    public int getLastFontId() {
        return 0;
    }
}

