/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox;

import com.thoughtworks.qdox.JavaClassContext;
import com.thoughtworks.qdox.Searcher;
import com.thoughtworks.qdox.directorywalker.DirectoryScanner;
import com.thoughtworks.qdox.directorywalker.FileVisitor;
import com.thoughtworks.qdox.directorywalker.SuffixFilter;
import com.thoughtworks.qdox.model.ClassLibrary;
import com.thoughtworks.qdox.model.DefaultDocletTagFactory;
import com.thoughtworks.qdox.model.DocletTagFactory;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaPackage;
import com.thoughtworks.qdox.model.JavaSource;
import com.thoughtworks.qdox.model.ModelBuilder;
import com.thoughtworks.qdox.parser.ParseException;
import com.thoughtworks.qdox.parser.impl.JFlexLexer;
import com.thoughtworks.qdox.parser.impl.Parser;
import com.thoughtworks.qdox.parser.structs.ClassDef;
import com.thoughtworks.qdox.parser.structs.FieldDef;
import com.thoughtworks.qdox.parser.structs.MethodDef;
import com.thoughtworks.qdox.parser.structs.PackageDef;
import com.thoughtworks.qdox.parser.structs.TypeDef;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public class JavaDocBuilder
implements Serializable {
    private final JavaClassContext context;
    private Set packages = new HashSet();
    private List sources = new ArrayList();
    private DocletTagFactory docletTagFactory;
    private String encoding = System.getProperty("file.encoding");
    private boolean debugLexer;
    private boolean debugParser;
    private ErrorHandler errorHandler = new DefaultErrorHandler();

    public JavaDocBuilder() {
        this(new DefaultDocletTagFactory());
    }

    public JavaDocBuilder(DocletTagFactory docletTagFactory) {
        this.docletTagFactory = docletTagFactory;
        ClassLibrary classLibrary = new ClassLibrary();
        classLibrary.addDefaultLoader();
        this.context = new JavaClassContext(this);
        this.context.setClassLibrary(classLibrary);
    }

    public JavaDocBuilder(ClassLibrary classLibrary) {
        this(new DefaultDocletTagFactory(), classLibrary);
    }

    public JavaDocBuilder(DocletTagFactory docletTagFactory, ClassLibrary classLibrary) {
        this.docletTagFactory = docletTagFactory;
        this.context = new JavaClassContext(this);
        this.context.setClassLibrary(classLibrary);
    }

    private void addClasses(JavaSource source) {
        HashSet resultSet = new HashSet();
        this.addClassesRecursive(source, resultSet);
        JavaClass[] javaClasses = resultSet.toArray(new JavaClass[resultSet.size()]);
        for (int classIndex = 0; classIndex < javaClasses.length; ++classIndex) {
            JavaClass cls = javaClasses[classIndex];
            this.addClass(cls);
        }
    }

    private void addClass(JavaClass cls) {
        this.context.add(cls);
        cls.setJavaClassContext(this.context);
    }

    public JavaClass getClassByName(String name) {
        if (name == null) {
            return null;
        }
        return this.context.getClassByName(name);
    }

    protected JavaClass createSourceClass(String name) {
        File sourceFile = this.context.getClassLibrary().getSourceFile(name);
        if (sourceFile != null) {
            try {
                JavaSource source = this.addSource(sourceFile);
                for (int index = 0; index < source.getClasses().length; ++index) {
                    JavaClass clazz = source.getClasses()[index];
                    if (!name.equals(clazz.getFullyQualifiedName())) continue;
                    return clazz;
                }
                return source.getNestedClassByName(name);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    protected JavaClass createUnknownClass(String name) {
        ModelBuilder unknownBuilder = new ModelBuilder(this.context, this.docletTagFactory, new HashMap());
        ClassDef classDef = new ClassDef();
        classDef.name = name;
        unknownBuilder.beginClass(classDef);
        unknownBuilder.endClass();
        JavaSource unknownSource = unknownBuilder.getSource();
        JavaClass result = unknownSource.getClasses()[0];
        return result;
    }

    protected JavaClass createBinaryClass(String name) {
        Class clazz = this.context.getClass(name);
        if (clazz == null) {
            return null;
        }
        try {
            Class<?> anInterface;
            ModelBuilder binaryBuilder = new ModelBuilder(this.context, this.docletTagFactory, new HashMap());
            String packageName = this.getPackageName(name);
            binaryBuilder.addPackage(new PackageDef(packageName));
            ClassDef classDef = new ClassDef();
            classDef.name = this.getClassName(name);
            Class<?>[] interfaces = clazz.getInterfaces();
            if (clazz.isInterface()) {
                classDef.type = "interface";
                for (int i = 0; i < interfaces.length; ++i) {
                    anInterface = interfaces[i];
                    classDef.extendz.add(new TypeDef(anInterface.getName()));
                }
            } else {
                for (int i = 0; i < interfaces.length; ++i) {
                    anInterface = interfaces[i];
                    classDef.implementz.add(new TypeDef(anInterface.getName()));
                }
                Class superclass = clazz.getSuperclass();
                if (superclass != null) {
                    classDef.extendz.add(new TypeDef(superclass.getName()));
                }
            }
            this.addModifiers(classDef.modifiers, clazz.getModifiers());
            binaryBuilder.beginClass(classDef);
            Constructor<?>[] constructors = clazz.getDeclaredConstructors();
            for (int i = 0; i < constructors.length; ++i) {
                this.addMethodOrConstructor(constructors[i], binaryBuilder);
            }
            Method[] methods = clazz.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                this.addMethodOrConstructor(methods[i], binaryBuilder);
            }
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                this.addField(fields[i], binaryBuilder);
            }
            binaryBuilder.endClass();
            JavaSource binarySource = binaryBuilder.getSource();
            JavaClass result = binarySource.getClasses()[0];
            return result;
        }
        catch (NoClassDefFoundError e) {
            return null;
        }
    }

    private void addModifiers(Set set, int modifier) {
        String modifierString = Modifier.toString(modifier);
        StringTokenizer stringTokenizer = new StringTokenizer(modifierString);
        while (stringTokenizer.hasMoreTokens()) {
            set.add(stringTokenizer.nextToken());
        }
    }

    private void addField(Field field, ModelBuilder binaryBuilder) {
        FieldDef fieldDef = new FieldDef();
        Class<?> fieldType = field.getType();
        fieldDef.name = field.getName();
        fieldDef.type = JavaDocBuilder.getTypeDef(fieldType);
        fieldDef.dimensions = JavaDocBuilder.getDimension(fieldType);
        this.addModifiers(fieldDef.modifiers, field.getModifiers());
        binaryBuilder.addField(fieldDef);
    }

    private void addMethodOrConstructor(Member member, ModelBuilder binaryBuilder) {
        int j;
        Class<?>[] parameterTypes;
        Class<?>[] exceptions;
        MethodDef methodDef = new MethodDef();
        int lastDot = member.getName().lastIndexOf(46);
        methodDef.name = member.getName().substring(lastDot + 1);
        this.addModifiers(methodDef.modifiers, member.getModifiers());
        if (member instanceof Method) {
            methodDef.constructor = false;
            exceptions = ((Method)member).getExceptionTypes();
            parameterTypes = ((Method)member).getParameterTypes();
            Class<?> returnType = ((Method)member).getReturnType();
            methodDef.returnType = JavaDocBuilder.getTypeDef(returnType);
            methodDef.dimensions = JavaDocBuilder.getDimension(returnType);
        } else {
            methodDef.constructor = true;
            exceptions = ((Constructor)member).getExceptionTypes();
            parameterTypes = ((Constructor)member).getParameterTypes();
        }
        for (j = 0; j < exceptions.length; ++j) {
            Class<?> exception = exceptions[j];
            methodDef.exceptions.add(exception.getName());
        }
        binaryBuilder.addMethod(methodDef);
        for (j = 0; j < parameterTypes.length; ++j) {
            FieldDef param = new FieldDef();
            Class<?> parameterType = parameterTypes[j];
            param.name = "p" + j;
            param.type = JavaDocBuilder.getTypeDef(parameterType);
            param.dimensions = JavaDocBuilder.getDimension(parameterType);
            binaryBuilder.addParameter(param);
        }
    }

    private static final int getDimension(Class c) {
        return c.getName().lastIndexOf(91) + 1;
    }

    private static String getTypeName(Class c) {
        return c.getComponentType() != null ? c.getComponentType().getName() : c.getName();
    }

    private static TypeDef getTypeDef(Class c) {
        return new TypeDef(JavaDocBuilder.getTypeName(c));
    }

    private String getPackageName(String fullClassName) {
        int lastDot = fullClassName.lastIndexOf(46);
        return lastDot == -1 ? "" : fullClassName.substring(0, lastDot);
    }

    private String getClassName(String fullClassName) {
        int lastDot = fullClassName.lastIndexOf(46);
        return lastDot == -1 ? fullClassName : fullClassName.substring(lastDot + 1);
    }

    public JavaSource addSource(Reader reader) {
        return this.addSource(reader, "UNKNOWN SOURCE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaSource addSource(Reader reader, String sourceInfo) {
        ModelBuilder builder = new ModelBuilder(this.context, this.docletTagFactory, null);
        JFlexLexer lexer = new JFlexLexer(reader);
        Parser parser = new Parser(lexer, builder);
        parser.setDebugLexer(this.debugLexer);
        parser.setDebugParser(this.debugParser);
        try {
            parser.parse();
        }
        catch (ParseException e) {
            e.setSourceInfo(sourceInfo);
            this.errorHandler.handle(e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {}
        }
        JavaSource source = builder.getSource();
        this.sources.add(source);
        this.addClasses(source);
        JavaPackage pkg = this.context.getPackageByName(source.getPackageName());
        if (!this.packages.contains(pkg)) {
            this.packages.add(pkg);
        }
        return source;
    }

    public JavaSource addSource(File file) throws IOException, FileNotFoundException {
        return this.addSource(file.toURL());
    }

    public JavaSource addSource(URL url) throws IOException, FileNotFoundException {
        JavaSource source = this.addSource(new InputStreamReader(url.openStream(), this.encoding), url.toExternalForm());
        source.setURL(url);
        return source;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public JavaSource[] getSources() {
        return this.sources.toArray(new JavaSource[this.sources.size()]);
    }

    public JavaClass[] getClasses() {
        HashSet resultSet = new HashSet();
        JavaSource[] javaSources = this.getSources();
        for (int i = 0; i < javaSources.length; ++i) {
            JavaSource javaSource = javaSources[i];
            this.addClassesRecursive(javaSource, resultSet);
        }
        JavaClass[] result = resultSet.toArray(new JavaClass[resultSet.size()]);
        return result;
    }

    public JavaPackage[] getPackages() {
        return this.packages.toArray(new JavaPackage[this.packages.size()]);
    }

    private void addClassesRecursive(JavaSource javaSource, Set resultSet) {
        JavaClass[] classes = javaSource.getClasses();
        for (int j = 0; j < classes.length; ++j) {
            JavaClass javaClass = classes[j];
            this.addClassesRecursive(javaClass, resultSet);
        }
    }

    private void addClassesRecursive(JavaClass javaClass, Set set) {
        set.add(javaClass);
        JavaClass[] innerClasses = javaClass.getNestedClasses();
        for (int i = 0; i < innerClasses.length; ++i) {
            JavaClass innerClass = innerClasses[i];
            this.addClassesRecursive(innerClass, set);
        }
    }

    public void addSourceTree(File file) {
        FileVisitor errorHandler = new FileVisitor(){

            @Override
            public void visitFile(File badFile) {
                throw new RuntimeException("Cannot read file : " + badFile.getName());
            }
        };
        this.addSourceTree(file, errorHandler);
    }

    public void addSourceTree(File file, final FileVisitor errorHandler) {
        DirectoryScanner scanner = new DirectoryScanner(file);
        scanner.addFilter(new SuffixFilter(".java"));
        scanner.scan(new FileVisitor(){

            @Override
            public void visitFile(File currentFile) {
                try {
                    JavaDocBuilder.this.addSource(currentFile);
                }
                catch (IOException e) {
                    errorHandler.visitFile(currentFile);
                }
            }
        });
    }

    public List search(Searcher searcher) {
        LinkedList<JavaClass> results = new LinkedList<JavaClass>();
        for (String clsName : this.context.getClassLibrary().all()) {
            JavaClass cls = this.getClassByName(clsName);
            if (!searcher.eval(cls)) continue;
            results.add(cls);
        }
        return results;
    }

    public ClassLibrary getClassLibrary() {
        return this.context.getClassLibrary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        ObjectOutputStream out = new ObjectOutputStream(fos);
        try {
            out.writeObject(this);
        }
        finally {
            out.close();
            fos.close();
        }
    }

    public static JavaDocBuilder load(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        ObjectInputStream in = new ObjectInputStream(fis);
        JavaDocBuilder builder = null;
        try {
            builder = (JavaDocBuilder)in.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new Error("Couldn't load class : " + e.getMessage());
        }
        finally {
            in.close();
            fis.close();
        }
        return builder;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setDebugLexer(boolean debugLexer) {
        this.debugLexer = debugLexer;
    }

    public void setDebugParser(boolean debugParser) {
        this.debugParser = debugParser;
    }

    public JavaPackage getPackageByName(String name) {
        if (name != null) {
            for (JavaPackage pkg : this.packages) {
                if (!name.equals(pkg.getName())) continue;
                return pkg;
            }
        }
        return null;
    }

    public static class DefaultErrorHandler
    implements ErrorHandler,
    Serializable {
        @Override
        public void handle(ParseException parseException) {
            throw parseException;
        }
    }

    public static interface ErrorHandler {
        public void handle(ParseException var1);
    }
}

