/*
 * Decompiled with CFR 0.152.
 */
package sax;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.ParserAdapter;
import org.xml.sax.helpers.ParserFactory;
import org.xml.sax.helpers.XMLReaderFactory;

public class DocumentTracer
extends DefaultHandler
implements ContentHandler,
DTDHandler,
ErrorHandler,
DeclHandler,
LexicalHandler,
DocumentHandler {
    protected static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected static final String NAMESPACE_PREFIXES_FEATURE_ID = "http://xml.org/sax/features/namespace-prefixes";
    protected static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String HONOUR_ALL_SCHEMA_LOCATIONS_ID = "http://apache.org/xml/features/honour-all-schemaLocations";
    protected static final String VALIDATE_ANNOTATIONS_ID = "http://apache.org/xml/features/validate-annotations";
    protected static final String DYNAMIC_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/dynamic";
    protected static final String LOAD_EXTERNAL_DTD_FEATURE_ID = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    protected static final String XINCLUDE_FEATURE_ID = "http://apache.org/xml/features/xinclude";
    protected static final String XINCLUDE_FIXUP_BASE_URIS_FEATURE_ID = "http://apache.org/xml/features/xinclude/fixup-base-uris";
    protected static final String XINCLUDE_FIXUP_LANGUAGE_FEATURE_ID = "http://apache.org/xml/features/xinclude/fixup-language";
    protected static final String LEXICAL_HANDLER_PROPERTY_ID = "http://xml.org/sax/properties/lexical-handler";
    protected static final String DEFAULT_PARSER_NAME = "org.apache.xerces.parsers.SAXParser";
    protected static final boolean DEFAULT_NAMESPACES = true;
    protected static final boolean DEFAULT_NAMESPACE_PREFIXES = false;
    protected static final boolean DEFAULT_VALIDATION = false;
    protected static final boolean DEFAULT_LOAD_EXTERNAL_DTD = true;
    protected static final boolean DEFAULT_SCHEMA_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_FULL_CHECKING = false;
    protected static final boolean DEFAULT_HONOUR_ALL_SCHEMA_LOCATIONS = false;
    protected static final boolean DEFAULT_VALIDATE_ANNOTATIONS = false;
    protected static final boolean DEFAULT_DYNAMIC_VALIDATION = false;
    protected static final boolean DEFAULT_XINCLUDE = false;
    protected static final boolean DEFAULT_XINCLUDE_FIXUP_BASE_URIS = true;
    protected static final boolean DEFAULT_XINCLUDE_FIXUP_LANGUAGE = true;
    protected PrintWriter fOut;
    protected int fIndent;

    public DocumentTracer() {
        this.setOutput(new PrintWriter(System.out));
    }

    public void setOutput(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        if (string == null) {
            string = "UTF8";
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string);
        this.fOut = new PrintWriter(outputStreamWriter);
    }

    public void setOutput(Writer writer) {
        this.fOut = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.printIndent();
        this.fOut.print("setDocumentLocator(");
        this.fOut.print("locator=");
        this.fOut.print(locator);
        this.fOut.println(')');
        this.fOut.flush();
    }

    @Override
    public void startDocument() throws SAXException {
        this.fIndent = 0;
        this.printIndent();
        this.fOut.println("startDocument()");
        this.fOut.flush();
        ++this.fIndent;
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
        this.printIndent();
        this.fOut.print("processingInstruction(");
        this.fOut.print("target=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("data=");
        this.printQuotedString(string2);
        this.fOut.println(')');
        this.fOut.flush();
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.printIndent();
        this.fOut.print("characters(");
        this.fOut.print("text=");
        this.printQuotedString(cArray, n, n2);
        this.fOut.println(')');
        this.fOut.flush();
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.printIndent();
        this.fOut.print("ignorableWhitespace(");
        this.fOut.print("text=");
        this.printQuotedString(cArray, n, n2);
        this.fOut.println(')');
        this.fOut.flush();
    }

    @Override
    public void endDocument() throws SAXException {
        --this.fIndent;
        this.printIndent();
        this.fOut.println("endDocument()");
        this.fOut.flush();
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
        this.printIndent();
        this.fOut.print("startPrefixMapping(");
        this.fOut.print("prefix=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("uri=");
        this.printQuotedString(string2);
        this.fOut.println(')');
        this.fOut.flush();
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.printIndent();
        this.fOut.print("startElement(");
        this.fOut.print("uri=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("localName=");
        this.printQuotedString(string2);
        this.fOut.print(',');
        this.fOut.print("qname=");
        this.printQuotedString(string3);
        this.fOut.print(',');
        this.fOut.print("attributes=");
        if (attributes == null) {
            this.fOut.println("null");
        } else {
            this.fOut.print('{');
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    this.fOut.print(',');
                }
                String string4 = attributes.getLocalName(i);
                String string5 = attributes.getQName(i);
                String string6 = attributes.getURI(i);
                String string7 = attributes.getType(i);
                String string8 = attributes.getValue(i);
                this.fOut.print('{');
                this.fOut.print("uri=");
                this.printQuotedString(string6);
                this.fOut.print(',');
                this.fOut.print("localName=");
                this.printQuotedString(string4);
                this.fOut.print(',');
                this.fOut.print("qname=");
                this.printQuotedString(string5);
                this.fOut.print(',');
                this.fOut.print("type=");
                this.printQuotedString(string7);
                this.fOut.print(',');
                this.fOut.print("value=");
                this.printQuotedString(string8);
                this.fOut.print('}');
            }
            this.fOut.print('}');
        }
        this.fOut.println(')');
        this.fOut.flush();
        ++this.fIndent;
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        --this.fIndent;
        this.printIndent();
        this.fOut.print("endElement(");
        this.fOut.print("uri=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("localName=");
        this.printQuotedString(string2);
        this.fOut.print(',');
        this.fOut.print("qname=");
        this.printQuotedString(string3);
        this.fOut.println(')');
        this.fOut.flush();
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
        this.printIndent();
        this.fOut.print("endPrefixMapping(");
        this.fOut.print("prefix=");
        this.printQuotedString(string);
        this.fOut.println(')');
        this.fOut.flush();
    }

    @Override
    public void skippedEntity(String string) throws SAXException {
        this.printIndent();
        this.fOut.print("skippedEntity(");
        this.fOut.print("name=");
        this.printQuotedString(string);
        this.fOut.println(')');
        this.fOut.flush();
    }

    @Override
    public void startElement(String string, AttributeList attributeList) throws SAXException {
        this.printIndent();
        this.fOut.print("startElement(");
        this.fOut.print("name=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("attributes=");
        if (attributeList == null) {
            this.fOut.println("null");
        } else {
            this.fOut.print('{');
            int n = attributeList.getLength();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    System.out.print(',');
                }
                String string2 = attributeList.getName(i);
                String string3 = attributeList.getType(i);
                String string4 = attributeList.getValue(i);
                this.fOut.print('{');
                this.fOut.print("name=");
                this.printQuotedString(string2);
                this.fOut.print(',');
                this.fOut.print("type=");
                this.printQuotedString(string3);
                this.fOut.print(',');
                this.fOut.print("value=");
                this.printQuotedString(string4);
                this.fOut.print('}');
            }
            this.fOut.print('}');
        }
        this.fOut.println(')');
        this.fOut.flush();
        ++this.fIndent;
    }

    @Override
    public void endElement(String string) throws SAXException {
        --this.fIndent;
        this.printIndent();
        this.fOut.print("endElement(");
        this.fOut.print("name=");
        this.printQuotedString(string);
        this.fOut.println(')');
        this.fOut.flush();
    }

    @Override
    public void notationDecl(String string, String string2, String string3) throws SAXException {
        this.printIndent();
        this.fOut.print("notationDecl(");
        this.fOut.print("name=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("publicId=");
        this.printQuotedString(string2);
        this.fOut.print(',');
        this.fOut.print("systemId=");
        this.printQuotedString(string3);
        this.fOut.println(')');
        this.fOut.flush();
    }

    @Override
    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
        this.printIndent();
        this.fOut.print("unparsedEntityDecl(");
        this.fOut.print("name=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("publicId=");
        this.printQuotedString(string2);
        this.fOut.print(',');
        this.fOut.print("systemId=");
        this.printQuotedString(string3);
        this.fOut.print(',');
        this.fOut.print("notationName=");
        this.printQuotedString(string4);
        this.fOut.println(')');
        this.fOut.flush();
    }

    @Override
    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.printIndent();
        this.fOut.print("startDTD(");
        this.fOut.print("name=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("publicId=");
        this.printQuotedString(string2);
        this.fOut.print(',');
        this.fOut.print("systemId=");
        this.printQuotedString(string3);
        this.fOut.println(')');
        this.fOut.flush();
        ++this.fIndent;
    }

    @Override
    public void startEntity(String string) throws SAXException {
        this.printIndent();
        this.fOut.print("startEntity(");
        this.fOut.print("name=");
        this.printQuotedString(string);
        this.fOut.println(')');
        this.fOut.flush();
        ++this.fIndent;
    }

    @Override
    public void startCDATA() throws SAXException {
        this.printIndent();
        this.fOut.println("startCDATA()");
        this.fOut.flush();
        ++this.fIndent;
    }

    @Override
    public void endCDATA() throws SAXException {
        --this.fIndent;
        this.printIndent();
        this.fOut.println("endCDATA()");
        this.fOut.flush();
    }

    @Override
    public void comment(char[] cArray, int n, int n2) throws SAXException {
        this.printIndent();
        this.fOut.print("comment(");
        this.fOut.print("text=");
        this.printQuotedString(cArray, n, n2);
        this.fOut.println(')');
        this.fOut.flush();
    }

    @Override
    public void endEntity(String string) throws SAXException {
        --this.fIndent;
        this.printIndent();
        this.fOut.print("endEntity(");
        this.fOut.print("name=");
        this.printQuotedString(string);
        this.fOut.println(')');
    }

    @Override
    public void endDTD() throws SAXException {
        --this.fIndent;
        this.printIndent();
        this.fOut.println("endDTD()");
        this.fOut.flush();
    }

    @Override
    public void elementDecl(String string, String string2) throws SAXException {
        this.printIndent();
        this.fOut.print("elementDecl(");
        this.fOut.print("name=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("contentModel=");
        this.printQuotedString(string2);
        this.fOut.println(')');
        this.fOut.flush();
    }

    @Override
    public void attributeDecl(String string, String string2, String string3, String string4, String string5) throws SAXException {
        this.printIndent();
        this.fOut.print("attributeDecl(");
        this.fOut.print("elementName=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("attributeName=");
        this.printQuotedString(string2);
        this.fOut.print(',');
        this.fOut.print("type=");
        this.printQuotedString(string3);
        this.fOut.print(',');
        this.fOut.print("valueDefault=");
        this.printQuotedString(string4);
        this.fOut.print(',');
        this.fOut.print("value=");
        this.printQuotedString(string5);
        this.fOut.println(')');
        this.fOut.flush();
    }

    @Override
    public void internalEntityDecl(String string, String string2) throws SAXException {
        this.printIndent();
        this.fOut.print("internalEntityDecl(");
        this.fOut.print("name=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("text=");
        this.printQuotedString(string2);
        this.fOut.println(')');
        this.fOut.flush();
    }

    @Override
    public void externalEntityDecl(String string, String string2, String string3) throws SAXException {
        this.printIndent();
        this.fOut.print("externalEntityDecl(");
        this.fOut.print("name=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("publicId=");
        this.printQuotedString(string2);
        this.fOut.print(',');
        this.fOut.print("systemId=");
        this.printQuotedString(string3);
        this.fOut.println(')');
        this.fOut.flush();
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.printError("Warning", sAXParseException);
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        this.printError("Error", sAXParseException);
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.printError("Fatal Error", sAXParseException);
        throw sAXParseException;
    }

    protected void printQuotedString(String string) {
        if (string == null) {
            this.fOut.print("null");
            return;
        }
        this.fOut.print('\"');
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            this.normalizeAndPrint(c);
        }
        this.fOut.print('\"');
    }

    protected void printQuotedString(char[] cArray, int n, int n2) {
        this.fOut.print('\"');
        for (int i = 0; i < n2; ++i) {
            this.normalizeAndPrint(cArray[n + i]);
        }
        this.fOut.print('\"');
    }

    protected void normalizeAndPrint(char c) {
        switch (c) {
            case '\n': {
                this.fOut.print("\\n");
                break;
            }
            case '\r': {
                this.fOut.print("\\r");
                break;
            }
            case '\t': {
                this.fOut.print("\\t");
                break;
            }
            case '\\': {
                this.fOut.print("\\\\");
                break;
            }
            case '\"': {
                this.fOut.print("\\\"");
                break;
            }
            default: {
                this.fOut.print(c);
            }
        }
    }

    protected void printError(String string, SAXParseException sAXParseException) {
        System.err.print("[");
        System.err.print(string);
        System.err.print("] ");
        String string2 = sAXParseException.getSystemId();
        if (string2 != null) {
            int n = string2.lastIndexOf(47);
            if (n != -1) {
                string2 = string2.substring(n + 1);
            }
            System.err.print(string2);
        }
        System.err.print(':');
        System.err.print(sAXParseException.getLineNumber());
        System.err.print(':');
        System.err.print(sAXParseException.getColumnNumber());
        System.err.print(": ");
        System.err.print(sAXParseException.getMessage());
        System.err.println();
        System.err.flush();
    }

    protected void printIndent() {
        for (int i = 0; i < this.fIndent; ++i) {
            this.fOut.print(' ');
        }
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            DocumentTracer.printUsage();
            System.exit(1);
        }
        DocumentTracer documentTracer = new DocumentTracer();
        PrintWriter printWriter = new PrintWriter(System.out);
        XMLReader xMLReader = null;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = true;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = true;
        boolean bl12 = true;
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            Object object2;
            String string = stringArray[i];
            if (string.startsWith("-")) {
                object2 = string.substring(1);
                if (((String)object2).equals("p")) {
                    if (++i == stringArray.length) {
                        System.err.println("error: Missing argument to -p option.");
                    }
                    object = stringArray[i];
                    try {
                        xMLReader = XMLReaderFactory.createXMLReader((String)object);
                    }
                    catch (Exception exception) {
                        try {
                            Parser parser = ParserFactory.makeParser((String)object);
                            xMLReader = new ParserAdapter(parser);
                            System.err.println("warning: Features and properties not supported on SAX1 parsers.");
                        }
                        catch (Exception exception2) {
                            xMLReader = null;
                            System.err.println("error: Unable to instantiate parser (" + (String)object + ")");
                        }
                    }
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("n")) {
                    bl = ((String)object2).equals("n");
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("np")) {
                    bl2 = ((String)object2).equals("np");
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("v")) {
                    bl3 = ((String)object2).equals("v");
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("xd")) {
                    bl4 = ((String)object2).equals("xd");
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("s")) {
                    bl5 = ((String)object2).equals("s");
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("f")) {
                    bl6 = ((String)object2).equals("f");
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("hs")) {
                    bl7 = ((String)object2).equals("hs");
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("va")) {
                    bl8 = ((String)object2).equals("va");
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("dv")) {
                    bl9 = ((String)object2).equals("dv");
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("xi")) {
                    bl10 = ((String)object2).equals("xi");
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("xb")) {
                    bl11 = ((String)object2).equals("xb");
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("xl")) {
                    bl12 = ((String)object2).equals("xl");
                    continue;
                }
                if (((String)object2).equals("h")) {
                    DocumentTracer.printUsage();
                    continue;
                }
            }
            if (xMLReader == null) {
                try {
                    xMLReader = XMLReaderFactory.createXMLReader(DEFAULT_PARSER_NAME);
                }
                catch (Exception exception) {
                    System.err.println("error: Unable to instantiate parser (org.apache.xerces.parsers.SAXParser)");
                    continue;
                }
            }
            try {
                xMLReader.setFeature(NAMESPACES_FEATURE_ID, bl);
            }
            catch (SAXException sAXException) {
                System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/namespaces)");
            }
            try {
                xMLReader.setFeature(NAMESPACE_PREFIXES_FEATURE_ID, bl2);
            }
            catch (SAXException sAXException) {
                System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/namespace-prefixes)");
            }
            try {
                xMLReader.setFeature(VALIDATION_FEATURE_ID, bl3);
            }
            catch (SAXException sAXException) {
                System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/validation)");
            }
            try {
                xMLReader.setFeature(LOAD_EXTERNAL_DTD_FEATURE_ID, bl4);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                System.err.println("warning: Parser does not recognize feature (http://apache.org/xml/features/nonvalidating/load-external-dtd)");
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/nonvalidating/load-external-dtd)");
            }
            try {
                xMLReader.setFeature(SCHEMA_VALIDATION_FEATURE_ID, bl5);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                System.err.println("warning: Parser does not recognize feature (http://apache.org/xml/features/validation/schema)");
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema)");
            }
            try {
                xMLReader.setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, bl6);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                System.err.println("warning: Parser does not recognize feature (http://apache.org/xml/features/validation/schema-full-checking)");
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema-full-checking)");
            }
            try {
                xMLReader.setFeature(HONOUR_ALL_SCHEMA_LOCATIONS_ID, bl7);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                System.err.println("warning: Parser does not recognize feature (http://apache.org/xml/features/honour-all-schemaLocations)");
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/honour-all-schemaLocations)");
            }
            try {
                xMLReader.setFeature(VALIDATE_ANNOTATIONS_ID, bl8);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                System.err.println("warning: Parser does not recognize feature (http://apache.org/xml/features/validate-annotations)");
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validate-annotations)");
            }
            try {
                xMLReader.setFeature(DYNAMIC_VALIDATION_FEATURE_ID, bl9);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                System.err.println("warning: Parser does not recognize feature (http://apache.org/xml/features/validation/dynamic)");
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/dynamic)");
            }
            try {
                xMLReader.setFeature(XINCLUDE_FEATURE_ID, bl10);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                System.err.println("warning: Parser does not recognize feature (http://apache.org/xml/features/xinclude)");
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/xinclude)");
            }
            try {
                xMLReader.setFeature(XINCLUDE_FIXUP_BASE_URIS_FEATURE_ID, bl11);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                System.err.println("warning: Parser does not recognize feature (http://apache.org/xml/features/xinclude/fixup-base-uris)");
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/xinclude/fixup-base-uris)");
            }
            try {
                xMLReader.setFeature(XINCLUDE_FIXUP_LANGUAGE_FEATURE_ID, bl12);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                System.err.println("warning: Parser does not recognize feature (http://apache.org/xml/features/xinclude/fixup-language)");
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/xinclude/fixup-language)");
            }
            xMLReader.setDTDHandler(documentTracer);
            xMLReader.setErrorHandler(documentTracer);
            if (xMLReader instanceof XMLReader) {
                xMLReader.setContentHandler(documentTracer);
                try {
                    xMLReader.setProperty("http://xml.org/sax/properties/declaration-handler", documentTracer);
                }
                catch (SAXException sAXException) {
                    sAXException.printStackTrace(System.err);
                }
                try {
                    xMLReader.setProperty(LEXICAL_HANDLER_PROPERTY_ID, documentTracer);
                }
                catch (SAXException sAXException) {
                    sAXException.printStackTrace(System.err);
                }
            } else {
                ((Parser)((Object)xMLReader)).setDocumentHandler(documentTracer);
            }
            try {
                xMLReader.parse(string);
                continue;
            }
            catch (SAXParseException sAXParseException) {
                continue;
            }
            catch (Exception exception) {
                System.err.println("error: Parse error occurred - " + exception.getMessage());
                if (exception instanceof SAXException && (object = ((SAXException)exception).getException()) != null) {
                    object2 = object;
                }
                ((Throwable)object2).printStackTrace(System.err);
            }
        }
    }

    private static void printUsage() {
        System.err.println("usage: java sax.DocumentTracer (options) uri ...");
        System.err.println();
        System.err.println("options:");
        System.err.println("  -p name     Select parser by name.");
        System.err.println("  -n  | -N    Turn on/off namespace processing.");
        System.err.println("  -np | -NP   Turn on/off namespace prefixes.");
        System.err.println("              NOTE: Requires use of -n.");
        System.err.println("  -v  | -V    Turn on/off validation.");
        System.err.println("  -xd | -XD   Turn on/off loading of external DTDs.");
        System.err.println("              NOTE: Always on when -v in use and not supported by all parsers.");
        System.err.println("  -s  | -S    Turn on/off Schema validation support.");
        System.err.println("              NOTE: Not supported by all parsers.");
        System.err.println("  -f  | -F    Turn on/off Schema full checking.");
        System.err.println("              NOTE: Requires use of -s and not supported by all parsers.");
        System.err.println("  -hs | -HS   Turn on/off honouring of all schema locations.");
        System.err.println("              NOTE: Requires use of -s and not supported by all parsers.");
        System.err.println("  -va | -VA   Turn on/off validation of schema annotations.");
        System.err.println("              NOTE: Requires use of -s and not supported by all parsers.");
        System.err.println("  -dv | -DV   Turn on/off dynamic validation.");
        System.err.println("              NOTE: Not supported by all parsers.");
        System.err.println("  -xi | -XI   Turn on/off XInclude processing.");
        System.err.println("              NOTE: Not supported by all parsers.");
        System.err.println("  -xb | -XB   Turn on/off base URI fixup during XInclude processing.");
        System.err.println("              NOTE: Requires use of -xi and not supported by all parsers.");
        System.err.println("  -xl | -XL   Turn on/off language fixup during XInclude processing.");
        System.err.println("              NOTE: Requires use of -xi and not supported by all parsers.");
        System.err.println("  -h          This help screen.");
        System.err.println();
        System.err.println("defaults:");
        System.err.println("  Parser:     org.apache.xerces.parsers.SAXParser");
        System.err.print("  Namespaces: ");
        System.err.println("on");
        System.err.print("  Prefixes:   ");
        System.err.println("off");
        System.err.print("  Validation: ");
        System.err.println("off");
        System.err.print("  Load External DTD: ");
        System.err.println("on");
        System.err.print("  Schema:     ");
        System.err.println("off");
        System.err.print("  Schema full checking:            ");
        System.err.println("off");
        System.err.print("  Honour all schema locations:     ");
        System.err.println("off");
        System.err.print("  Validate annotations:            ");
        System.err.println("off");
        System.err.print("  Dynamic:    ");
        System.err.println("off");
        System.err.print("  XInclude:   ");
        System.err.println("off");
        System.err.print("  XInclude base URI fixup:  ");
        System.err.println("on");
        System.err.print("  XInclude language fixup:  ");
        System.err.println("on");
    }
}

