/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.ImageIcon;
import net.sourceforge.plantuml.Log;

public class FileUtils {
    private static AtomicInteger counter;

    public static void resetCounter() {
        counter = new AtomicInteger(0);
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        File f;
        if (!suffix.startsWith(".")) {
            throw new IllegalArgumentException();
        }
        if (prefix == null) {
            throw new IllegalArgumentException();
        }
        if (counter == null) {
            f = File.createTempFile(prefix, suffix);
        } else {
            String name = prefix + counter.addAndGet(1) + suffix;
            f = new File(name);
        }
        Log.info("Creating temporary file: " + f);
        f.deleteOnExit();
        return f;
    }

    private static void copyInternal(InputStream fis, OutputStream fos) throws IOException {
        int len;
        byte[] buf = new byte[10240];
        while ((len = fis.read(buf)) > 0) {
            fos.write(buf, 0, len);
        }
        fos.close();
        fis.close();
    }

    public static void copyToFile(File src, File dest) throws IOException {
        if (dest.isDirectory()) {
            dest = new File(dest, src.getName());
        }
        BufferedInputStream fis = new BufferedInputStream(new FileInputStream(src));
        BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(dest));
        FileUtils.copyInternal(fis, fos);
    }

    public static void copyToStream(File src, OutputStream os) throws IOException {
        BufferedInputStream fis = new BufferedInputStream(new FileInputStream(src));
        BufferedOutputStream fos = new BufferedOutputStream(os);
        FileUtils.copyInternal(fis, fos);
    }

    public static void copyToStream(InputStream is, OutputStream os) throws IOException {
        BufferedInputStream fis = new BufferedInputStream(is);
        BufferedOutputStream fos = new BufferedOutputStream(os);
        FileUtils.copyInternal(fis, fos);
    }

    public static void copyToFile(byte[] src, File dest) throws IOException {
        BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(dest));
        ((OutputStream)fos).write(src);
        ((OutputStream)fos).close();
    }

    public static String readSvg(File svgFile) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(svgFile));
        return FileUtils.readSvg(br, false, true);
    }

    public static String readSvg(InputStream is) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        return FileUtils.readSvg(br, false, false);
    }

    public static String readFile(File svgFile) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(svgFile));
        return FileUtils.readSvg(br, true, true);
    }

    private static String readSvg(BufferedReader br, boolean withNewline, boolean withClose) throws IOException {
        String s;
        StringBuilder sb = new StringBuilder();
        while ((s = br.readLine()) != null) {
            sb.append(s);
            if (!withNewline) continue;
            sb.append("\n");
        }
        if (withClose) {
            br.close();
        }
        return sb.toString();
    }

    public static BufferedImage ImageIO_read(File f) {
        try {
            return FileUtils.readImage(new ImageIcon(f.getAbsolutePath()));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static BufferedImage ImageIO_read(URL url) {
        try {
            return FileUtils.readImage(new ImageIcon(url));
        }
        catch (Exception e) {
            return null;
        }
    }

    private static BufferedImage readImage(ImageIcon imageIcon) {
        Image tmpImage = imageIcon.getImage();
        BufferedImage image = new BufferedImage(imageIcon.getIconWidth(), imageIcon.getIconHeight(), 2);
        image.getGraphics().drawImage(tmpImage, 0, 0, null);
        tmpImage.flush();
        return image;
    }
}

