/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.core;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.CharSequence2;
import net.sourceforge.plantuml.CharSequence2Impl;
import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.core.DiagramType;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.utils.StartUtils;
import net.sourceforge.plantuml.version.IteratorCounter2;
import net.sourceforge.plantuml.version.IteratorCounter2Impl;

public final class UmlSource {
    private final List<CharSequence2> source;

    public UmlSource removeInitialSkinparam() {
        if (!UmlSource.hasInitialSkinparam(this.source)) {
            return this;
        }
        ArrayList<CharSequence2> copy = new ArrayList<CharSequence2>(this.source);
        while (UmlSource.hasInitialSkinparam(copy)) {
            copy.remove(1);
        }
        return new UmlSource(copy);
    }

    public boolean containsIgnoreCase(String searched) {
        for (CharSequence2 s : this.source) {
            if (!StringUtils.goLowerCase(s.toString()).contains(searched)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasInitialSkinparam(List<CharSequence2> copy) {
        return copy.size() > 1 && (copy.get(1).startsWith("skinparam ") || copy.get(1).startsWith("skinparamlocked "));
    }

    private UmlSource(List<CharSequence2> source) {
        this.source = source;
    }

    public UmlSource(List<CharSequence2> data, boolean checkEndingBackslash) {
        this(new ArrayList<CharSequence2>());
        if (checkEndingBackslash) {
            StringBuilder pending = new StringBuilder();
            for (CharSequence2 cs : data) {
                String s = cs.toString2();
                if (StringUtils.endsWithBackslash(s)) {
                    pending.append(s.substring(0, s.length() - 1));
                    continue;
                }
                pending.append(s);
                this.source.add(new CharSequence2Impl(pending.toString(), cs.getLocation()));
                pending.setLength(0);
            }
        } else {
            this.source.addAll(data);
        }
    }

    public DiagramType getDiagramType() {
        return DiagramType.getTypeFromArobaseStart(this.source.get(0).toString2());
    }

    public IteratorCounter2 iterator2() {
        return new IteratorCounter2Impl(this.source);
    }

    public String getPlainString() {
        StringBuilder sb = new StringBuilder();
        for (CharSequence2 s : this.source) {
            sb.append(s);
            sb.append('\r');
            sb.append('\n');
        }
        return sb.toString();
    }

    public long seed() {
        long h = 1125899906842597L;
        String string = this.getPlainString();
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            h = 31L * h + (long)string.charAt(i);
        }
        return h;
    }

    public String getLine(LineLocation n) {
        for (CharSequence2 s : this.source) {
            if (s.getLocation().compareTo(n) != 0) continue;
            return s.toString();
        }
        return null;
    }

    public int getTotalLineCount() {
        return this.source.size();
    }

    public boolean isEmpty() {
        for (CharSequence2 s : this.source) {
            if (StartUtils.isArobaseStartDiagram(s) || StartUtils.isArobaseEndDiagram(s) || s.toString().matches("\\s*'.*") || StringUtils.trin(s).length() == 0) continue;
            return false;
        }
        return true;
    }

    public Display getTitle() {
        Pattern2 p = MyPattern.cmpile("(?i)^[%s]*title[%s]+(.+)$");
        for (CharSequence2 s : this.source) {
            Matcher2 m = p.matcher(s);
            boolean ok = m.matches();
            if (!ok) continue;
            return Display.create(m.group(1));
        }
        return Display.empty();
    }

    public boolean isStartDef() {
        return this.source.get(0).startsWith("@startdef");
    }

    public String getId() {
        Pattern p = Pattern.compile("id=([\\w]+)\\b");
        Matcher m = p.matcher(this.source.get(0));
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }
}

