/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.turing;

import net.sourceforge.plantuml.turing.BFToken;

public class BFMachine {
    private final char[] cells = new char[30000];
    private final BFToken[] prg;
    private int prgPointer;
    private int pointer;
    private final StringBuilder output = new StringBuilder();
    private final String input;
    private int inputPointer;

    public BFMachine(String program, String input) {
        this.prg = new BFToken[program.length() + 1];
        int i = 0;
        for (int n = 0; n < program.length(); ++n) {
            BFToken token = BFToken.getToken(program.charAt(n));
            if (token == null) continue;
            this.prg[i++] = token;
        }
        this.input = input;
    }

    public boolean run() {
        for (int i = 0; i < 10000000; ++i) {
            if (this.prg[this.prgPointer] == null) {
                return true;
            }
            this.interpret(this.prg[this.prgPointer]);
            ++this.prgPointer;
        }
        return false;
    }

    private void interpret(BFToken token) {
        switch (token) {
            case NEXT: {
                ++this.pointer;
                break;
            }
            case PREVIOUS: {
                --this.pointer;
                break;
            }
            case PLUS: {
                int n = this.pointer;
                this.cells[n] = (char)(this.cells[n] + '\u0001');
                break;
            }
            case MINUS: {
                int n = this.pointer;
                this.cells[n] = (char)(this.cells[n] - '\u0001');
                break;
            }
            case OUTPUT: {
                this.output(this.cells[this.pointer]);
                break;
            }
            case INPUT: {
                int read = this.input();
                if (read == -1) break;
                this.cells[this.pointer] = (char)read;
                break;
            }
            case BRACKET_LEFT: {
                if (this.cells[this.pointer] != '\u0000') break;
                int i = 1;
                while (i > 0) {
                    BFToken c2;
                    if ((c2 = this.prg[++this.prgPointer]) == BFToken.BRACKET_LEFT) {
                        ++i;
                        continue;
                    }
                    if (c2 != BFToken.BRACKET_RIGHT) continue;
                    --i;
                }
                break;
            }
            case BRACKET_RIGHT: {
                int i = 1;
                while (i > 0) {
                    BFToken c2;
                    if ((c2 = this.prg[--this.prgPointer]) == BFToken.BRACKET_LEFT) {
                        --i;
                        continue;
                    }
                    if (c2 != BFToken.BRACKET_RIGHT) continue;
                    ++i;
                }
                --this.prgPointer;
            }
        }
    }

    private int input() {
        if (this.inputPointer < this.input.length()) {
            return this.input.charAt(this.inputPointer++);
        }
        return -1;
    }

    private void output(char c) {
        this.output.append(c);
    }

    public String getOutput() {
        return this.output.toString();
    }
}

