/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pcl.fonts;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.fop.fonts.MultiByteFont;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.fonts.truetype.FontFileReader;
import org.apache.fop.fonts.truetype.OpenFont;
import org.apache.fop.render.java2d.CustomFontMetricsMapper;

public class PCLSoftFont {
    private int fontID;
    private Typeface font;
    private Map<Integer, int[]> charOffsets;
    private OpenFont openFont;
    private InputStream fontStream;
    private FontFileReader reader;
    private Map<Integer, Integer> charsWritten;
    private Map<Character, Integer> mappedChars;
    private Map<Integer, Integer> charMtxPositions;
    private boolean multiByteFont;
    private int charCount = 32;

    public PCLSoftFont(int fontID, Typeface font, boolean multiByteFont) {
        this.fontID = fontID;
        this.font = font;
        this.charsWritten = new HashMap<Integer, Integer>();
        this.mappedChars = new HashMap<Character, Integer>();
        this.multiByteFont = multiByteFont;
    }

    public Typeface getTypeface() {
        return this.font;
    }

    public int getFontID() {
        return this.fontID;
    }

    public void setCharacterOffsets(Map<Integer, int[]> charOffsets) {
        this.charOffsets = charOffsets;
    }

    public Map<Integer, int[]> getCharacterOffsets() {
        return this.charOffsets;
    }

    public OpenFont getOpenFont() {
        return this.openFont;
    }

    public void setOpenFont(OpenFont openFont) {
        this.openFont = openFont;
    }

    public InputStream getFontStream() {
        return this.fontStream;
    }

    public void setFontStream(InputStream fontStream) {
        this.fontStream = fontStream;
    }

    public FontFileReader getReader() {
        return this.reader;
    }

    public void setReader(FontFileReader reader) {
        this.reader = reader;
    }

    public void writeCharacter(int unicode) {
        this.charsWritten.put(unicode, this.charCount++);
    }

    public int getUnicodeCodePoint(int unicode) {
        if (this.charsWritten.containsKey(unicode)) {
            return this.charsWritten.get(unicode);
        }
        return -1;
    }

    public boolean hasPreviouslyWritten(int unicode) {
        return this.charsWritten.containsKey(unicode);
    }

    public int getMtxCharIndex(int unicode) {
        if (this.charMtxPositions.get(unicode) != null) {
            return this.charMtxPositions.get(unicode);
        }
        return 0;
    }

    public int getCmapGlyphIndex(int unicode) {
        CustomFontMetricsMapper customFont;
        Typeface realFont;
        if (this.font instanceof CustomFontMetricsMapper && (realFont = (customFont = (CustomFontMetricsMapper)this.font).getRealFont()) instanceof MultiByteFont) {
            MultiByteFont mbFont = (MultiByteFont)realFont;
            return mbFont.findGlyphIndex(unicode);
        }
        return 0;
    }

    public void setMtxCharIndexes(Map<Integer, Integer> charMtxPositions) {
        this.charMtxPositions = charMtxPositions;
    }

    public int getCharCount() {
        return this.charCount;
    }

    public void setMappedChars(Map<Character, Integer> mappedChars) {
        this.mappedChars = mappedChars;
    }

    public Map<Character, Integer> getMappedChars() {
        return this.mappedChars;
    }

    public int getCharIndex(char ch) {
        if (this.mappedChars.containsKey(Character.valueOf(ch))) {
            return this.mappedChars.get(Character.valueOf(ch));
        }
        return -1;
    }

    public int getCharCode(char ch) {
        if (this.multiByteFont) {
            return this.getCharIndex(ch);
        }
        return this.getUnicodeCodePoint(ch);
    }
}

