/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.bitmap;

public enum TIFFCompressionValue {
    NONE("NONE"),
    JPEG("JPEG"),
    PACKBITS("PackBits"),
    DEFLATE("Deflate"),
    LZW("LZW"),
    ZLIB("ZLib"),
    CCITT_T4("CCITT T.4", 12, true),
    CCITT_T6("CCITT T.6", 12, true);

    private final String name;
    private final int imageType;
    private boolean isCcitt;

    private TIFFCompressionValue(String name, int imageType, boolean isCcitt) {
        this.name = name;
        this.imageType = imageType;
        this.isCcitt = isCcitt;
    }

    private TIFFCompressionValue(String name) {
        this(name, 2, false);
    }

    String getName() {
        return this.name;
    }

    int getImageType() {
        return this.imageType;
    }

    boolean hasCCITTCompression() {
        return this.isCcitt;
    }

    static TIFFCompressionValue getType(String name) {
        for (TIFFCompressionValue tiffConst : TIFFCompressionValue.values()) {
            if (!tiffConst.name.equalsIgnoreCase(name)) continue;
            return tiffConst;
        }
        return null;
    }
}

