/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.creole.Command;
import net.sourceforge.plantuml.creole.CommandCreoleImg;
import net.sourceforge.plantuml.creole.StripeSimple;

public class CommandCreoleSprite
implements Command {
    private final Pattern2 pattern;

    private CommandCreoleSprite(String p) {
        this.pattern = MyPattern.cmpile(p);
    }

    public static Command create() {
        return new CommandCreoleSprite("^(?i)(\\<\\$([-\\p{L}0-9_/]+)((?:\\{scale=|\\*)(?:[0-9.]+)\\}?)?\\>)");
    }

    @Override
    public int matchingSize(String line) {
        Matcher2 m = this.pattern.matcher(line);
        if (!m.find()) {
            return 0;
        }
        return m.group(1).length();
    }

    @Override
    public String executeAndGetRemaining(String line, StripeSimple stripe) {
        Matcher2 m = this.pattern.matcher(line);
        if (!m.find()) {
            throw new IllegalStateException();
        }
        String src = m.group(2);
        double scale = CommandCreoleImg.getScale(m.group(3), 1.0);
        stripe.addSprite(src, scale);
        return line.substring(m.group(1).length());
    }
}

