/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

import java.io.IOException;
import net.sourceforge.plantuml.CharSequence2;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.preproc.DefinesGet;
import net.sourceforge.plantuml.preproc.IfManagerNegatif;
import net.sourceforge.plantuml.preproc.IfManagerPositif;
import net.sourceforge.plantuml.preproc.NumericCompare;
import net.sourceforge.plantuml.preproc.ReadLine;
import net.sourceforge.plantuml.preproc.ReadLineInstrumented;
import net.sourceforge.plantuml.version.Version;

public class IfManager
extends ReadLineInstrumented
implements ReadLine {
    protected static final Pattern2 ifdefPattern = MyPattern.cmpile("^[%s]*!if(n)?def[%s]+(.+)$");
    protected static final Pattern2 ifcomparePattern = MyPattern.cmpile("^[%s]*!if[%s]+\\%(\\w+)\\%[%s]*(\\<|\\<=|\\>|\\>=|=|==|!=|\\<\\>)[%s]*(\\d+)$");
    protected static final Pattern2 elsePattern = MyPattern.cmpile("^[%s]*!else[%s]*$");
    protected static final Pattern2 endifPattern = MyPattern.cmpile("^[%s]*!endif[%s]*$");
    private final DefinesGet defines;
    private final ReadLine source;
    private IfManager child;

    public IfManager(ReadLine source, DefinesGet defines) {
        this.defines = defines;
        this.source = source;
    }

    @Override
    final CharSequence2 readLineInst() throws IOException {
        if (this.child != null) {
            CharSequence2 s = this.child.readLine();
            if (s != null) {
                return s;
            }
            this.child = null;
        }
        return this.readLineInternal();
    }

    protected CharSequence2 readLineInternal() throws IOException {
        CharSequence2 s = this.source.readLine();
        if (s == null) {
            return null;
        }
        Matcher2 m = ifcomparePattern.matcher(s);
        if (m.find()) {
            int value2;
            int value1 = this.getValue(m.group(1));
            String operator = m.group(2);
            boolean ok = new NumericCompare(operator).isCompareOk(value1, value2 = Integer.parseInt(m.group(3)));
            this.child = ok ? new IfManagerPositif(this.source, this.defines) : new IfManagerNegatif(this.source, this.defines);
            return this.readLine();
        }
        m = ifdefPattern.matcher(s);
        if (m.find()) {
            boolean ok = this.defines.get().isDefine(m.group(2));
            if (m.group(1) != null) {
                ok = !ok;
            }
            this.child = ok ? new IfManagerPositif(this.source, this.defines) : new IfManagerNegatif(this.source, this.defines);
            return this.readLine();
        }
        return s;
    }

    private int getValue(String arg) {
        if (arg.equalsIgnoreCase("PLANTUML_VERSION")) {
            return Version.versionPatched();
        }
        return 0;
    }

    @Override
    void closeInst() throws IOException {
        this.source.close();
    }
}

