/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.g2d;

import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import net.sourceforge.plantuml.golem.MinMaxDouble;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorGradient;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.USegment;
import net.sourceforge.plantuml.ugraphic.USegmentType;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.arc.ExtendedGeneralPath;
import net.sourceforge.plantuml.ugraphic.g2d.DriverLineG2d;
import net.sourceforge.plantuml.ugraphic.g2d.DriverShadowedG2d;

public class DriverPathG2d
extends DriverShadowedG2d
implements UDriver<Graphics2D> {
    private final double dpiFactor;

    public DriverPathG2d(double dpiFactor) {
        this.dpiFactor = dpiFactor;
    }

    @Override
    public void draw(UShape ushape, double x, double y, ColorMapper mapper, UParam param, Graphics2D g2d) {
        UPath shape = (UPath)ushape;
        DriverLineG2d.manageStroke(param, g2d);
        ExtendedGeneralPath p = new ExtendedGeneralPath();
        MinMaxDouble minMax = new MinMaxDouble();
        minMax.manage(x, y);
        boolean slowShadow = false;
        for (USegment seg : shape) {
            USegmentType type = seg.getSegmentType();
            double[] coord = seg.getCoord();
            if (type == USegmentType.SEG_MOVETO) {
                p.moveTo(x + coord[0], y + coord[1]);
                minMax.manage(x + coord[0], y + coord[1]);
                continue;
            }
            if (type == USegmentType.SEG_LINETO) {
                p.lineTo(x + coord[0], y + coord[1]);
                minMax.manage(x + coord[0], y + coord[1]);
                continue;
            }
            if (type == USegmentType.SEG_CUBICTO) {
                p.curveTo(x + coord[0], y + coord[1], x + coord[2], y + coord[3], x + coord[4], y + coord[5]);
                minMax.manage(x + coord[4], y + coord[5]);
                slowShadow = true;
                continue;
            }
            if (type == USegmentType.SEG_ARCTO) {
                p.arcTo(coord[0], coord[1], coord[2], coord[3] != 0.0, coord[4] != 0.0, x + coord[5], y + coord[6]);
                continue;
            }
            throw new UnsupportedOperationException();
        }
        if (shape.isOpenIconic()) {
            p.closePath();
            g2d.setColor(mapper.getMappedColor(param.getColor()));
            g2d.fill(p);
            return;
        }
        HtmlColor back = param.getBackcolor();
        if (back != null) {
            slowShadow = true;
        }
        if (shape.getDeltaShadow() != 0.0) {
            if (slowShadow) {
                this.drawShadow(g2d, p, shape.getDeltaShadow(), this.dpiFactor);
            } else {
                double lastX = 0.0;
                double lastY = 0.0;
                for (USegment seg : shape) {
                    USegmentType type = seg.getSegmentType();
                    double[] coord = seg.getCoord();
                    if (type == USegmentType.SEG_MOVETO) {
                        lastX = x + coord[0];
                        lastY = y + coord[1];
                        continue;
                    }
                    if (type == USegmentType.SEG_LINETO) {
                        Line2D.Double line = new Line2D.Double(lastX, lastY, x + coord[0], y + coord[1]);
                        this.drawShadow(g2d, line, shape.getDeltaShadow(), this.dpiFactor);
                        lastX = x + coord[0];
                        lastY = y + coord[1];
                        continue;
                    }
                    throw new UnsupportedOperationException();
                }
            }
        }
        if (back instanceof HtmlColorGradient) {
            HtmlColorGradient gr = (HtmlColorGradient)back;
            char policy = gr.getPolicy();
            GradientPaint paint = policy == '|' ? new GradientPaint((float)minMax.getMinX(), (float)minMax.getMaxY() / 2.0f, mapper.getMappedColor(gr.getColor1()), (float)minMax.getMaxX(), (float)minMax.getMaxY() / 2.0f, mapper.getMappedColor(gr.getColor2())) : (policy == '\\' ? new GradientPaint((float)minMax.getMinX(), (float)minMax.getMaxY(), mapper.getMappedColor(gr.getColor1()), (float)minMax.getMaxX(), (float)minMax.getMinY(), mapper.getMappedColor(gr.getColor2())) : (policy == '-' ? new GradientPaint((float)minMax.getMaxX() / 2.0f, (float)minMax.getMinY(), mapper.getMappedColor(gr.getColor1()), (float)minMax.getMaxX() / 2.0f, (float)minMax.getMaxY(), mapper.getMappedColor(gr.getColor2())) : new GradientPaint((float)x, (float)y, mapper.getMappedColor(gr.getColor1()), (float)minMax.getMaxX(), (float)minMax.getMaxY(), mapper.getMappedColor(gr.getColor2()))));
            g2d.setPaint(paint);
            g2d.fill(p);
        } else if (back != null) {
            g2d.setColor(mapper.getMappedColor(back));
            g2d.fill(p);
        }
        if (param.getColor() != null) {
            g2d.setColor(mapper.getMappedColor(param.getColor()));
            g2d.draw(p);
        }
    }
}

