/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.svg;

import java.awt.Rectangle;
import java.io.IOException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.image.loader.batik.BatikImageFlavors;
import org.apache.fop.render.ImageHandler;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.intermediate.DelegatingFragmentContentHandler;
import org.apache.fop.render.svg.SVGConstants;
import org.apache.fop.render.svg.SVGRenderingContext;
import org.apache.fop.render.svg.SVGUtil;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.impl.ImageRawStream;
import org.apache.xmlgraphics.image.loader.impl.ImageXMLDOM;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class EmbeddedSVGImageHandler
implements ImageHandler,
SVGConstants {
    private static Log log = LogFactory.getLog(EmbeddedSVGImageHandler.class);
    private static final String CDATA = "CDATA";

    public int getPriority() {
        return 500;
    }

    public Class getSupportedImageClass() {
        return ImageRawStream.class;
    }

    public ImageFlavor[] getSupportedImageFlavors() {
        return new ImageFlavor[]{BatikImageFlavors.SVG_DOM};
    }

    public void handleImage(RenderingContext context, Image image, final Rectangle pos) throws IOException {
        SVGRenderingContext svgContext = (SVGRenderingContext)context;
        if (!(image instanceof ImageXMLDOM)) {
            throw new IllegalStateException();
        }
        ImageXMLDOM svg = (ImageXMLDOM)image;
        ContentHandler handler = svgContext.getContentHandler();
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "x", "x", CDATA, SVGUtil.formatMptToPt(pos.x));
        atts.addAttribute("", "y", "y", CDATA, SVGUtil.formatMptToPt(pos.y));
        atts.addAttribute("", "width", "width", CDATA, SVGUtil.formatMptToPt(pos.width));
        atts.addAttribute("", "height", "height", CDATA, SVGUtil.formatMptToPt(pos.height));
        try {
            Document doc = svg.getDocument();
            Element svgEl = doc.getDocumentElement();
            if (svgEl.getAttribute("viewBox").length() == 0) {
                log.warn((Object)"SVG doesn't have a viewBox. The result might not be scaled correctly!");
            }
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            DOMSource src = new DOMSource(svg.getDocument());
            SAXResult res = new SAXResult((ContentHandler)new DelegatingFragmentContentHandler(handler){
                private boolean topLevelSVGFound;

                private void setAttribute(AttributesImpl atts, String localName, String value) {
                    int index = atts.getIndex("", localName);
                    if (index < 0) {
                        atts.addAttribute("", localName, localName, EmbeddedSVGImageHandler.CDATA, value);
                    } else {
                        atts.setAttribute(index, "", localName, localName, EmbeddedSVGImageHandler.CDATA, value);
                    }
                }

                public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
                    if (!this.topLevelSVGFound && SVGConstants.SVG_ELEMENT.getNamespaceURI().equals(uri) && SVGConstants.SVG_ELEMENT.getLocalName().equals(localName)) {
                        this.topLevelSVGFound = true;
                        AttributesImpl modAtts = new AttributesImpl(atts);
                        this.setAttribute(modAtts, "x", SVGUtil.formatMptToPt(pos.x));
                        this.setAttribute(modAtts, "y", SVGUtil.formatMptToPt(pos.y));
                        this.setAttribute(modAtts, "width", SVGUtil.formatMptToPt(pos.width));
                        this.setAttribute(modAtts, "height", SVGUtil.formatMptToPt(pos.height));
                        super.startElement(uri, localName, name, (Attributes)modAtts);
                    } else {
                        super.startElement(uri, localName, name, atts);
                    }
                }
            });
            transformer.transform(src, res);
        }
        catch (TransformerException te) {
            throw new IOException(te.getMessage());
        }
    }

    public boolean isCompatible(RenderingContext targetContext, Image image) {
        if (targetContext instanceof SVGRenderingContext) {
            if (image == null) {
                return true;
            }
            if (image instanceof ImageXMLDOM) {
                ImageXMLDOM svg = (ImageXMLDOM)image;
                return "http://www.w3.org/2000/svg".equals(svg.getRootNamespace());
            }
        }
        return false;
    }
}

