/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area;

import java.util.ArrayList;
import java.util.List;
import org.apache.fop.area.Area;
import org.apache.fop.area.BodyRegion;
import org.apache.fop.area.Span;
import org.apache.fop.area.Trait;
import org.apache.fop.traits.WritingModeTraitsGetter;

public class MainReference
extends Area {
    private static final long serialVersionUID = 7635126485620012448L;
    private BodyRegion parent;
    private List<Span> spanAreas = new ArrayList<Span>();
    private boolean isEmpty = true;
    private transient WritingModeTraitsGetter wmtg;

    public MainReference(BodyRegion parent) {
        this.parent = parent;
        this.addTrait(Trait.IS_REFERENCE_AREA, Boolean.TRUE);
    }

    public Span createSpan(boolean spanAll) {
        if (this.spanAreas.size() > 0 && this.getCurrentSpan().isEmpty()) {
            this.spanAreas.remove(this.spanAreas.size() - 1);
        }
        Span newSpan = new Span(spanAll ? 1 : this.getColumnCount(), this.getColumnGap(), this.parent.getContentIPD());
        this.spanAreas.add(newSpan);
        if (this.wmtg != null) {
            newSpan.setWritingModeTraits(this.wmtg);
        }
        return this.getCurrentSpan();
    }

    public List<Span> getSpans() {
        return this.spanAreas;
    }

    public void setSpans(List<Span> spans) {
        this.spanAreas = new ArrayList<Span>(spans);
    }

    public Span getCurrentSpan() {
        return this.spanAreas.get(this.spanAreas.size() - 1);
    }

    public boolean isEmpty() {
        if (this.isEmpty && this.spanAreas != null) {
            for (Span spanArea : this.spanAreas) {
                if (spanArea.isEmpty()) continue;
                this.isEmpty = false;
                break;
            }
        }
        return this.isEmpty;
    }

    public int getColumnCount() {
        return this.parent.getColumnCount();
    }

    public int getColumnGap() {
        return this.parent.getColumnGap();
    }

    @Override
    public void setWritingModeTraits(WritingModeTraitsGetter wmtg) {
        this.wmtg = wmtg;
        for (Span s : this.getSpans()) {
            s.setWritingModeTraits(wmtg);
        }
    }
}

