/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.Visitor;

public final class ConstantMethodType
extends Constant {
    private int descriptor_index;

    public ConstantMethodType(ConstantMethodType c) {
        this(c.getDescriptorIndex());
    }

    ConstantMethodType(DataInput file) throws IOException {
        this(file.readUnsignedShort());
    }

    public ConstantMethodType(int descriptor_index) {
        super((byte)16);
        this.descriptor_index = descriptor_index;
    }

    @Override
    public void accept(Visitor v) {
        v.visitConstantMethodType(this);
    }

    @Override
    public final void dump(DataOutputStream file) throws IOException {
        file.writeByte(super.getTag());
        file.writeShort(this.descriptor_index);
    }

    public int getDescriptorIndex() {
        return this.descriptor_index;
    }

    public void setDescriptorIndex(int descriptor_index) {
        this.descriptor_index = descriptor_index;
    }

    @Override
    public final String toString() {
        return super.toString() + "(descriptor_index = " + this.descriptor_index + ")";
    }
}

