/*
 * Decompiled with CFR 0.152.
 */
package sax.helpers;

import org.xml.sax.Attributes;

public class AttributesImpl
implements Attributes {
    private ListNode head;
    private ListNode tail;
    private int length;

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public int getIndex(String string) {
        ListNode listNode = this.head;
        int n = 0;
        while (listNode != null) {
            if (listNode.raw.equals(string)) {
                return n;
            }
            ++n;
            listNode = listNode.next;
        }
        return -1;
    }

    @Override
    public int getIndex(String string, String string2) {
        ListNode listNode = this.head;
        int n = 0;
        while (listNode != null) {
            if (listNode.uri.equals(string) && listNode.local.equals(string2)) {
                return n;
            }
            ++n;
            listNode = listNode.next;
        }
        return -1;
    }

    @Override
    public String getURI(int n) {
        ListNode listNode = this.getListNodeAt(n);
        return listNode != null ? listNode.uri : null;
    }

    @Override
    public String getLocalName(int n) {
        ListNode listNode = this.getListNodeAt(n);
        return listNode != null ? listNode.local : null;
    }

    @Override
    public String getQName(int n) {
        ListNode listNode = this.getListNodeAt(n);
        return listNode != null ? listNode.raw : null;
    }

    @Override
    public String getType(int n) {
        ListNode listNode = this.getListNodeAt(n);
        return listNode != null ? listNode.type : null;
    }

    @Override
    public String getType(String string, String string2) {
        ListNode listNode = this.getListNode(string, string2);
        return listNode != null ? listNode.type : null;
    }

    @Override
    public String getType(String string) {
        ListNode listNode = this.getListNode(string);
        return listNode != null ? listNode.type : null;
    }

    @Override
    public String getValue(int n) {
        ListNode listNode = this.getListNodeAt(n);
        return listNode != null ? listNode.value : null;
    }

    @Override
    public String getValue(String string, String string2) {
        ListNode listNode = this.getListNode(string, string2);
        return listNode != null ? listNode.value : null;
    }

    @Override
    public String getValue(String string) {
        ListNode listNode = this.getListNode(string);
        return listNode != null ? listNode.value : null;
    }

    public void addAttribute(String string, String string2, String string3) {
        this.addAttribute(null, null, string, string2, string3);
    }

    public void addAttribute(String string, String string2, String string3, String string4, String string5) {
        ListNode listNode = new ListNode(string, string2, string3, string4, string5);
        if (this.length == 0) {
            this.head = listNode;
        } else {
            this.tail.next = listNode;
        }
        this.tail = listNode;
        ++this.length;
    }

    public void insertAttributeAt(int n, String string, String string2, String string3) {
        this.insertAttributeAt(n, null, null, string, string2, string3);
    }

    public void insertAttributeAt(int n, String string, String string2, String string3, String string4, String string5) {
        if (this.length == 0 || n >= this.length) {
            this.addAttribute(string, string2, string3, string4, string5);
            return;
        }
        ListNode listNode = new ListNode(string, string2, string3, string4, string5);
        if (n < 1) {
            listNode.next = this.head;
            this.head = listNode;
        } else {
            ListNode listNode2 = this.getListNodeAt(n - 1);
            listNode.next = listNode2.next;
            listNode2.next = listNode;
        }
        ++this.length;
    }

    public void removeAttributeAt(int n) {
        if (this.length == 0) {
            return;
        }
        if (n == 0) {
            this.head = this.head.next;
            if (this.head == null) {
                this.tail = null;
            }
            --this.length;
        } else {
            ListNode listNode = this.getListNodeAt(n - 1);
            ListNode listNode2 = this.getListNodeAt(n);
            if (listNode2 != null) {
                listNode.next = listNode2.next;
                if (listNode2 == this.tail) {
                    this.tail = listNode;
                }
                --this.length;
            }
        }
    }

    public void removeAttribute(String string) {
        this.removeAttributeAt(this.getIndex(string));
    }

    public void removeAttribute(String string, String string2) {
        this.removeAttributeAt(this.getIndex(string, string2));
    }

    private ListNode getListNodeAt(int n) {
        ListNode listNode = this.head;
        while (listNode != null) {
            if (--n == -1) {
                return listNode;
            }
            listNode = listNode.next;
        }
        return null;
    }

    public ListNode getListNode(String string, String string2) {
        if (string != null && string2 != null) {
            ListNode listNode = this.head;
            while (listNode != null) {
                if (listNode.uri != null && listNode.local != null && listNode.uri.equals(string) && listNode.local.equals(string2)) {
                    return listNode;
                }
                listNode = listNode.next;
            }
        }
        return null;
    }

    private ListNode getListNode(String string) {
        if (string != null) {
            ListNode listNode = this.head;
            while (listNode != null) {
                if (listNode.raw != null && listNode.raw.equals(string)) {
                    return listNode;
                }
                listNode = listNode.next;
            }
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        stringBuffer.append("len=");
        stringBuffer.append(this.length);
        stringBuffer.append(", {");
        ListNode listNode = this.head;
        while (listNode != null) {
            stringBuffer.append(listNode.toString());
            if (listNode.next != null) {
                stringBuffer.append(", ");
            }
            listNode = listNode.next;
        }
        stringBuffer.append("}]");
        return stringBuffer.toString();
    }

    static class ListNode {
        public String uri;
        public String local;
        public String raw;
        public String type;
        public String value;
        public ListNode next;

        public ListNode(String string, String string2, String string3, String string4, String string5) {
            this.uri = string;
            this.local = string2;
            this.raw = string3;
            this.type = string4;
            this.value = string5;
        }

        public String toString() {
            return this.raw != null ? this.raw : this.local;
        }
    }
}

