/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.util.Collection;
import java.util.List;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.activitydiagram3.Branch;
import net.sourceforge.plantuml.activitydiagram3.ForkStyle;
import net.sourceforge.plantuml.activitydiagram3.Instruction;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.PositionedNote;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyle;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorAndStyle;
import net.sourceforge.plantuml.graphic.Rainbow;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.skin.rose.Rose;

public class FtileFactoryDelegator
implements FtileFactory {
    private final FtileFactory factory;
    private final Rose rose = new Rose();

    protected final Rainbow getInLinkRenderingColor(Ftile tile) {
        LinkRendering linkRendering = tile.getInLinkRendering();
        Rainbow color = linkRendering == null ? HtmlColorAndStyle.build(this.skinParam()) : linkRendering.getRainbow();
        if (color.size() == 0) {
            color = HtmlColorAndStyle.build(this.skinParam());
        }
        return color;
    }

    protected final TextBlock getTextBlock(Display display) {
        if (Display.isNull(display)) {
            return null;
        }
        FontConfiguration fontConfiguration = new FontConfiguration(this.skinParam(), FontParam.ARROW, null);
        return display.create(fontConfiguration, HorizontalAlignment.LEFT, (ISkinSimple)this.skinParam(), CreoleMode.SIMPLE_LINE);
    }

    protected Display getInLinkRenderingDisplay(Ftile tile) {
        LinkRendering linkRendering = tile.getInLinkRendering();
        if (linkRendering == null) {
            return Display.NULL;
        }
        return linkRendering.getDisplay();
    }

    public FtileFactoryDelegator(FtileFactory factory) {
        this.factory = factory;
    }

    @Override
    public Ftile start(Swimlane swimlane) {
        return this.factory.start(swimlane);
    }

    @Override
    public Ftile end(Swimlane swimlane) {
        return this.factory.end(swimlane);
    }

    @Override
    public Ftile stop(Swimlane swimlane) {
        return this.factory.stop(swimlane);
    }

    @Override
    public Ftile spot(Swimlane swimlane, String spot) {
        return this.factory.spot(swimlane, spot);
    }

    @Override
    public Ftile activity(Display label, Swimlane swimlane, BoxStyle style, Colors colors) {
        return this.factory.activity(label, swimlane, style, colors);
    }

    @Override
    public Ftile addNote(Ftile ftile, Swimlane swimlane, Collection<PositionedNote> notes) {
        return this.factory.addNote(ftile, swimlane, notes);
    }

    @Override
    public Ftile addUrl(Ftile ftile, Url url) {
        return this.factory.addUrl(ftile, url);
    }

    @Override
    public Ftile decorateIn(Ftile ftile, LinkRendering linkRendering) {
        if (linkRendering == null) {
            throw new IllegalArgumentException();
        }
        return this.factory.decorateIn(ftile, linkRendering);
    }

    @Override
    public Ftile decorateOut(Ftile ftile, LinkRendering linkRendering) {
        if (linkRendering == null) {
            throw new IllegalArgumentException();
        }
        return this.factory.decorateOut(ftile, linkRendering);
    }

    @Override
    public Ftile assembly(Ftile tile1, Ftile tile2) {
        return this.factory.assembly(tile1, tile2);
    }

    @Override
    public Ftile repeat(Swimlane swimlane, Swimlane swimlaneOut, Display startLabel, Ftile repeat, Display test, Display yes, Display out, HtmlColor color, LinkRendering backRepeatLinkRendering, Ftile backward, boolean noOut) {
        return this.factory.repeat(swimlane, swimlaneOut, startLabel, repeat, test, yes, out, color, backRepeatLinkRendering, backward, noOut);
    }

    @Override
    public Ftile createWhile(Swimlane swimlane, Ftile whileBlock, Display test, Display yes, Display out, LinkRendering afterEndwhile, HtmlColor color, Instruction specialOut) {
        return this.factory.createWhile(swimlane, whileBlock, test, yes, out, afterEndwhile, color, specialOut);
    }

    @Override
    public Ftile createIf(Swimlane swimlane, List<Branch> thens, Branch elseBranch, LinkRendering afterEndwhile, LinkRendering topInlinkRendering) {
        return this.factory.createIf(swimlane, thens, elseBranch, afterEndwhile, topInlinkRendering);
    }

    @Override
    public Ftile createParallel(Swimlane swimlane, List<Ftile> all, ForkStyle style, String label) {
        return this.factory.createParallel(swimlane, all, style, label);
    }

    @Override
    public Ftile createGroup(Ftile list, Display name, HtmlColor backColor, HtmlColor titleColor, PositionedNote note, HtmlColor borderColor, USymbol type, double roundCorner) {
        return this.factory.createGroup(list, name, backColor, titleColor, note, borderColor, type, roundCorner);
    }

    @Override
    public StringBounder getStringBounder() {
        return this.factory.getStringBounder();
    }

    protected final Rose getRose() {
        return this.rose;
    }

    @Override
    public final ISkinParam skinParam() {
        return this.factory.skinParam();
    }

    protected FtileFactory getFactory() {
        return this.factory;
    }
}

