/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.svg;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.PageViewport;
import org.apache.fop.render.bitmap.MultiFileRenderingUtil;
import org.apache.fop.render.java2d.Java2DGraphicsState;
import org.apache.fop.render.java2d.Java2DRenderer;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class SVGRenderer
extends Java2DRenderer {
    private static Log log = LogFactory.getLog(SVGRenderer.class);
    public static final String MIME_TYPE = "image/svg+xml";
    private static final String SVG_FILE_EXTENSION = "svg";
    private OutputStream firstOutputStream;
    private Document document;
    private SVGGraphics2D svgGenerator;
    private MultiFileRenderingUtil multiFileUtil;

    public SVGRenderer(FOUserAgent userAgent) {
        super(userAgent);
    }

    public String getMimeType() {
        return MIME_TYPE;
    }

    public void startRenderer(OutputStream outputStream) throws IOException {
        this.firstOutputStream = outputStream;
        this.multiFileUtil = new MultiFileRenderingUtil(SVG_FILE_EXTENSION, this.getUserAgent().getOutputFile());
        super.startRenderer(this.firstOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderPage(PageViewport pageViewport) throws IOException {
        log.debug((Object)("Rendering page: " + pageViewport.getPageNumberString()));
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        this.document = domImpl.createDocument(null, SVG_FILE_EXTENSION, null);
        SVGGeneratorContext ctx = SVGGeneratorContext.createDefault((Document)this.document);
        ctx.setComment("Generated by " + this.userAgent.getProducer() + " with Batik SVG Generator");
        ctx.setEmbeddedFontsOn(true);
        this.svgGenerator = new SVGGraphics2D(ctx, true);
        Rectangle viewArea = pageViewport.getViewArea();
        Dimension dim = new Dimension();
        dim.setSize(((RectangularShape)viewArea).getWidth() / 1000.0, ((RectangularShape)viewArea).getHeight() / 1000.0);
        this.svgGenerator.setSVGCanvasSize(dim);
        AffineTransform at = this.svgGenerator.getTransform();
        this.state = new Java2DGraphicsState((Graphics2D)this.svgGenerator, this.fontInfo, at);
        try {
            this.renderPageAreas(pageViewport.getPage());
        }
        finally {
            this.state = null;
        }
        this.writeSVGFile(pageViewport.getPageIndex());
        this.svgGenerator = null;
        this.document = null;
    }

    public void stopRenderer() throws IOException {
        super.stopRenderer();
        this.clearViewportList();
        log.debug((Object)"SVG generation complete.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSVGFile(int pageNumber) throws IOException {
        log.debug((Object)"Writing out SVG file...");
        boolean useCSS = true;
        OutputStream out = this.getCurrentOutputStream(pageNumber);
        if (out == null) {
            log.warn((Object)"No filename information available. Stopping early after the first page.");
            return;
        }
        try {
            OutputStreamWriter writer = new OutputStreamWriter(out, "UTF-8");
            this.svgGenerator.stream((Writer)writer, useCSS);
        }
        finally {
            if (out != this.firstOutputStream) {
                IOUtils.closeQuietly((OutputStream)out);
            } else {
                out.flush();
            }
        }
    }

    protected OutputStream getCurrentOutputStream(int pageNumber) throws IOException {
        if (pageNumber == 0) {
            return this.firstOutputStream;
        }
        return this.multiFileUtil.createOutputStream(pageNumber);
    }
}

