/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import net.sourceforge.plantuml.klimt.LineBreakStrategy;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.UEllipse;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.klimt.shape.UPolygon;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.ArrowDecoration;
import net.sourceforge.plantuml.skin.ArrowDirection;
import net.sourceforge.plantuml.skin.ArrowDressing;
import net.sourceforge.plantuml.skin.ArrowHead;
import net.sourceforge.plantuml.skin.ArrowPart;
import net.sourceforge.plantuml.skin.rose.AbstractComponentRoseArrow;
import net.sourceforge.plantuml.style.ISkinSimple;
import net.sourceforge.plantuml.style.Style;

public class ComponentRoseArrow
extends AbstractComponentRoseArrow {
    private final HorizontalAlignment messagePosition;
    private final boolean niceArrow;
    private final boolean belowForResponse;
    private final int inclination1;
    private final int inclination2;
    public static final double spaceCrossX = 6.0;
    public static final double diamCircle = 8.0;
    public static final double thinCircle = 1.5;

    public ComponentRoseArrow(Style style, Display stringsToDisplay, ArrowConfiguration arrowConfiguration, HorizontalAlignment messagePosition, ISkinSimple spriteContainer, LineBreakStrategy maxMessageSize, boolean niceArrow, boolean belowForResponse) {
        super(style, stringsToDisplay, arrowConfiguration, spriteContainer, maxMessageSize);
        this.messagePosition = messagePosition;
        this.niceArrow = niceArrow;
        this.belowForResponse = belowForResponse;
        this.inclination1 = arrowConfiguration.getInclination1();
        this.inclination2 = arrowConfiguration.getInclination2();
    }

    @Override
    public void drawInternalU(UGraphic ug, Area area) {
        double textPos;
        double yText;
        double posArrow;
        ArrowConfiguration arrowConfiguration = this.getArrowConfiguration();
        if (arrowConfiguration.isHidden()) {
            return;
        }
        XDimension2D dimensionToUse = area.getDimensionToUse();
        StringBounder stringBounder = ug.getStringBounder();
        ug = ug.apply(this.getForegroundColor());
        ArrowDressing dressing1 = arrowConfiguration.getDressing1();
        ArrowDressing dressing2 = arrowConfiguration.getDressing2();
        double start = 0.0;
        double len = dimensionToUse.getWidth() - 1.0;
        double lenFull = dimensionToUse.getWidth();
        double pos1 = start + 1.0;
        double pos2 = len - 1.0;
        if (arrowConfiguration.getDecoration2() == ArrowDecoration.CIRCLE && dressing2.getHead() == ArrowHead.NONE) {
            len -= 4.0;
        }
        if (arrowConfiguration.getDecoration2() == ArrowDecoration.CIRCLE && dressing2.getHead() != ArrowHead.NONE) {
            len -= 5.5;
        }
        if (arrowConfiguration.getDecoration1() == ArrowDecoration.CIRCLE && dressing1.getHead() == ArrowHead.NONE) {
            start += 4.0;
            len -= 4.0;
        }
        if (arrowConfiguration.getDecoration1() == ArrowDecoration.CIRCLE && dressing1.getHead() == ArrowHead.NORMAL) {
            start += 9.5;
            len -= 9.5;
        }
        if (dressing2.getPart() == ArrowPart.FULL && dressing2.getHead() == ArrowHead.NORMAL) {
            len -= (double)(this.getArrowDeltaX() / 2);
        }
        if (dressing1.getPart() == ArrowPart.FULL && dressing1.getHead() == ArrowHead.NORMAL) {
            start += (double)(this.getArrowDeltaX() / 2);
            len -= (double)(this.getArrowDeltaX() / 2);
        }
        if (dressing2.getHead() == ArrowHead.CROSSX) {
            len -= 12.0;
        }
        if (dressing1.getHead() == ArrowHead.CROSSX) {
            start += 12.0;
            len -= 12.0;
        }
        if (this.isBelowForResponse()) {
            posArrow = 0.0;
            yText = this.getMarginY();
        } else {
            posArrow = this.getTextHeight(stringBounder);
            yText = 0.0;
        }
        this.drawDressing1(ug.apply(new UTranslate(pos1, posArrow + (double)this.inclination1)), dressing1, arrowConfiguration.getDecoration1(), lenFull);
        this.drawDressing2(ug.apply(new UTranslate(pos2, posArrow + (double)this.inclination2)), dressing2, arrowConfiguration.getDecoration2(), lenFull);
        if (this.inclination1 == 0 && this.inclination2 == 0) {
            arrowConfiguration.applyStroke(ug).apply(new UTranslate(start, posArrow)).draw(new ULine(len, 0.0));
        } else if (this.inclination1 != 0) {
            this.drawLine(arrowConfiguration.applyStroke(ug), start + len, posArrow, 0.0, posArrow + (double)this.inclination1);
        } else if (this.inclination2 != 0) {
            this.drawLine(arrowConfiguration.applyStroke(ug), start, posArrow, pos2, posArrow + (double)this.inclination2);
        }
        ArrowDirection direction2 = this.getDirection2();
        if (this.messagePosition == HorizontalAlignment.CENTER) {
            double textWidth = this.getTextBlock().calculateDimension(stringBounder).getWidth();
            textPos = (dimensionToUse.getWidth() - textWidth) / 2.0;
        } else if (this.messagePosition == HorizontalAlignment.RIGHT) {
            double textWidth = this.getTextBlock().calculateDimension(stringBounder).getWidth();
            textPos = dimensionToUse.getWidth() - textWidth - (double)this.getMarginX2() - (double)(direction2 == ArrowDirection.LEFT_TO_RIGHT_NORMAL ? this.getArrowDeltaX() : 0);
        } else {
            textPos = this.getMarginX1() + (direction2 == ArrowDirection.RIGHT_TO_LEFT_REVERSE || direction2 == ArrowDirection.BOTH_DIRECTION ? this.getArrowDeltaX() : 0);
        }
        this.getTextBlock().drawU(ug.apply(new UTranslate(textPos, yText)));
    }

    private void drawLine(UGraphic ug, double x1, double y1, double x2, double y2) {
        ug = ug.apply(new UTranslate(x1, y1));
        ug.draw(new ULine(x2 - x1, y2 - y1));
    }

    @Override
    public double getPosArrow(StringBounder stringBounder) {
        if (this.isBelowForResponse()) {
            return 0.0;
        }
        return this.getTextHeight(stringBounder) - (double)(2 * this.getMarginY());
    }

    private boolean isBelowForResponse() {
        return this.belowForResponse && this.getArrowConfiguration().isReverseDefine();
    }

    private void drawDressing1(UGraphic ug, ArrowDressing dressing, ArrowDecoration decoration, double lenFull) {
        if (decoration == ArrowDecoration.CIRCLE) {
            UEllipse circle = UEllipse.build(8.0, 8.0);
            ug.apply(UStroke.withThickness(1.5)).apply(this.getForegroundColor()).apply(new UTranslate(-5.5, -4.75)).draw(circle);
            if (dressing.getHead() != ArrowHead.CROSSX) {
                ug = ug.apply(UTranslate.dx(5.5));
            }
        }
        if (dressing.getHead() == ArrowHead.ASYNC) {
            if (dressing.getPart() != ArrowPart.BOTTOM_PART) {
                this.getArrowConfiguration().applyThicknessOnly(ug).draw(new ULine(this.getArrowDeltaX(), -this.getArrowDeltaY()).rotate(Math.atan2(-this.inclination1, lenFull)));
            }
            if (dressing.getPart() != ArrowPart.TOP_PART) {
                this.getArrowConfiguration().applyThicknessOnly(ug).draw(new ULine(this.getArrowDeltaX(), this.getArrowDeltaY()).rotate(Math.atan2(-this.inclination1, lenFull)));
            }
        } else if (dressing.getHead() == ArrowHead.CROSSX) {
            ug = ug.apply(UStroke.withThickness(2.0));
            ug.apply(new UTranslate(6.0, -this.getArrowDeltaX() / 2)).draw(new ULine(this.getArrowDeltaX(), this.getArrowDeltaX()));
            ug.apply(new UTranslate(6.0, this.getArrowDeltaX() / 2)).draw(new ULine(this.getArrowDeltaX(), -this.getArrowDeltaX()));
        } else if (dressing.getHead() == ArrowHead.NORMAL) {
            UPolygon polygon = this.getPolygonReverse(dressing.getPart());
            if (this.inclination1 != 0) {
                polygon.rotate(Math.atan2(-this.inclination1, lenFull));
            }
            ug.apply(this.getForegroundColor().bg()).draw(polygon);
        }
    }

    private void drawDressing2(UGraphic ug, ArrowDressing dressing, ArrowDecoration decoration, double lenFull) {
        if (decoration == ArrowDecoration.CIRCLE) {
            ug = ug.apply(UStroke.withThickness(1.5)).apply(this.getForegroundColor());
            UEllipse circle = UEllipse.build(8.0, 8.0);
            ug.apply(new UTranslate(-2.5, -4.75)).draw(circle);
            ug = ug.apply(UStroke.simple());
            ug = ug.apply(UTranslate.dx(-5.5));
        }
        if (dressing.getHead() == ArrowHead.ASYNC) {
            if (dressing.getPart() != ArrowPart.BOTTOM_PART) {
                this.getArrowConfiguration().applyThicknessOnly(ug).draw(new ULine(-this.getArrowDeltaX(), -this.getArrowDeltaY()).rotate(Math.atan2(this.inclination2, lenFull)));
            }
            if (dressing.getPart() != ArrowPart.TOP_PART) {
                this.getArrowConfiguration().applyThicknessOnly(ug).draw(new ULine(-this.getArrowDeltaX(), this.getArrowDeltaY()).rotate(Math.atan2(this.inclination2, lenFull)));
            }
        } else if (dressing.getHead() == ArrowHead.CROSSX) {
            ug = ug.apply(UStroke.withThickness(2.0));
            ug.apply(new UTranslate(-6.0 - (double)this.getArrowDeltaX(), -this.getArrowDeltaX() / 2)).draw(new ULine(this.getArrowDeltaX(), this.getArrowDeltaX()));
            ug.apply(new UTranslate(-6.0 - (double)this.getArrowDeltaX(), this.getArrowDeltaX() / 2)).draw(new ULine(this.getArrowDeltaX(), -this.getArrowDeltaX()));
        } else if (dressing.getHead() == ArrowHead.NORMAL) {
            UPolygon polygon = this.getPolygonNormal(dressing.getPart());
            if (this.inclination2 != 0) {
                polygon.rotate(Math.atan2(this.inclination2, lenFull));
            }
            ug.apply(this.getForegroundColor().bg()).draw(polygon);
        }
    }

    private UPolygon getPolygonNormal(ArrowPart part) {
        UPolygon polygon = new UPolygon();
        if (part == ArrowPart.TOP_PART) {
            polygon.addPoint(-this.getArrowDeltaX(), -this.getArrowDeltaY());
            polygon.addPoint(0.0, 0.0);
            polygon.addPoint(-this.getArrowDeltaX(), 0.0);
        } else if (part == ArrowPart.BOTTOM_PART) {
            polygon.addPoint(-this.getArrowDeltaX(), 1.0);
            polygon.addPoint(0.0, 1.0);
            polygon.addPoint(-this.getArrowDeltaX(), this.getArrowDeltaY() + 1);
        } else {
            polygon.addPoint(-this.getArrowDeltaX(), -this.getArrowDeltaY());
            polygon.addPoint(0.0, 0.0);
            polygon.addPoint(-this.getArrowDeltaX(), this.getArrowDeltaY());
            if (this.niceArrow) {
                polygon.addPoint(-this.getArrowDeltaX() + 4, 0.0);
            }
        }
        return polygon;
    }

    private UPolygon getPolygonReverse(ArrowPart part) {
        UPolygon polygon = new UPolygon();
        if (part == ArrowPart.TOP_PART) {
            polygon.addPoint(this.getArrowDeltaX(), -this.getArrowDeltaY());
            polygon.addPoint(0.0, 0.0);
            polygon.addPoint(this.getArrowDeltaX(), 0.0);
        } else if (part == ArrowPart.BOTTOM_PART) {
            polygon.addPoint(this.getArrowDeltaX(), 1.0);
            polygon.addPoint(0.0, 1.0);
            polygon.addPoint(this.getArrowDeltaX(), this.getArrowDeltaY() + 1);
        } else {
            polygon.addPoint(this.getArrowDeltaX(), -this.getArrowDeltaY());
            polygon.addPoint(0.0, 0.0);
            polygon.addPoint(this.getArrowDeltaX(), this.getArrowDeltaY());
            if (this.niceArrow) {
                polygon.addPoint(this.getArrowDeltaX() - 4, 0.0);
            }
        }
        return polygon;
    }

    @Override
    public XPoint2D getStartPoint(StringBounder stringBounder, XDimension2D dimensionToUse) {
        double y = this.getYPoint(stringBounder);
        if (this.getDirection2() == ArrowDirection.LEFT_TO_RIGHT_NORMAL) {
            return new XPoint2D(this.getPaddingX(), y + (double)this.inclination2);
        }
        return new XPoint2D(dimensionToUse.getWidth() + this.getPaddingX(), y + (double)this.inclination2);
    }

    @Override
    public XPoint2D getEndPoint(StringBounder stringBounder, XDimension2D dimensionToUse) {
        double y = this.getYPoint(stringBounder);
        if (this.getDirection2() == ArrowDirection.LEFT_TO_RIGHT_NORMAL) {
            return new XPoint2D(dimensionToUse.getWidth() + this.getPaddingX(), y);
        }
        return new XPoint2D(this.getPaddingX(), y);
    }

    @Override
    public double getYPoint(StringBounder stringBounder) {
        if (this.isBelowForResponse()) {
            return this.getPaddingY();
        }
        return this.getTextHeight(stringBounder) + this.getPaddingY();
    }

    private final ArrowDirection getDirection2() {
        return this.getArrowConfiguration().getArrowDirection();
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + (double)this.getArrowDeltaY() + 2.0 * this.getPaddingY() + (double)this.inclination1 + (double)this.inclination2;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return this.getTextWidth(stringBounder) + (double)this.getArrowDeltaX();
    }
}

