/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.VerticalAlignment;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.Message;
import net.sourceforge.plantuml.sequencediagram.teoz.EventsHistoryMode;
import net.sourceforge.plantuml.sequencediagram.teoz.LivingSpace;
import net.sourceforge.plantuml.sequencediagram.teoz.TileWithCallbackY;
import net.sourceforge.plantuml.sequencediagram.teoz.TileWithUpdateStairs;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ArrowComponent;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class CommunicationTile
implements TileWithUpdateStairs,
TileWithCallbackY {
    private final LivingSpace livingSpace1;
    private final LivingSpace livingSpace2;
    private final Message message;
    private final Skin skin;
    private final ISkinParam skinParam;
    public static final double LIVE_DELTA_SIZE = 5.0;

    @Override
    public Event getEvent() {
        return this.message;
    }

    public CommunicationTile(LivingSpace livingSpace1, LivingSpace livingSpace2, Message message, Skin skin, ISkinParam skinParam) {
        if (livingSpace1 == livingSpace2) {
            throw new IllegalArgumentException();
        }
        this.livingSpace1 = livingSpace1;
        this.livingSpace2 = livingSpace2;
        this.message = message;
        this.skin = skin;
        this.skinParam = skinParam;
        if (message.isCreate()) {
            livingSpace2.goCreate();
        }
    }

    public boolean isReverse(StringBounder stringBounder) {
        Real point1 = this.livingSpace1.getPosC(stringBounder);
        Real point2 = this.livingSpace2.getPosC(stringBounder);
        return point1.getCurrentValue() > point2.getCurrentValue();
    }

    private boolean isCreate() {
        return this.message.isCreate();
    }

    private Component getComponent(StringBounder stringBounder) {
        ArrowConfiguration arrowConfiguration = this.message.getArrowConfiguration();
        if (this.isReverse(stringBounder)) {
            arrowConfiguration = arrowConfiguration.reverse();
        }
        Component comp = this.skin.createComponent(ComponentType.ARROW, arrowConfiguration, this.skinParam, this.message.getLabelNumbered());
        return comp;
    }

    @Override
    public void updateStairs(StringBounder stringBounder, double y) {
        ArrowComponent comp = (ArrowComponent)this.getComponent(stringBounder);
        Dimension2D dim = comp.getPreferredDimension(stringBounder);
        double arrowY = comp.getStartPoint(stringBounder, dim).getY();
        this.livingSpace1.addStepForLivebox(this.getEvent(), y + arrowY);
        this.livingSpace2.addStepForLivebox(this.getEvent(), y + arrowY);
    }

    @Override
    public void drawU(UGraphic ug) {
        Area area;
        StringBounder stringBounder = ug.getStringBounder();
        Component comp = this.getComponent(stringBounder);
        Dimension2D dim = comp.getPreferredDimension(stringBounder);
        double x1 = this.getPoint1(stringBounder).getCurrentValue();
        double x2 = this.getPoint2(stringBounder).getCurrentValue();
        if (this.isReverse(stringBounder)) {
            int level1 = this.livingSpace1.getLevelAt(this, EventsHistoryMode.IGNORE_FUTURE_DEACTIVATE);
            int level2 = this.livingSpace2.getLevelAt(this, EventsHistoryMode.IGNORE_FUTURE_DEACTIVATE);
            if (level1 > 0) {
                x1 -= 5.0;
            }
            area = new Area(x1 - (x2 += 5.0 * (double)level2), dim.getHeight());
            ug = ug.apply(new UTranslate(x2, 0.0));
            if (this.isCreate()) {
                this.livingSpace2.drawHead(ug, (Context2D)((Object)ug), VerticalAlignment.TOP, HorizontalAlignment.RIGHT);
            }
        } else {
            int level1 = this.livingSpace1.getLevelAt(this, EventsHistoryMode.IGNORE_FUTURE_DEACTIVATE);
            int level2 = this.livingSpace2.getLevelAt(this, EventsHistoryMode.IGNORE_FUTURE_DEACTIVATE);
            if (level2 > 0) {
                level2 -= 2;
            }
            area = new Area((x2 += 5.0 * (double)level2) - (x1 += 5.0 * (double)level1), dim.getHeight());
            ug = ug.apply(new UTranslate(x1, 0.0));
            if (this.isCreate()) {
                this.livingSpace2.drawHead(ug.apply(new UTranslate(area.getDimensionToUse().getWidth(), 0.0)), (Context2D)((Object)ug), VerticalAlignment.TOP, HorizontalAlignment.LEFT);
            }
        }
        comp.drawU(ug, area, (Context2D)((Object)ug));
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        Component comp = this.getComponent(stringBounder);
        Dimension2D dim = comp.getPreferredDimension(stringBounder);
        double height = dim.getHeight();
        if (this.isCreate()) {
            height = Math.max(height, this.livingSpace2.getHeadPreferredDimension(stringBounder).getHeight());
        }
        return height;
    }

    @Override
    public void addConstraints(StringBounder stringBounder) {
        Component comp = this.getComponent(stringBounder);
        Dimension2D dim = comp.getPreferredDimension(stringBounder);
        double width = dim.getWidth();
        Real point1 = this.getPoint1(stringBounder);
        Real point2 = this.getPoint2(stringBounder);
        if (this.isReverse(stringBounder)) {
            int level1 = this.livingSpace1.getLevelAt(this, EventsHistoryMode.IGNORE_FUTURE_DEACTIVATE);
            int level2 = this.livingSpace2.getLevelAt(this, EventsHistoryMode.IGNORE_FUTURE_DEACTIVATE);
            if (level1 > 0) {
                point1 = point1.addFixed(-5.0);
            }
            point2 = point2.addFixed((double)level2 * 5.0);
            point1.ensureBiggerThan(point2.addFixed(width));
        } else {
            int level2 = this.livingSpace2.getLevelAt(this, EventsHistoryMode.IGNORE_FUTURE_DEACTIVATE);
            if (level2 > 0) {
                point2 = point2.addFixed(-5.0);
            }
            point2.ensureBiggerThan(point1.addFixed(width));
        }
    }

    private Real getPoint1(StringBounder stringBounder) {
        return this.livingSpace1.getPosC(stringBounder);
    }

    private Real getPoint2(StringBounder stringBounder) {
        if (this.message.isCreate()) {
            if (this.isReverse(stringBounder)) {
                return this.livingSpace2.getPosD(stringBounder);
            }
            return this.livingSpace2.getPosB();
        }
        return this.livingSpace2.getPosC(stringBounder);
    }

    @Override
    public Real getMinX(StringBounder stringBounder) {
        if (this.isReverse(stringBounder)) {
            return this.getPoint2(stringBounder);
        }
        return this.getPoint1(stringBounder);
    }

    @Override
    public Real getMaxX(StringBounder stringBounder) {
        if (this.isReverse(stringBounder)) {
            return this.getPoint1(stringBounder);
        }
        return this.getPoint2(stringBounder);
    }

    @Override
    public void callbackY(double y) {
        if (this.message.isCreate()) {
            this.livingSpace2.goCreate(y);
        }
    }
}

