/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.timingdiagram.Player;
import net.sourceforge.plantuml.timingdiagram.TimeMessage;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimeTickBuilder;
import net.sourceforge.plantuml.timingdiagram.TimingDiagram;

public class CommandTimeMessage
extends SingleLineCommand2<TimingDiagram> {
    public static final String PLAYER_CODE = "([\\p{L}_][\\p{L}0-9_.]*)";

    public CommandTimeMessage() {
        super(CommandTimeMessage.getRegexConcat());
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("PART1", PLAYER_CODE), TimeTickBuilder.optionalExpressionAtWithArobase("TIME1"), new RegexLeaf("[%s]*"), new RegexLeaf("ARROW_BODY", "(-+)"), new RegexLeaf("ARROW_STYLE", "(?:\\[((?:#\\w+|dotted|dashed|plain|bold|hidden|norank|single|thickness=\\d+)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden|,norank|,single|,thickness=\\d+)*)\\])?"), new RegexLeaf("ARROW_HEAD", "\\>"), new RegexLeaf("[%s]*"), new RegexLeaf("PART2", PLAYER_CODE), TimeTickBuilder.optionalExpressionAtWithArobase("TIME2"), new RegexLeaf("[%s]*"), new RegexLeaf("MESSAGE", "(?::[%s]*(.*))?"), new RegexLeaf("[%s]*$"));
    }

    @Override
    protected final CommandExecutionResult executeArg(TimingDiagram diagram, RegexResult arg) {
        Player player1 = diagram.getPlayer(arg.get("PART1", 0));
        if (player1 == null) {
            return CommandExecutionResult.error("No such element: " + arg.get("PART1", 0));
        }
        Player player2 = diagram.getPlayer(arg.get("PART2", 0));
        if (player2 == null) {
            return CommandExecutionResult.error("No such element: " + arg.get("PART2", 0));
        }
        TimeTick tick1 = TimeTickBuilder.parseTimeTick("TIME1", arg, diagram);
        TimeTick tick2 = TimeTickBuilder.parseTimeTick("TIME2", arg, diagram);
        TimeMessage result = diagram.createTimeMessage(player1, tick1, player2, tick2, arg.get("MESSAGE", 0));
        result.applyStyle(arg.getLazzy("ARROW_STYLE", 0));
        return CommandExecutionResult.ok();
    }
}

