/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.svg;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.render.intermediate.AbstractXMLWritingIFDocumentHandler;
import org.apache.fop.render.intermediate.IFContext;
import org.apache.fop.render.intermediate.IFDocumentHandlerConfigurator;
import org.apache.fop.render.intermediate.IFException;
import org.apache.fop.render.intermediate.IFState;
import org.apache.fop.render.java2d.Java2DUtil;
import org.apache.fop.render.svg.SVGConstants;
import org.apache.xmlgraphics.xmp.Metadata;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class AbstractSVGDocumentHandler
extends AbstractXMLWritingIFDocumentHandler
implements SVGConstants {
    private static Log log = LogFactory.getLog(AbstractSVGDocumentHandler.class);
    protected FontInfo fontInfo;
    protected IFState state;
    private static final int MODE_NORMAL = 0;
    private static final int MODE_TEXT = 1;
    private int mode = 0;

    public AbstractSVGDocumentHandler(IFContext context) {
        super(context);
    }

    protected String getMainNamespace() {
        return "http://www.w3.org/2000/svg";
    }

    public FontInfo getFontInfo() {
        return this.fontInfo;
    }

    public void setFontInfo(FontInfo fontInfo) {
        this.fontInfo = fontInfo;
    }

    public void setDefaultFontInfo(FontInfo fontInfo) {
        FontInfo fi = Java2DUtil.buildDefaultJava2DBasedFontInfo((FontInfo)fontInfo, (FOUserAgent)this.getUserAgent());
        this.setFontInfo(fi);
    }

    public IFDocumentHandlerConfigurator getConfigurator() {
        return null;
    }

    public void startDocumentHeader() throws IFException {
        try {
            this.handler.startElement("defs");
        }
        catch (SAXException e) {
            throw new IFException("SAX error in startDocumentHeader()", (Exception)e);
        }
    }

    public void endDocumentHeader() throws IFException {
        try {
            this.handler.endElement("defs");
        }
        catch (SAXException e) {
            throw new IFException("SAX error in startDocumentHeader()", (Exception)e);
        }
    }

    public void handleExtensionObject(Object extension) throws IFException {
        if (extension instanceof Metadata) {
            Metadata meta = (Metadata)extension;
            try {
                this.handler.startElement("metadata");
                meta.toSAX((ContentHandler)this.handler);
                this.handler.endElement("metadata");
            }
            catch (SAXException e) {
                throw new IFException("SAX error while handling extension object", (Exception)e);
            }
        } else {
            log.debug((Object)("Don't know how to handle extension object. Ignoring: " + extension + " (" + extension.getClass().getName() + ")"));
        }
    }
}

