/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3;

import java.util.Collections;
import java.util.Set;
import net.sourceforge.plantuml.activitydiagram3.Instruction;
import net.sourceforge.plantuml.activitydiagram3.InstructionCollection;
import net.sourceforge.plantuml.activitydiagram3.InstructionList;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.PositionedNote;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileWithNotes;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.NoteType;

public class InstructionGroup
implements Instruction,
InstructionCollection {
    private final InstructionList list;
    private final Instruction parent;
    private final HtmlColor backColor;
    private final HtmlColor borderColor;
    private final HtmlColor titleColor;
    private final LinkRendering linkRendering;
    private final USymbol type;
    private final Display test;
    private final double roundCorner;
    private PositionedNote note = null;

    public InstructionGroup(Instruction parent, Display test, HtmlColor backColor, HtmlColor titleColor, Swimlane swimlane, HtmlColor borderColor, LinkRendering linkRendering, USymbol type, double roundCorner) {
        this.list = new InstructionList(swimlane);
        this.type = type;
        this.linkRendering = linkRendering;
        this.parent = parent;
        this.test = test;
        this.borderColor = borderColor;
        this.backColor = backColor;
        this.titleColor = titleColor;
        this.roundCorner = roundCorner;
    }

    @Override
    public void add(Instruction ins) {
        this.list.add(ins);
    }

    @Override
    public Ftile createFtile(FtileFactory factory) {
        Ftile tmp = this.list.createFtile(factory);
        if (this.note != null) {
            tmp = new FtileWithNotes(tmp, Collections.singleton(this.note), factory.skinParam());
        }
        return factory.createGroup(tmp, this.test, this.backColor, this.titleColor, null, this.borderColor, this.type, this.roundCorner);
    }

    public Instruction getParent() {
        return this.parent;
    }

    @Override
    public final boolean kill() {
        return this.list.kill();
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.linkRendering;
    }

    @Override
    public boolean addNote(Display note, NotePosition position, NoteType type, Colors colors, Swimlane swimlaneNote) {
        if (this.list.isEmpty()) {
            this.note = new PositionedNote(note, position, type, colors, swimlaneNote);
            return true;
        }
        return this.list.addNote(note, position, type, colors, swimlaneNote);
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return this.list.getSwimlanes();
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.list.getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.list.getSwimlaneOut();
    }

    @Override
    public Instruction getLast() {
        return this.list.getLast();
    }
}

