/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.real.RealUtils;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.teoz.Tile;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class TileParallel
implements Tile {
    private final List<Tile> tiles = new ArrayList<Tile>();

    public void add(Tile tile) {
        this.tiles.add(tile);
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        double totalHeight = this.getPreferredHeight(stringBounder);
        for (Tile tile : this.tiles) {
            tile.drawU(ug.apply(new UTranslate(0.0, totalHeight - tile.getPreferredHeight(stringBounder))));
        }
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        double height = 0.0;
        for (Tile tile : this.tiles) {
            height = Math.max(height, tile.getPreferredHeight(stringBounder));
        }
        return height;
    }

    @Override
    public void addConstraints(StringBounder stringBounder) {
        for (Tile tile : this.tiles) {
            tile.addConstraints(stringBounder);
        }
    }

    @Override
    public Real getMinX(final StringBounder stringBounder) {
        return RealUtils.min((Collection<Real>)new AbstractCollection<Real>(){

            @Override
            public Iterator<Real> iterator() {
                return new Iterator<Real>(){
                    private final Iterator<Tile> source;
                    {
                        this.source = TileParallel.this.tiles.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.source.hasNext();
                    }

                    @Override
                    public Real next() {
                        return this.source.next().getMinX(stringBounder);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return TileParallel.this.tiles.size();
            }
        });
    }

    @Override
    public Real getMaxX(final StringBounder stringBounder) {
        return RealUtils.max((Collection<Real>)new AbstractCollection<Real>(){

            @Override
            public Iterator<Real> iterator() {
                return new Iterator<Real>(){
                    private final Iterator<Tile> source;
                    {
                        this.source = TileParallel.this.tiles.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.source.hasNext();
                    }

                    @Override
                    public Real next() {
                        return this.source.next().getMaxX(stringBounder);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return TileParallel.this.tiles.size();
            }
        });
    }

    @Override
    public Event getEvent() {
        return null;
    }
}

