/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.hsqldb.util.AppendableException;
import org.hsqldb.util.SqlToolError;
import org.hsqldb.util.SqltoolRB;

public class SqlFile {
    private static final int DEFAULT_HISTORY_SIZE = 40;
    private File file;
    private boolean interactive;
    private String primaryPrompt = "sql> ";
    private String rawPrompt = null;
    private String contPrompt = "  +> ";
    private Connection curConn = null;
    private boolean htmlMode = false;
    private Map userVars;
    private List history = null;
    private int rawMode = 0;
    private String nullRepToken = null;
    private String dsvTargetFile = null;
    private String dsvTargetTable = null;
    private String dsvConstCols = null;
    private String dsvRejectFile = null;
    private String dsvRejectReport = null;
    public static String LS = System.getProperty("line.separator");
    private int maxHistoryLength = 1;
    private SqltoolRB rb = null;
    private String magicPrefix = null;
    private static final int RAW_FALSE = 0;
    private static final int RAW_EMPTY = 1;
    private static final int RAW_DATA = 2;
    private static Pattern specialPattern = Pattern.compile("\\s*\\\\(\\S+)(?:\\s+(.*\\S))?\\s*");
    private static Pattern plPattern = Pattern.compile("\\s*\\*\\s*(.*\\S)?\\s*");
    private static Pattern foreachPattern = Pattern.compile("\\s*\\*\\s*foreach\\s+(\\S+)\\s*\\(([^)]*)\\)\\s*");
    private static Pattern ifwhilePattern = Pattern.compile("\\s*\\*\\s*\\S+\\s*\\(([^)]*)\\)\\s*");
    private static Pattern varsetPattern = Pattern.compile("\\s*\\*\\s*(\\S+)\\s*([=_~])\\s*(?:(.*\\S)\\s*)?");
    private static Pattern substitutionPattern = Pattern.compile("(\\S)(.+?)\\1(.*?)\\1(.+)?\\s*");
    private static Pattern slashHistoryPattern = Pattern.compile("\\s*/([^/]+)/\\s*(\\S.*)?");
    private static Pattern historyPattern = Pattern.compile("\\s*(-?\\d+)?\\s*(\\S.*)?");
    private static Pattern wincmdPattern = null;
    BooleanBucket possiblyUncommitteds = new BooleanBucket();
    private static final String DIVIDER = "----------------------------------------------------------------------------------------------------------------------------------";
    private static final String SPACES = "                                                                                                                                  ";
    private static String revnum;
    private String DSV_OPTIONS_TEXT = null;
    private String D_OPTIONS_TEXT = null;
    private String RAW_LEADIN_MSG = null;
    public boolean recursed = false;
    private String lastSqlStatement = null;
    private int curLinenum = -1;
    private PrintStream psStd = null;
    private PrintStream psErr = null;
    private PrintWriter pwQuery = null;
    private PrintWriter pwDsv = null;
    StringBuffer immCmdSB = new StringBuffer();
    private boolean continueOnError = false;
    private static final String DEFAULT_CHARSET;
    private BufferedReader br = null;
    private String charset = null;
    private String buffer = null;
    private boolean doPrepare = false;
    private String prepareVar = null;
    private String dsvColDelim = null;
    private String dsvSkipPrefix = null;
    private String dsvRowDelim = null;
    private String dsvSkipCols = null;
    private String DSV_X_SYNTAX_MSG = null;
    private String DSV_M_SYNTAX_MSG = null;
    private String nobufferYetString = null;
    private static final char[] nonVarChars;
    public boolean plMode = false;
    private String fetchingVar = null;
    private boolean silentFetch = false;
    private boolean fetchBinary = false;
    private static final String DEFAULT_NULL_REP = "[null]";
    private static final String DEFAULT_ROW_DELIM;
    private static final String DEFAULT_COL_DELIM = "|";
    private static final String DEFAULT_SKIP_PREFIX = "#";
    private static final int DEFAULT_ELEMENT = 0;
    private static final int HSQLDB_ELEMENT = 1;
    private static final int ORACLE_ELEMENT = 2;
    private static final int[] listMDSchemaCols;
    private static final int[] listMDIndexCols;
    private static final int[][] listMDTableCols;
    private static final String[] oracleSysSchemas;
    private boolean excludeSysSchemas = false;
    private static final int COL_HEAD = 0;
    private static final int COL_ODD = 1;
    private static final int COL_EVEN = 2;
    private static final String PRE_TR;
    private static final String PRE_TD;
    int oldestHist = 1;
    byte[] binBuffer = null;
    private static final int JDBC3_BOOLEAN = 16;
    private static final int JDBC3_DATALINK = 70;

    private void updateUserSettings() {
        this.dsvSkipPrefix = SqlFile.convertEscapes((String)this.userVars.get("*DSV_SKIP_PREFIX"));
        if (this.dsvSkipPrefix == null) {
            this.dsvSkipPrefix = DEFAULT_SKIP_PREFIX;
        }
        this.dsvSkipCols = (String)this.userVars.get("*DSV_SKIP_COLS");
        this.dsvColDelim = SqlFile.convertEscapes((String)this.userVars.get("*DSV_COL_DELIM"));
        if (this.dsvColDelim == null) {
            this.dsvColDelim = SqlFile.convertEscapes((String)this.userVars.get("*CSV_COL_DELIM"));
        }
        if (this.dsvColDelim == null) {
            this.dsvColDelim = DEFAULT_COL_DELIM;
        }
        this.dsvRowDelim = SqlFile.convertEscapes((String)this.userVars.get("*DSV_ROW_DELIM"));
        if (this.dsvRowDelim == null) {
            this.dsvRowDelim = SqlFile.convertEscapes((String)this.userVars.get("*CSV_ROW_DELIM"));
        }
        if (this.dsvRowDelim == null) {
            this.dsvRowDelim = DEFAULT_ROW_DELIM;
        }
        this.dsvTargetFile = (String)this.userVars.get("*DSV_TARGET_FILE");
        if (this.dsvTargetFile == null) {
            this.dsvTargetFile = (String)this.userVars.get("*CSV_FILEPATH");
        }
        this.dsvTargetTable = (String)this.userVars.get("*DSV_TARGET_TABLE");
        if (this.dsvTargetTable == null) {
            this.dsvTargetTable = (String)this.userVars.get("*CSV_TABLENAME");
        }
        this.dsvConstCols = (String)this.userVars.get("*DSV_CONST_COLS");
        this.dsvRejectFile = (String)this.userVars.get("*DSV_REJECT_FILE");
        this.dsvRejectReport = (String)this.userVars.get("*DSV_REJECT_REPORT");
        this.nullRepToken = (String)this.userVars.get("*NULL_REP_TOKEN");
        if (this.nullRepToken == null) {
            this.nullRepToken = (String)this.userVars.get("*CSV_NULL_REP");
        }
        if (this.nullRepToken == null) {
            this.nullRepToken = DEFAULT_NULL_REP;
        }
    }

    public SqlFile(File file, boolean bl, Map map) throws IOException {
        try {
            this.rb = new SqltoolRB();
            this.rb.validate();
            this.rb.setMissingPosValueBehavior(2);
            this.rb.setMissingPropertyBehavior(2);
        }
        catch (RuntimeException runtimeException) {
            System.err.println("Failed to initialize resource bundle");
            throw runtimeException;
        }
        this.rawPrompt = this.rb.getString(SqltoolRB.RAWMODE_PROMPT) + "> ";
        this.DSV_OPTIONS_TEXT = this.rb.getString(SqltoolRB.DSV_OPTIONS);
        this.D_OPTIONS_TEXT = this.rb.getString(SqltoolRB.D_OPTIONS);
        this.RAW_LEADIN_MSG = this.rb.getString(SqltoolRB.RAW_LEADIN);
        this.DSV_X_SYNTAX_MSG = this.rb.getString(SqltoolRB.DSV_X_SYNTAX);
        this.DSV_M_SYNTAX_MSG = this.rb.getString(SqltoolRB.DSV_M_SYNTAX);
        this.nobufferYetString = this.rb.getString(SqltoolRB.NOBUFFER_YET);
        this.file = file;
        this.interactive = bl;
        this.userVars = map;
        if (this.userVars == null) {
            this.userVars = new HashMap();
        }
        this.updateUserSettings();
        if (this.file != null && !this.file.canRead()) {
            throw new IOException(this.rb.getString(SqltoolRB.SQLFILE_READFAIL, this.file.toString()));
        }
        if (this.interactive) {
            this.history = new ArrayList();
            String string = System.getProperty("sqltool.historyLength");
            if (string != null) {
                try {
                    this.maxHistoryLength = Integer.parseInt(string);
                }
                catch (Exception exception) {}
            } else {
                this.maxHistoryLength = 40;
            }
        }
    }

    public SqlFile(boolean bl, Map map) throws IOException {
        this(null, bl, map);
    }

    public void execute(Connection connection, Boolean bl) throws SqlToolError, SQLException {
        this.execute(connection, System.out, System.err, bl);
    }

    public void execute(Connection connection, boolean bl) throws SqlToolError, SQLException {
        this.execute(connection, System.out, System.err, new Boolean(bl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void execute(Connection connection, PrintStream printStream, PrintStream printStream2, Boolean bl) throws SqlToolError, SQLException {
        String string;
        this.psStd = printStream;
        this.psErr = printStream2;
        this.curConn = connection;
        this.curLinenum = -1;
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = this.continueOnError = bl == null ? this.interactive : bl;
        if (this.userVars.size() > 0) {
            this.plMode = true;
        }
        this.charset = (string = System.getProperty("sqlfile.charset")) == null ? DEFAULT_CHARSET : string;
        try {
            this.br = new BufferedReader(this.charset == null ? new InputStreamReader(this.file == null ? System.in : new FileInputStream(this.file)) : new InputStreamReader(this.file == null ? System.in : new FileInputStream(this.file), this.charset));
            this.curLinenum = 0;
            if (this.interactive) {
                this.stdprintln(this.rb.getString(SqltoolRB.SQLFILE_BANNER, revnum));
            }
            while (true) {
                block59: {
                    Object object;
                    int n;
                    if (this.interactive && this.magicPrefix == null) {
                        this.psStd.print(this.immCmdSB.length() > 0 || this.rawMode == 2 ? this.contPrompt : (this.rawMode == 0 ? this.primaryPrompt : this.rawPrompt));
                    }
                    String string2 = this.br.readLine();
                    if (this.magicPrefix != null) {
                        string2 = this.magicPrefix + string2;
                        this.magicPrefix = null;
                    }
                    if (string2 == null) {
                        if (!this.interactive) break;
                        this.psStd.println();
                        break;
                    }
                    ++this.curLinenum;
                    if (bl2) {
                        n = string2.indexOf("*/") + 2;
                        if (n <= 1) continue;
                        string2 = string2.substring(n);
                        this.immCmdSB.setLength(0);
                        bl2 = false;
                    }
                    String string3 = string2.trim();
                    try {
                        if (this.rawMode != 0) {
                            boolean bl5 = string2.equals(".;");
                            if (bl5 || string2.equals(":.")) {
                                if (this.rawMode == 1) {
                                    this.rawMode = 0;
                                    throw new SqlToolError(this.rb.getString(SqltoolRB.RAW_EMPTY));
                                }
                                this.rawMode = 0;
                                this.setBuf(this.immCmdSB.toString());
                                this.immCmdSB.setLength(0);
                                if (bl5) {
                                    this.historize();
                                    this.processSQL();
                                    continue;
                                }
                                if (!this.interactive) continue;
                                this.stdprintln(this.rb.getString(SqltoolRB.RAW_MOVEDTOBUFFER));
                                continue;
                            }
                            if (this.rawMode == 2) {
                                this.immCmdSB.append('\n');
                            }
                            this.rawMode = 2;
                            if (string2.length() <= 0) continue;
                            this.immCmdSB.append(string2);
                            continue;
                        }
                        if (this.immCmdSB.length() == 0) {
                            if (string3.startsWith("/*")) {
                                n = string3.indexOf("*/", 2) + 2;
                                if (n > 1) {
                                    string2 = string2.substring(n + string2.length() - string3.length());
                                    string3 = string2.trim();
                                } else {
                                    this.immCmdSB.append("COMMENT");
                                    bl2 = true;
                                    continue;
                                }
                            }
                            if (string3.length() == 0) continue;
                            if (string3.charAt(0) == '*' && (string3.length() < 2 || string3.charAt(1) != '{') || string3.charAt(0) == '\\') {
                                this.setBuf(string3);
                                this.processFromBuffer();
                                continue;
                            }
                            if (string3.charAt(0) == ':' && this.interactive) {
                                this.processBuffHist(string3.substring(1));
                                continue;
                            }
                            String string4 = string3.toUpperCase();
                            if (string4.startsWith("DECLARE") || string4.startsWith("BEGIN")) {
                                this.rawMode = 1;
                                this.immCmdSB.append(string2);
                                if (!this.interactive) continue;
                                this.stdprintln(this.RAW_LEADIN_MSG);
                                continue;
                            }
                        }
                        if (string3.length() == 0 && this.interactive && !bl2) {
                            this.setBuf(this.immCmdSB.toString());
                            this.immCmdSB.setLength(0);
                            this.stdprintln(this.rb.getString(SqltoolRB.INPUT_MOVEDTOBUFFER));
                            continue;
                        }
                        String string5 = SqlFile.deTerminated(string2);
                        if (!string3.equals(";")) {
                            if (this.immCmdSB.length() > 0) {
                                this.immCmdSB.append('\n');
                            }
                            this.immCmdSB.append(string5 == null ? string2 : string5);
                        }
                        if (string5 == null) continue;
                        if (this.immCmdSB.toString().trim().length() == 0) {
                            this.immCmdSB.setLength(0);
                            throw new SqlToolError(this.rb.getString(SqltoolRB.SQLSTATEMENT_EMPTY));
                        }
                        this.setBuf(this.immCmdSB.toString());
                        this.immCmdSB.setLength(0);
                        this.historize();
                        this.processSQL();
                    }
                    catch (BadSpecial badSpecial) {
                        this.errprintln(this.rb.getString(SqltoolRB.ERRORAT, new String[]{this.file == null ? "stdin" : this.file.toString(), Integer.toString(this.curLinenum), string2, badSpecial.getMessage()}));
                        object = badSpecial.getCause();
                        if (object != null) {
                            this.errprintln(this.rb.getString(SqltoolRB.CAUSEREPORT, ((Throwable)object).toString()));
                        }
                        if (!this.continueOnError) {
                            throw new SqlToolError(badSpecial);
                        }
                    }
                    catch (SQLException sQLException) {
                        this.errprintln("SQL " + this.rb.getString(SqltoolRB.ERRORAT, new String[]{this.file == null ? "stdin" : this.file.toString(), Integer.toString(this.curLinenum), this.lastSqlStatement, sQLException.getMessage()}));
                        if (!this.continueOnError) {
                            throw sQLException;
                        }
                    }
                    catch (BreakException breakException) {
                        object = breakException.getMessage();
                        if (this.recursed) {
                            bl3 = false;
                        } else {
                            if (object == null || ((String)object).equals("file")) break;
                            this.errprintln(this.rb.getString(SqltoolRB.BREAK_UNSATISFIED, (String)object));
                        }
                        if (this.recursed || !this.continueOnError) {
                            throw breakException;
                        }
                    }
                    catch (ContinueException continueException) {
                        object = continueException.getMessage();
                        if (this.recursed) {
                            bl3 = false;
                        } else {
                            this.errprintln(this.rb.getString(SqltoolRB.CONTINUE_UNSATISFIED, (String)object));
                        }
                        if (this.recursed || !this.continueOnError) {
                            throw continueException;
                        }
                    }
                    catch (QuitNow quitNow) {
                        throw quitNow;
                    }
                    catch (SqlToolError sqlToolError) {
                        this.errprint(this.rb.getString(SqltoolRB.ERRORAT, new String[]{this.file == null ? "stdin" : this.file.toString(), Integer.toString(this.curLinenum), string2, sqlToolError.getMessage() == null ? "" : sqlToolError.getMessage()}));
                        if (sqlToolError.getMessage() != null) {
                            this.errprintln("");
                        }
                        if ((object = sqlToolError.getCause()) != null) {
                            this.errprintln(this.rb.getString(SqltoolRB.CAUSEREPORT, ((Throwable)object).toString()));
                        }
                        if (this.continueOnError) break block59;
                        throw sqlToolError;
                    }
                }
                this.immCmdSB.setLength(0);
            }
            if (bl2 || this.immCmdSB.length() != 0) {
                this.errprintln(this.rb.getString(SqltoolRB.INPUT_UNTERMINATED, this.immCmdSB.toString()));
                throw new SqlToolError(this.rb.getString(SqltoolRB.INPUT_UNTERMINATED, this.immCmdSB.toString()));
            }
            bl3 = false;
        }
        catch (IOException iOException) {
            throw new SqlToolError(this.rb.getString(SqltoolRB.PRIMARYINPUT_ACCESSFAIL), iOException);
        }
        catch (QuitNow quitNow) {
            if (this.recursed) {
                throw quitNow;
            }
            boolean bl6 = bl3 = quitNow.getMessage() != null;
            if (bl3) {
                this.errprintln(this.rb.getString(SqltoolRB.ABORTING, quitNow.getMessage()));
                throw new SqlToolError(quitNow.getMessage());
            }
            return;
        }
        finally {
            this.closeQueryOutputStream();
            if (this.fetchingVar != null) {
                this.errprintln(this.rb.getString(SqltoolRB.PLVAR_SET_INCOMPLETE, this.fetchingVar));
                bl3 = true;
            }
            if (this.br != null) {
                try {
                    this.br.close();
                }
                catch (IOException iOException) {
                    throw new SqlToolError(this.rb.getString(SqltoolRB.INPUTREADER_CLOSEFAIL), iOException);
                }
            }
            if (bl3 && this.possiblyUncommitteds.get()) {
                this.errprintln(this.rb.getString(SqltoolRB.ROLLINGBACK));
                this.curConn.rollback();
                this.possiblyUncommitteds.set(false);
            }
        }
    }

    private static String deTerminated(String string) {
        int n = string.lastIndexOf(59);
        if (n < 0) {
            return null;
        }
        for (int i = n + 1; i < string.length(); ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return null;
        }
        return string.substring(0, n);
    }

    public void processFromBuffer() throws BadSpecial, SQLException, SqlToolError {
        this.historize();
        if (this.buffer.charAt(0) == '*' && (this.buffer.length() < 2 || this.buffer.charAt(1) != '{')) {
            this.processPL(this.buffer);
            return;
        }
        if (this.buffer.charAt(0) == '\\') {
            this.processSpecial(this.buffer);
            return;
        }
        this.processSQL();
    }

    private void processBuffHist(String string) throws BadSpecial, SQLException, SqlToolError {
        if (string.length() < 1) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.BUFHIST_UNSPECIFIED));
        }
        char c = string.charAt(0);
        String string2 = string.substring(1);
        if (string2.trim().length() == 0) {
            string2 = null;
        }
        switch (c) {
            case 'b': 
            case 'l': {
                this.enforce1charBH(string2, 'l');
                if (this.buffer == null) {
                    this.stdprintln(this.nobufferYetString);
                } else {
                    this.stdprintln(this.rb.getString(SqltoolRB.EDITBUFFER_CONTENTS, this.buffer));
                }
                return;
            }
            case 'h': {
                this.enforce1charBH(string2, 'h');
                this.showHistory();
                return;
            }
            case '?': {
                this.stdprintln(this.rb.getString(SqltoolRB.BUFFER_HELP));
                return;
            }
        }
        Integer n = null;
        Matcher matcher = slashHistoryPattern.matcher(string);
        if (matcher.matches()) {
            n = this.historySearch(matcher.group(1));
            if (n == null) {
                this.stdprintln(this.rb.getString(SqltoolRB.SUBSTITUTION_NOMATCH));
                return;
            }
        } else {
            matcher = historyPattern.matcher(string);
            if (!matcher.matches()) {
                throw new BadSpecial(this.rb.getString(SqltoolRB.EDIT_MALFORMAT));
            }
            Integer n2 = n = matcher.group(1) == null || matcher.group(1).length() < 1 ? null : new Integer(matcher.group(1));
        }
        if (matcher.groupCount() != 2) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.EDIT_MALFORMAT));
        }
        c = matcher.group(2) == null || matcher.group(2).length() < 1 ? (char)'\u0000' : matcher.group(2).charAt(0);
        String string3 = string2 = c == '\u0000' ? null : matcher.group(2).substring(1);
        if (string2 != null && string2.length() < 1) {
            string2 = null;
        }
        String string4 = n == null ? null : this.commandFromHistory(n);
        switch (c) {
            case '\u0000': {
                this.setBuf(string4);
                this.stdprintln(this.rb.getString(SqltoolRB.BUFFER_RESTORED, this.buffer));
                return;
            }
            case ';': {
                this.enforce1charBH(string2, ';');
                if (string4 != null) {
                    this.setBuf(string4);
                }
                if (this.buffer == null) {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.NOBUFFER_YET));
                }
                this.stdprintln(this.rb.getString(SqltoolRB.BUFFER_EXECUTING, this.buffer));
                this.processFromBuffer();
                return;
            }
            case 'a': {
                if (string4 == null) {
                    string4 = this.buffer;
                }
                if (string4 == null) {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.NOBUFFER_YET));
                }
                this.immCmdSB.append(string4);
                if (string2 != null) {
                    String string5 = SqlFile.deTerminated(string2);
                    if (!string2.equals(";")) {
                        this.immCmdSB.append(string5 == null ? string2 : string5);
                    }
                    if (string5 != null) {
                        this.setBuf(this.immCmdSB.toString());
                        this.immCmdSB.setLength(0);
                        this.stdprintln(this.rb.getString(SqltoolRB.BUFFER_EXECUTING, this.buffer));
                        this.processFromBuffer();
                        return;
                    }
                }
                this.magicPrefix = this.immCmdSB.toString();
                this.immCmdSB.setLength(0);
                if (this.interactive) {
                    this.stdprint(this.magicPrefix);
                }
                return;
            }
            case 'w': {
                if (string4 == null) {
                    string4 = this.buffer;
                }
                if (string4 == null) {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.NOBUFFER_YET));
                }
                if (string2 == null) {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.DESTFILE_DEMAND));
                }
                String string6 = this.dereference(string2.trim(), false);
                PrintWriter printWriter = null;
                try {
                    printWriter = new PrintWriter(this.charset == null ? new OutputStreamWriter(new FileOutputStream(string6, true)) : new OutputStreamWriter((OutputStream)new FileOutputStream(string6, true), this.charset));
                    printWriter.print(string4);
                    if (!string4.matches("\\s*[*:\\\\].*")) {
                        printWriter.print(';');
                    }
                    printWriter.println();
                    printWriter.flush();
                }
                catch (Exception exception) {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.FILE_APPENDFAIL, string6), exception);
                }
                finally {
                    if (printWriter != null) {
                        printWriter.close();
                    }
                }
                return;
            }
            case 's': {
                boolean bl = false;
                boolean bl2 = false;
                if (string4 == null) {
                    string4 = this.buffer;
                }
                if (string4 == null) {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.NOBUFFER_YET));
                }
                try {
                    String string7;
                    String string8;
                    if (string2 == null || string2.length() < 3) {
                        throw new BadSubst(this.rb.getString(SqltoolRB.SUBSTITUTION_MALFORMAT));
                    }
                    Matcher matcher2 = substitutionPattern.matcher(string2);
                    if (!matcher2.matches()) {
                        throw new BadSubst(this.rb.getString(SqltoolRB.SUBSTITUTION_MALFORMAT));
                    }
                    if (matcher2.groupCount() < 3 || matcher2.groupCount() > 4) {
                        throw new RuntimeException("Matched substitution pattern, but captured " + matcher2.groupCount() + " groups");
                    }
                    String string9 = string8 = matcher2.groupCount() > 3 && matcher2.group(4) != null ? new String(matcher2.group(4)) : null;
                    if (string8 != null) {
                        if (string8.indexOf(59) > -1) {
                            bl = true;
                            string8 = string8.replaceFirst(";", "");
                        }
                        if (string8.indexOf(103) > -1) {
                            bl2 = true;
                            string8 = string8.replaceFirst("g", "");
                        }
                    }
                    Matcher matcher3 = Pattern.compile("(?s" + (string8 == null ? "" : string8) + ')' + matcher2.group(2)).matcher(string4);
                    String string10 = string7 = bl2 ? matcher3.replaceAll(matcher2.group(3)) : matcher3.replaceFirst(matcher2.group(3));
                    if (string7.equals(string4)) {
                        this.stdprintln(this.rb.getString(SqltoolRB.SUBSTITUTION_NOMATCH));
                        return;
                    }
                    this.setBuf(string7);
                    this.stdprintln(this.rb.getString(bl ? SqltoolRB.BUFFER_EXECUTING : SqltoolRB.EDITBUFFER_CONTENTS, this.buffer));
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.SUBSTITUTION_SYNTAX), patternSyntaxException);
                }
                catch (BadSubst badSubst) {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.SUBSTITUTION_SYNTAX));
                }
                if (bl) {
                    this.immCmdSB.setLength(0);
                    this.processFromBuffer();
                }
                return;
            }
        }
        throw new BadSpecial(this.rb.getString(SqltoolRB.BUFFER_UNKNOWN, Character.toString(c)));
    }

    private void enforce1charSpecial(String string, char c) throws BadSpecial {
        if (string.length() != 1) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.SPECIAL_EXTRACHARS, Character.toString(c), string.substring(1)));
        }
    }

    private void enforce1charBH(String string, char c) throws BadSpecial {
        if (string != null) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.BUFFER_EXTRACHARS, Character.toString(c), string));
        }
    }

    private void processSpecial(String string) throws BadSpecial, QuitNow, SQLException, SqlToolError {
        if (string.equals("\\")) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.SPECIAL_UNSPECIFIED));
        }
        Matcher matcher = specialPattern.matcher(this.plMode ? this.dereference(string, false) : string);
        if (!matcher.matches()) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.SPECIAL_MALFORMAT));
        }
        if (matcher.groupCount() < 1 || matcher.groupCount() > 2) {
            throw new RuntimeException("Pattern matched, yet captured " + matcher.groupCount() + " groups");
        }
        String string2 = matcher.group(1);
        String string3 = matcher.groupCount() > 1 ? matcher.group(2) : null;
        switch (string2.charAt(0)) {
            case 'q': {
                this.enforce1charSpecial(string2, 'q');
                if (string3 != null) {
                    throw new QuitNow(string3);
                }
                throw new QuitNow();
            }
            case 'H': {
                this.enforce1charSpecial(string2, 'H');
                this.htmlMode = !this.htmlMode;
                this.stdprintln(this.rb.getString(SqltoolRB.HTML_MODE, Boolean.toString(this.htmlMode)));
                return;
            }
            case 'm': {
                int n;
                if (string2.equals("m?") || string2.equals("m") && string3 != null && string3.equals("?")) {
                    this.stdprintln(this.DSV_OPTIONS_TEXT + LS + this.DSV_M_SYNTAX_MSG);
                    return;
                }
                if (string2.length() != 1 || string3 == null) {
                    throw new BadSpecial(this.DSV_M_SYNTAX_MSG);
                }
                boolean bl = string3.charAt(string3.length() - 1) == '*';
                String string4 = null;
                if (bl) {
                    if ((string3 = string3.substring(0, string3.length() - 1).trim()).length() < 1) {
                        throw new BadSpecial(this.DSV_M_SYNTAX_MSG);
                    }
                } else {
                    string4 = this.dsvSkipPrefix;
                }
                if ((n = string3.indexOf(" :")) > -1 && n < string3.length() - 2) {
                    string4 = string3.substring(n + 2);
                    string3 = string3.substring(0, n).trim();
                }
                this.importDsv(string3, string4);
                return;
            }
            case 'x': {
                if (string2.equals("x?") || string2.equals("x") && string3 != null && string3.equals("?")) {
                    this.stdprintln(this.DSV_OPTIONS_TEXT + LS + this.DSV_X_SYNTAX_MSG);
                    return;
                }
                try {
                    String string5;
                    if (string2.length() != 1 || string3 == null) {
                        throw new BadSpecial(this.DSV_X_SYNTAX_MSG);
                    }
                    String string6 = string5 = string3.indexOf(32) > 0 ? null : string3;
                    if (this.dsvTargetFile == null && string5 == null) {
                        throw new BadSpecial(this.rb.getString(SqltoolRB.DSV_TARGETFILE_DEMAND));
                    }
                    File file = new File(this.dsvTargetFile == null ? string5 + ".dsv" : this.dsvTargetFile);
                    this.pwDsv = new PrintWriter(this.charset == null ? new OutputStreamWriter(new FileOutputStream(file)) : new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.charset));
                    ResultSet resultSet = this.curConn.createStatement().executeQuery(string5 == null ? string3 : "SELECT * FROM " + string5);
                    ArrayList<Integer> arrayList = new ArrayList<Integer>();
                    int[] nArray = null;
                    if (this.dsvSkipCols != null) {
                        int n;
                        HashSet<String> hashSet = new HashSet<String>();
                        String[] stringArray = this.dsvSkipCols.split("\\s*\\Q" + this.dsvColDelim + "\\E\\s*");
                        for (int i = 0; i < stringArray.length; ++i) {
                            hashSet.add(stringArray[i].toLowerCase());
                        }
                        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                        for (n = 1; n <= resultSetMetaData.getColumnCount(); ++n) {
                            if (hashSet.remove(resultSetMetaData.getColumnName(n).toLowerCase())) continue;
                            arrayList.add(new Integer(n));
                        }
                        if (arrayList.size() < 1) {
                            throw new BadSpecial(this.rb.getString(SqltoolRB.DSV_NOCOLSLEFT, this.dsvSkipCols));
                        }
                        if (hashSet.size() > 0) {
                            throw new BadSpecial(this.rb.getString(SqltoolRB.DSV_SKIPCOLS_MISSING, ((Object)hashSet).toString()));
                        }
                        nArray = new int[arrayList.size()];
                        for (n = 0; n < nArray.length; ++n) {
                            nArray[n] = (Integer)arrayList.get(n);
                        }
                    }
                    this.displayResultSet(null, resultSet, nArray, null);
                    this.pwDsv.flush();
                    this.stdprintln(this.rb.getString(SqltoolRB.FILE_WROTECHARS, Long.toString(file.length()), file.toString()));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.FILE_WRITEFAIL, string3), fileNotFoundException);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.FILE_WRITEFAIL, string3), unsupportedEncodingException);
                }
                finally {
                    if (this.pwDsv != null) {
                        this.pwDsv.close();
                    }
                    this.pwDsv = null;
                }
                return;
            }
            case 'd': {
                if (string2.equals("d?") || string2.equals("d") && string3 != null && string3.equals("?")) {
                    this.stdprintln(this.D_OPTIONS_TEXT);
                    return;
                }
                if (string2.length() == 2) {
                    this.listTables(string2.charAt(1), string3);
                    return;
                }
                if (string2.length() == 1 && string3 != null) {
                    try {
                        int n = string3.indexOf(32);
                        if (n < 0) {
                            this.describe(string3, null);
                        } else {
                            this.describe(string3.substring(0, n), string3.substring(n + 1).trim());
                        }
                        return;
                    }
                    catch (SQLException sQLException) {
                        throw new BadSpecial(this.rb.getString(SqltoolRB.METADATA_FETCH_FAIL), sQLException);
                    }
                }
                throw new BadSpecial(this.rb.getString(SqltoolRB.SPECIAL_D_LIKE));
            }
            case 'o': {
                this.enforce1charSpecial(string2, 'o');
                if (string3 == null) {
                    if (this.pwQuery == null) {
                        throw new BadSpecial(this.rb.getString(SqltoolRB.OUTPUTFILE_NONETOCLOSE));
                    }
                    this.closeQueryOutputStream();
                    return;
                }
                if (this.pwQuery != null) {
                    this.stdprintln(this.rb.getString(SqltoolRB.OUTPUTFILE_REOPENING));
                    this.closeQueryOutputStream();
                }
                try {
                    this.pwQuery = new PrintWriter(this.charset == null ? new OutputStreamWriter(new FileOutputStream(string3, true)) : new OutputStreamWriter((OutputStream)new FileOutputStream(string3, true), this.charset));
                    this.pwQuery.println((this.htmlMode ? "<HTML>" + LS + "<!--" : DEFAULT_SKIP_PREFIX) + " " + new Date() + ".  " + this.rb.getString(SqltoolRB.OUTPUTFILE_HEADER, this.getClass().getName()) + (this.htmlMode ? " -->" + LS + LS + "<BODY>" : LS));
                    this.pwQuery.flush();
                }
                catch (Exception exception) {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.FILE_WRITEFAIL, string3), exception);
                }
                return;
            }
            case 'i': {
                this.enforce1charSpecial(string2, 'i');
                if (string3 == null) {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.SQLFILE_NAME_DEMAND));
                }
                try {
                    SqlFile sqlFile = new SqlFile(new File(string3), false, this.userVars);
                    sqlFile.recursed = true;
                    sqlFile.possiblyUncommitteds = this.possiblyUncommitteds;
                    sqlFile.plMode = this.plMode;
                    sqlFile.execute(this.curConn, this.continueOnError);
                }
                catch (ContinueException continueException) {
                    throw continueException;
                }
                catch (BreakException breakException) {
                    String string7 = breakException.getMessage();
                    if (string7 != null && !string7.equals("file")) {
                        throw breakException;
                    }
                }
                catch (QuitNow quitNow) {
                    throw quitNow;
                }
                catch (Exception exception) {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.SQLFILE_EXECUTE_FAIL, string3), exception);
                }
                return;
            }
            case 'p': {
                this.enforce1charSpecial(string2, 'p');
                if (string3 == null) {
                    this.stdprintln(true);
                } else {
                    this.stdprintln(string3, true);
                }
                return;
            }
            case 'a': {
                this.enforce1charSpecial(string2, 'a');
                if (string3 != null) {
                    this.curConn.setAutoCommit(Boolean.valueOf(string3));
                }
                this.stdprintln(this.rb.getString(SqltoolRB.A_SETTING, Boolean.toString(this.curConn.getAutoCommit())));
                return;
            }
            case '=': {
                this.enforce1charSpecial(string2, '=');
                this.curConn.commit();
                this.possiblyUncommitteds.set(false);
                this.stdprintln(this.rb.getString(SqltoolRB.COMMITTED));
                return;
            }
            case 'b': {
                if (string2.length() == 1) {
                    if (string3 != null) {
                        throw new BadSpecial(this.rb.getString(SqltoolRB.SPECIAL_B_MALFORMAT));
                    }
                    this.fetchBinary = true;
                    return;
                }
                if (string2.charAt(1) == 'p') {
                    if (string3 != null) {
                        throw new BadSpecial(this.rb.getString(SqltoolRB.SPECIAL_B_MALFORMAT));
                    }
                    this.doPrepare = true;
                    return;
                }
                if (string2.charAt(1) != 'd' && string2.charAt(1) != 'l' || string3 == null) {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.SPECIAL_B_MALFORMAT));
                }
                File file = new File(string3);
                try {
                    if (string2.charAt(1) == 'd') {
                        this.dump(file);
                    } else {
                        this.binBuffer = SqlFile.loadBinary(file);
                        this.stdprintln(this.rb.getString(SqltoolRB.BINARY_LOADEDBYTESINTO, this.binBuffer.length));
                    }
                }
                catch (BadSpecial badSpecial) {
                    throw badSpecial;
                }
                catch (IOException iOException) {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.BINARY_FILEFAIL, string3), iOException);
                }
                return;
            }
            case '*': 
            case 'c': {
                this.enforce1charSpecial(string2, '=');
                if (string3 != null) {
                    this.continueOnError = Boolean.valueOf(string3);
                }
                this.stdprintln(this.rb.getString(SqltoolRB.C_SETTING, Boolean.toString(this.continueOnError)));
                return;
            }
            case '?': {
                this.stdprintln(this.rb.getString(SqltoolRB.SPECIAL_HELP));
                return;
            }
            case '!': {
                byte[] byArray = new byte[1024];
                String string8 = (string2.length() == 1 ? "" : string2.substring(1)) + (string2.length() > 1 && string3 != null ? " " : "") + (string3 == null ? "" : string3);
                if (string8.trim().length() < 1) {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.BANG_INCOMPLETE));
                }
                try {
                    int n;
                    Runtime runtime = Runtime.getRuntime();
                    Process process = wincmdPattern == null ? runtime.exec(string8) : runtime.exec(SqlFile.genWinArgs(string8));
                    process.getOutputStream().close();
                    InputStream inputStream = process.getInputStream();
                    while ((n = inputStream.read(byArray)) > 0) {
                        this.stdprint(new String(byArray, 0, n));
                    }
                    inputStream.close();
                    inputStream = process.getErrorStream();
                    while ((n = inputStream.read(byArray)) > 0) {
                        this.errprint(new String(byArray, 0, n));
                    }
                    inputStream.close();
                    if (process.waitFor() != 0) {
                        throw new BadSpecial(this.rb.getString(SqltoolRB.BANG_COMMAND_FAIL, string8));
                    }
                }
                catch (BadSpecial badSpecial) {
                    throw badSpecial;
                }
                catch (Exception exception) {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.BANG_COMMAND_FAIL, string8), exception);
                }
                return;
            }
            case '.': {
                this.enforce1charSpecial(string2, '.');
                this.rawMode = 1;
                if (this.interactive) {
                    this.stdprintln(this.RAW_LEADIN_MSG);
                }
                return;
            }
        }
        throw new BadSpecial(this.rb.getString(SqltoolRB.SPECIAL_UNKNOWN, Character.toString(string2.charAt(0))));
    }

    static int pastName(String string, int n) {
        String string2 = string.substring(n);
        int n2 = string.length();
        for (int i = 0; i < nonVarChars.length; ++i) {
            int n3 = string2.indexOf(nonVarChars[i]);
            if (n3 <= -1 || n3 >= n2) continue;
            n2 = n3;
        }
        return n + n2;
    }

    private String dereference(String string, boolean bl) throws SqlToolError {
        boolean bl2;
        String string2;
        int n;
        String string3;
        String string4;
        int n2;
        StringBuffer stringBuffer = new StringBuffer(string);
        if (bl && string.trim().charAt(0) == '/') {
            int n3 = string.indexOf(47);
            n2 = SqlFile.pastName(string.substring(n3 + 1), 0);
            if (n2 < 1) {
                throw new SqlToolError(this.rb.getString(SqltoolRB.PLALIAS_MALFORMAT));
            }
            string4 = string.substring(n3 + 1, n3 + 1 + n2);
            string3 = (String)this.userVars.get(string4);
            if (string3 == null) {
                throw new SqlToolError(this.rb.getString(SqltoolRB.PLVAR_UNDEFINED, string4));
            }
            stringBuffer.replace(n3, n3 + 1 + n2, (String)this.userVars.get(string4));
        }
        int n4 = 0;
        while ((n = (string2 = stringBuffer.toString()).indexOf("${")) >= 0) {
            n2 = string2.indexOf(125, n + 2);
            if (n2 == n + 2) {
                throw new SqlToolError(this.rb.getString(SqltoolRB.SYSPROP_EMPTY));
            }
            if (n2 < 0) {
                throw new SqlToolError(this.rb.getString(SqltoolRB.SYSPROP_UNTERMINATED));
            }
            bl2 = string2.charAt(n + 2) == ':';
            string4 = string2.substring(n + (bl2 ? 3 : 2), n2);
            if (n4++ > 10000) {
                throw new SqlToolError(this.rb.getString(SqltoolRB.VAR_INFINITE, string4));
            }
            string3 = System.getProperty(string4);
            if (string3 == null) {
                if (bl2) {
                    string3 = "";
                } else {
                    throw new SqlToolError(this.rb.getString(SqltoolRB.SYSPROP_UNDEFINED, string4));
                }
            }
            stringBuffer.replace(n, n2 + 1, string3);
        }
        n4 = 0;
        while ((n = (string2 = stringBuffer.toString()).indexOf("*{")) >= 0) {
            n2 = string2.indexOf(125, n + 2);
            if (n2 == n + 2) {
                throw new SqlToolError(this.rb.getString(SqltoolRB.PLVAR_NAMEEMPTY));
            }
            if (n2 < 0) {
                throw new SqlToolError(this.rb.getString(SqltoolRB.PLVAR_UNTERMINATED));
            }
            bl2 = string2.charAt(n + 2) == ':';
            string4 = string2.substring(n + (bl2 ? 3 : 2), n2);
            if (n4++ > 10000) {
                throw new SqlToolError(this.rb.getString(SqltoolRB.VAR_INFINITE, string4));
            }
            string3 = (String)this.userVars.get(string4);
            if (string3 == null) {
                if (bl2) {
                    string3 = "";
                } else {
                    throw new SqlToolError(this.rb.getString(SqltoolRB.PLVAR_UNDEFINED, string4));
                }
            }
            stringBuffer.replace(n, n2 + 1, string3);
        }
        return stringBuffer.toString();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processPL(String var1_1) throws BadSpecial, SqlToolError {
        block69: {
            block71: {
                block72: {
                    block70: {
                        var2_2 = SqlFile.plPattern.matcher(this.dereference(var1_1, false));
                        if (!var2_2.matches()) {
                            throw new BadSpecial(this.rb.getString(SqltoolRB.PL_MALFORMAT));
                        }
                        if (var2_2.groupCount() < 1 || var2_2.group(1) == null) {
                            this.plMode = true;
                            this.stdprintln(this.rb.getString(SqltoolRB.PL_EXPANSIONMODE, "on"));
                            return;
                        }
                        var3_3 = var2_2.group(1).split("\\s+");
                        if (var3_3[0].charAt(0) == '?') {
                            this.stdprintln(this.rb.getString(SqltoolRB.PL_HELP));
                            return;
                        }
                        this.plMode = true;
                        if (var3_3[0].equals("end")) {
                            throw new BadSpecial(this.rb.getString(SqltoolRB.END_NOBLOCK));
                        }
                        if (var3_3[0].equals("continue")) {
                            if (var3_3.length <= 1) throw new ContinueException();
                            if (var3_3.length != 2) throw new BadSpecial(this.rb.getString(SqltoolRB.CONTINUE_SYNTAX));
                            if (var3_3[1].equals("foreach") != false) throw new ContinueException(var3_3[1]);
                            if (var3_3[1].equals("while") == false) throw new BadSpecial(this.rb.getString(SqltoolRB.CONTINUE_SYNTAX));
                            throw new ContinueException(var3_3[1]);
                        }
                        if (var3_3[0].equals("break")) {
                            if (var3_3.length <= 1) throw new BreakException();
                            if (var3_3.length != 2) throw new BadSpecial(this.rb.getString(SqltoolRB.BREAK_SYNTAX));
                            if (var3_3[1].equals("foreach") != false) throw new BreakException(var3_3[1]);
                            if (var3_3[1].equals("if") != false) throw new BreakException(var3_3[1]);
                            if (var3_3[1].equals("while") != false) throw new BreakException(var3_3[1]);
                            if (var3_3[1].equals("file") == false) throw new BadSpecial(this.rb.getString(SqltoolRB.BREAK_SYNTAX));
                            throw new BreakException(var3_3[1]);
                        }
                        if (!var3_3[0].equals("list") && !var3_3[0].equals("listvalues") && !var3_3[0].equals("listsysprops")) break block70;
                        var4_4 = var3_3[0].equals("listsysprops");
                        v0 = var6_9 = var3_3[0].equals("listvalues") != false || var4_4 != false;
                        if (var3_3.length == 1) {
                            this.stdprint(this.formatNicely(var4_4 != false ? System.getProperties() : this.userVars, var6_9));
                            return;
                        }
                        if (var6_9) {
                            this.stdprintln(this.rb.getString(SqltoolRB.PL_LIST_PARENS));
                            break block69;
                        } else {
                            this.stdprintln(this.rb.getString(SqltoolRB.PL_LIST_LENGTHS));
                        }
                        break block69;
                    }
                    if (var3_3[0].equals("dump") || var3_3[0].equals("load")) {
                        if (var3_3.length != 3) {
                            throw new BadSpecial(this.rb.getString(SqltoolRB.DUMPLOAD_MALFORMAT));
                        }
                        var4_5 = var3_3[1];
                        if (var4_5.indexOf(58) > -1) {
                            throw new BadSpecial(this.rb.getString(SqltoolRB.PLVAR_NOCOLON));
                        }
                        var5_29 = new File(var3_3[2]);
                        try {
                            if (var3_3[0].equals("dump")) {
                                this.dump(var4_5, var5_29);
                                return;
                            }
                            this.load(var4_5, var5_29, this.charset);
                            return;
                        }
                        catch (IOException var6_10) {
                            throw new BadSpecial(this.rb.getString(SqltoolRB.DUMPLOAD_FAIL, var4_5, var5_29.toString()), var6_10);
                        }
                    }
                    if (var3_3[0].equals("prepare")) {
                        if (var3_3.length != 2) {
                            throw new BadSpecial(this.rb.getString(SqltoolRB.PREPARE_MALFORMAT));
                        }
                        if (this.userVars.get(var3_3[1]) == null) {
                            throw new BadSpecial(this.rb.getString(SqltoolRB.PLVAR_UNDEFINED, var3_3[1]));
                        }
                        this.prepareVar = var3_3[1];
                        this.doPrepare = true;
                        return;
                    }
                    if (var3_3[0].equals("foreach")) {
                        var4_6 = SqlFile.foreachPattern.matcher(this.dereference(var1_1, false));
                        if (!var4_6.matches()) {
                            throw new BadSpecial(this.rb.getString(SqltoolRB.FOREACH_MALFORMAT));
                        }
                        if (var4_6.groupCount() != 2) {
                            throw new RuntimeException("foreach pattern matched, but captured " + var4_6.groupCount() + " groups");
                        }
                        var5_30 = var4_6.group(1);
                        if (var5_30.indexOf(58) > -1) {
                            throw new BadSpecial(this.rb.getString(SqltoolRB.PLVAR_NOCOLON));
                        }
                        var6_11 = var4_6.group(2).split("\\s+");
                        var7_14 = null;
                        try {
                            var7_14 = this.plBlockFile("foreach");
                        }
                        catch (IOException var9_32) {
                            throw new BadSpecial(this.rb.getString(SqltoolRB.PL_TEMPFILE_FAIL), var9_32);
                        }
                        var9_33 = (String)this.userVars.get(var5_30);
                        try {
                            for (var11_35 = 0; var11_35 < var6_11.length; ++var11_35) {
                                try {
                                    var8_37 = var6_11[var11_35];
                                    this.userVars.put(var5_30, var8_37);
                                    this.updateUserSettings();
                                    var10_41 = new SqlFile(var7_14, false, this.userVars);
                                    var10_41.plMode = true;
                                    var10_41.recursed = true;
                                    var10_41.possiblyUncommitteds = this.possiblyUncommitteds;
                                    var10_41.execute(this.curConn, this.continueOnError);
                                    continue;
                                }
                                catch (ContinueException var12_45) {
                                    var13_46 = var12_45.getMessage();
                                    if (var13_46 == null || var13_46.equals("foreach")) continue;
                                    throw var12_45;
                                }
                            }
                        }
                        catch (BreakException var10_42) {
                            var11_36 = var10_42.getMessage();
                            if (var11_36 != null && !var11_36.equals("foreach")) {
                                throw var10_42;
                            }
                        }
                        catch (QuitNow var10_43) {
                            throw var10_43;
                        }
                        catch (Exception var10_44) {
                            throw new BadSpecial(this.rb.getString(SqltoolRB.PL_BLOCK_FAIL), var10_44);
                        }
                        if (var9_33 == null) {
                            this.userVars.remove(var5_30);
                            this.updateUserSettings();
                        } else {
                            this.userVars.put(var5_30, var9_33);
                        }
                        if (var7_14 == null) return;
                        if (var7_14.delete() != false) return;
                        throw new BadSpecial(this.rb.getString(SqltoolRB.TEMPFILE_REMOVAL_FAIL, var7_14.toString()));
                    }
                    if (!var3_3[0].equals("if") && !var3_3[0].equals("while")) break block71;
                    var4_7 = SqlFile.ifwhilePattern.matcher(this.dereference(var1_1, false));
                    if (!var4_7.matches()) {
                        throw new BadSpecial(this.rb.getString(SqltoolRB.IFWHILE_MALFORMAT));
                    }
                    if (var4_7.groupCount() != 1) {
                        throw new RuntimeException("if/while pattern matched, but captured " + var4_7.groupCount() + " groups");
                    }
                    var5_31 = var4_7.group(1).replaceAll("!([a-zA-Z0-9*])", "! $1").replaceAll("([a-zA-Z0-9*])!", "$1 !").split("\\s+");
                    var6_12 = null;
                    if (!var3_3[0].equals("if")) break block72;
                    try {
                        var6_12 = this.plBlockFile("if");
                    }
                    catch (IOException var7_15) {
                        throw new BadSpecial(this.rb.getString(SqltoolRB.PL_BLOCK_FAIL), var7_15);
                    }
                    try {
                        if (!this.eval(var5_31)) ** GOTO lbl230
                        var7_16 = new SqlFile(var6_12, false, this.userVars);
                        var7_16.plMode = true;
                        var7_16.recursed = true;
                        var7_16.possiblyUncommitteds = this.possiblyUncommitteds;
                        var7_16.execute(this.curConn, this.continueOnError);
                    }
                    catch (BreakException var7_17) {
                        var8_38 = var7_17.getMessage();
                        if (var8_38 == null) throw var7_17;
                        if (var8_38.equals("if")) ** GOTO lbl230
                        throw var7_17;
                    }
                    catch (ContinueException var7_18) {
                        throw var7_18;
                    }
                    catch (QuitNow var7_19) {
                        throw var7_19;
                    }
                    catch (BadSpecial var7_20) {
                        var7_20.appendMessage(this.rb.getString(SqltoolRB.IF_MALFORMAT));
                        throw var7_20;
                    }
                    catch (Exception var7_21) {
                        throw new BadSpecial(this.rb.getString(SqltoolRB.PL_BLOCK_FAIL), var7_21);
                    }
                }
                if (var3_3[0].equals("while") == false) throw new RuntimeException(this.rb.getString(SqltoolRB.PL_UNKNOWN, var3_3[0]));
                try {
                    var6_12 = this.plBlockFile("while");
                }
                catch (IOException var7_22) {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.PL_TEMPFILE_FAIL), var7_22);
                }
                ** try [egrp 7[TRYBLOCK] [14, 15, 16, 17 : 1713->1809)] { 
lbl162:
                // 1 sources

                ** GOTO lbl-1000
            }
            var2_2 = SqlFile.varsetPattern.matcher(this.dereference(var1_1, false));
            if (!var2_2.matches()) {
                throw new BadSpecial(this.rb.getString(SqltoolRB.PL_UNKNOWN, var3_3[0]));
            }
            if (var2_2.groupCount() < 2) throw new RuntimeException("varset pattern matched but captured " + var2_2.groupCount() + " groups");
            if (var2_2.groupCount() > 3) {
                throw new RuntimeException("varset pattern matched but captured " + var2_2.groupCount() + " groups");
            }
            var4_8 = var2_2.group(1);
            if (var4_8.indexOf(58) > -1) {
                throw new BadSpecial(this.rb.getString(SqltoolRB.PLVAR_NOCOLON));
            }
            switch (var2_2.group(2).charAt(0)) {
                case '_': {
                    this.silentFetch = true;
                }
                case '~': {
                    if (var2_2.groupCount() > 2 && var2_2.group(3) != null) {
                        throw new BadSpecial(this.rb.getString(SqltoolRB.PLVAR_TILDEDASH_NOMOREARGS, var2_2.group(3)));
                    }
                    this.userVars.remove(var4_8);
                    this.updateUserSettings();
                    this.fetchingVar = var4_8;
                    return;
                }
                case '=': {
                    if (this.fetchingVar != null && this.fetchingVar.equals(var4_8)) {
                        this.fetchingVar = null;
                    }
                    if (var2_2.groupCount() > 2 && var2_2.group(3) != null) {
                        this.userVars.put(var4_8, var2_2.group(3));
                    } else {
                        this.userVars.remove(var4_8);
                    }
                    this.updateUserSettings();
                    return;
                }
            }
            throw new BadSpecial(this.rb.getString(SqltoolRB.PL_UNKNOWN, var3_3[0]));
        }
        var7_13 = 1;
        while (var7_13 < var3_3.length) {
            var5_28 = (String)(var4_4 != false ? System.getProperties() : this.userVars).get(var3_3[var7_13]);
            if (var5_28 != null) {
                this.stdprintln("    " + var3_3[var7_13] + ": " + (var6_9 != false ? "(" + var5_28 + ')' : Integer.toString(var5_28.length())));
            }
            ++var7_13;
        }
        return;
lbl-1000:
        // 3 sources

        {
            while (this.eval(var5_31)) {
                try {
                    var7_23 = new SqlFile(var6_12, false, this.userVars);
                    var7_23.recursed = true;
                    var7_23.possiblyUncommitteds = this.possiblyUncommitteds;
                    var7_23.plMode = true;
                    var7_23.execute(this.curConn, this.continueOnError);
                }
                catch (ContinueException var8_39) {
                    var9_34 = var8_39.getMessage();
                    if (var9_34 == null || var9_34.equals("while")) continue;
                    throw var8_39;
                }
            }
        }
lbl218:
        // 1 sources

        catch (BreakException var7_24) {
            var8_40 = var7_24.getMessage();
            if (var8_40 != null && !var8_40.equals("while")) {
                throw var7_24;
            }
        }
lbl223:
        // 1 sources

        catch (QuitNow var7_25) {
            throw var7_25;
        }
lbl225:
        // 1 sources

        catch (BadSpecial var7_26) {
            var7_26.appendMessage(this.rb.getString(SqltoolRB.WHILE_MALFORMAT));
            throw var7_26;
        }
lbl228:
        // 1 sources

        catch (Exception var7_27) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.PL_BLOCK_FAIL), var7_27);
        }
lbl230:
        // 5 sources

        if (var6_12 == null) return;
        if (var6_12.delete() != false) return;
        throw new BadSpecial(this.rb.getString(SqltoolRB.TEMPFILE_REMOVAL_FAIL, var6_12.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File plBlockFile(String string) throws IOException, SqlToolError {
        int n = 1;
        if (string == null || !string.equals("foreach") && !string.equals("if") && !string.equals("while")) {
            throw new RuntimeException("Assertion failed.  Unsupported PL block type:  " + string);
        }
        File file = File.createTempFile("sqltool-", ".sql");
        PrintWriter printWriter = new PrintWriter(this.charset == null ? new OutputStreamWriter(new FileOutputStream(file)) : new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.charset));
        try {
            printWriter.println("/* " + new Date() + ". " + this.getClass().getName() + " PL block. */");
            printWriter.println();
            while (true) {
                String string2;
                if ((string2 = this.br.readLine()) == null) {
                    string2 = this.rb.getString(SqltoolRB.PL_BLOCK_UNTERMINATED, string);
                    this.errprintln(string2);
                    throw new SqlToolError(string2);
                }
                ++this.curLinenum;
                Matcher matcher = plPattern.matcher(string2);
                if (matcher.matches() && matcher.groupCount() > 0 && matcher.group(1) != null) {
                    String[] stringArray = matcher.group(1).split("\\s+");
                    String string3 = stringArray[0];
                    if (string3.equals(string)) {
                        ++n;
                    } else if (string3.equals("end")) {
                        if (stringArray.length < 2) {
                            string2 = this.rb.getString(SqltoolRB.END_SYNTAX, "1");
                            this.errprintln(string2);
                            throw new SqlToolError(string2);
                        }
                        String string4 = stringArray[1];
                        if (string4.equals(string) && --n < 1) break;
                        if (!(string4.equals("foreach") || string4.equals("if") || string4.equals("while"))) {
                            string2 = this.rb.getString(SqltoolRB.END_SYNTAX, "2");
                            this.errprintln(string2);
                            throw new SqlToolError(string2);
                        }
                    }
                }
                printWriter.println(string2);
            }
            printWriter.flush();
        }
        finally {
            printWriter.close();
        }
        return file;
    }

    private void stdprint(String string) {
        this.stdprint(string, false);
    }

    private void stdprintln(String string) {
        this.stdprintln(string, false);
    }

    private void stdprintln(boolean bl) {
        if (this.htmlMode) {
            this.psStd.println("<BR>");
        } else {
            this.psStd.println();
        }
        if (bl && this.pwQuery != null) {
            if (this.htmlMode) {
                this.pwQuery.println("<BR>");
            } else {
                this.pwQuery.println();
            }
            this.pwQuery.flush();
        }
    }

    private void errprint(String string) {
        this.psErr.print(this.htmlMode ? "<DIV style='color:white; background: red; font-weight: bold'>" + string + "</DIV>" : string);
    }

    private void errprintln(String string) {
        this.psErr.println(this.htmlMode ? "<DIV style='color:white; background: red; font-weight: bold'>" + string + "</DIV>" : string);
    }

    private void stdprint(String string, boolean bl) {
        this.psStd.print(this.htmlMode ? "<P>" + string + "</P>" : string);
        if (bl && this.pwQuery != null) {
            this.pwQuery.print(this.htmlMode ? "<P>" + string + "</P>" : string);
            this.pwQuery.flush();
        }
    }

    private void stdprintln(String string, boolean bl) {
        this.psStd.println(this.htmlMode ? "<P>" + string + "</P>" : string);
        if (bl && this.pwQuery != null) {
            this.pwQuery.println(this.htmlMode ? "<P>" + string + "</P>" : string);
            this.pwQuery.flush();
        }
    }

    private void listTables(char c, String string) throws BadSpecial, SqlToolError {
        String string2 = null;
        int[] nArray = null;
        String[] stringArray = null;
        String[] stringArray2 = null;
        Statement statement = null;
        ResultSet resultSet = null;
        String string3 = "";
        String string4 = string;
        try {
            DatabaseMetaData databaseMetaData = this.curConn.getMetaData();
            String string5 = databaseMetaData.getDatabaseProductName();
            stringArray = new String[1];
            switch (c) {
                case '*': {
                    stringArray = null;
                    break;
                }
                case 'S': {
                    if (string5.indexOf("Oracle") > -1) {
                        this.errprintln(this.rb.getString(SqltoolRB.VENDOR_ORACLE_DS));
                        stringArray[0] = "TABLE";
                        string2 = "SYS";
                        stringArray2 = oracleSysSchemas;
                        break;
                    }
                    stringArray[0] = "SYSTEM TABLE";
                    break;
                }
                case 's': {
                    if (string5.indexOf("HSQL") > -1) {
                        if (string4 != null && string4.charAt(string4.length() - 1) == '.') {
                            string3 = "\nWHERE sequence_schema = '" + string4.substring(0, string4.length() - 1) + "'";
                            string4 = null;
                        }
                        statement = this.curConn.createStatement();
                        statement.execute("SELECT sequence_schema, sequence_name FROM information_schema.system_sequences" + string3);
                        break;
                    }
                    stringArray[0] = "SEQUENCE";
                    break;
                }
                case 'r': {
                    if (string5.indexOf("HSQL") > -1) {
                        statement = this.curConn.createStatement();
                        statement.execute("SELECT authorization_name FROM information_schema.system_authorizations\nWHERE authorization_type = 'ROLE'\nORDER BY authorization_name");
                        break;
                    }
                    if (string5.indexOf("Adaptive Server Enterprise") > -1) {
                        statement = this.curConn.createStatement();
                        statement.execute("SELECT name FROM syssrvroles ORDER BY name");
                        break;
                    }
                    if (string5.indexOf("Apache Derby") > -1) {
                        throw new BadSpecial(this.rb.getString(SqltoolRB.VENDOR_DERBY_DR));
                    }
                    throw new BadSpecial(this.rb.getString(SqltoolRB.VENDOR_NOSUP_D, "r"));
                }
                case 'u': {
                    if (string5.indexOf("HSQL") > -1) {
                        statement = this.curConn.createStatement();
                        statement.execute("SELECT user, admin FROM information_schema.system_users\nORDER BY user");
                        break;
                    }
                    if (string5.indexOf("Oracle") > -1) {
                        statement = this.curConn.createStatement();
                        statement.execute("SELECT username, created FROM all_users ORDER BY username");
                        break;
                    }
                    if (string5.indexOf("PostgreSQL") > -1) {
                        statement = this.curConn.createStatement();
                        statement.execute("SELECT usename, usesuper FROM pg_catalog.pg_user ORDER BY usename");
                        break;
                    }
                    if (string5.indexOf("Adaptive Server Enterprise") > -1) {
                        statement = this.curConn.createStatement();
                        statement.execute("SELECT name, accdate, fullname FROM syslogins ORDER BY name");
                        break;
                    }
                    if (string5.indexOf("Apache Derby") > -1) {
                        throw new BadSpecial(this.rb.getString(SqltoolRB.VENDOR_DERBY_DU));
                    }
                    throw new BadSpecial(this.rb.getString(SqltoolRB.VENDOR_NOSUP_D, "u"));
                }
                case 'a': {
                    if (string5.indexOf("HSQL") > -1) {
                        if (string4 != null && string4.charAt(string4.length() - 1) == '.') {
                            string3 = "\nWHERE alias_schem = '" + string4.substring(0, string4.length() - 1) + "'";
                            string4 = null;
                        }
                        statement = this.curConn.createStatement();
                        statement.execute("SELECT alias_schem, alias FROM information_schema.system_aliases" + string3);
                        break;
                    }
                    stringArray[0] = "ALIAS";
                    break;
                }
                case 't': {
                    this.excludeSysSchemas = string5.indexOf("Oracle") > -1;
                    stringArray[0] = "TABLE";
                    break;
                }
                case 'v': {
                    stringArray[0] = "VIEW";
                    break;
                }
                case 'n': {
                    resultSet = databaseMetaData.getSchemas();
                    if (resultSet == null) {
                        throw new BadSpecial("Failed to get metadata from database");
                    }
                    this.displayResultSet(null, resultSet, listMDSchemaCols, string4);
                    return;
                }
                case 'i': {
                    String string6 = null;
                    if (string4 != null) {
                        int n = string4.indexOf(46);
                        String string7 = string2 = n > 0 ? string4.substring(0, n) : null;
                        if (n < string4.length() - 1) {
                            string6 = n > 0 ? string4.substring(n + 1) : string4;
                        }
                        string4 = null;
                    }
                    if ((resultSet = databaseMetaData.getIndexInfo(null, string2, string6, false, true)) == null) {
                        throw new BadSpecial("Failed to get metadata from database");
                    }
                    this.displayResultSet(null, resultSet, listMDIndexCols, null);
                    return;
                }
                default: {
                    throw new BadSpecial(this.rb.getString(SqltoolRB.SPECIAL_D_UNKNOWN, Character.toString(c)) + LS + this.D_OPTIONS_TEXT);
                }
            }
            if (statement == null) {
                nArray = string5.indexOf("HSQL") > -1 ? listMDTableCols[1] : (string5.indexOf("Oracle") > -1 ? listMDTableCols[2] : listMDTableCols[0]);
                if (string2 == null && string4 != null && string4.charAt(string4.length() - 1) == '.') {
                    string2 = string4.substring(0, string4.length() - 1);
                    string4 = null;
                }
            }
            ResultSet resultSet2 = resultSet = statement == null ? databaseMetaData.getTables(null, string2, null, stringArray) : statement.getResultSet();
            if (resultSet == null) {
                throw new BadSpecial(this.rb.getString(SqltoolRB.METADATA_FETCH_FAIL));
            }
            this.displayResultSet(null, resultSet, nArray, string4);
            if (stringArray2 != null) {
                for (int i = 1; i < stringArray2.length; ++i) {
                    resultSet = databaseMetaData.getTables(null, stringArray2[i], null, stringArray);
                    if (resultSet == null) {
                        throw new BadSpecial(this.rb.getString(SqltoolRB.METADATA_FETCH_FAILFOR, stringArray2[i]));
                    }
                    if (!resultSet.next()) continue;
                    this.displayResultSet(null, databaseMetaData.getTables(null, stringArray2[i], null, stringArray), nArray, string4);
                }
            }
        }
        catch (SQLException sQLException) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.METADATA_FETCH_FAIL), sQLException);
        }
        catch (NullPointerException nullPointerException) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.METADATA_FETCH_FAIL), nullPointerException);
        }
        finally {
            this.excludeSysSchemas = false;
            if (resultSet != null) {
                resultSet = null;
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
                statement = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSQL() throws SQLException, SqlToolError {
        this.lastSqlStatement = this.plMode ? this.dereference(this.buffer, true) : this.buffer;
        Statement statement = null;
        if (this.doPrepare) {
            if (this.lastSqlStatement.indexOf(63) < 1) {
                this.lastSqlStatement = null;
                throw new SqlToolError(this.rb.getString(SqltoolRB.PREPARE_DEMANDQM));
            }
            this.doPrepare = false;
            PreparedStatement preparedStatement = this.curConn.prepareStatement(this.lastSqlStatement);
            if (this.prepareVar == null) {
                if (this.binBuffer == null) {
                    this.lastSqlStatement = null;
                    throw new SqlToolError(this.rb.getString(SqltoolRB.BINBUFFER_EMPTY));
                }
                preparedStatement.setBytes(1, this.binBuffer);
            } else {
                String string = (String)this.userVars.get(this.prepareVar);
                if (string == null) {
                    this.lastSqlStatement = null;
                    throw new SqlToolError(this.rb.getString(SqltoolRB.PLVAR_UNDEFINED, this.prepareVar));
                }
                this.prepareVar = null;
                preparedStatement.setString(1, string);
            }
            preparedStatement.executeUpdate();
            statement = preparedStatement;
        } else {
            statement = this.curConn.createStatement();
            statement.execute(this.lastSqlStatement);
        }
        this.possiblyUncommitteds.set(true);
        try {
            this.displayResultSet(statement, statement.getResultSet(), null, null);
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
        this.lastSqlStatement = null;
    }

    private void displayResultSet(Statement statement, ResultSet resultSet, int[] nArray, String string) throws SQLException, SqlToolError {
        int n = statement == null ? -1 : statement.getUpdateCount();
        boolean bl = this.silentFetch;
        boolean bl2 = this.fetchBinary;
        this.silentFetch = false;
        this.fetchBinary = false;
        if (this.excludeSysSchemas) {
            this.stdprintln(this.rb.getString(SqltoolRB.VENDOR_NOSUP_SYSSCHEMAS));
        }
        switch (n) {
            case -1: {
                int n2;
                String[] stringArray;
                int n3;
                boolean bl3;
                int n4;
                if (resultSet == null) {
                    this.stdprintln(this.rb.getString(SqltoolRB.NORESULT), true);
                    break;
                }
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int n5 = resultSetMetaData.getColumnCount();
                int n6 = nArray == null ? n5 : nArray.length;
                ArrayList<String[]> arrayList = new ArrayList<String[]>();
                String[] stringArray2 = null;
                int[] nArray2 = new int[n6];
                if (!this.htmlMode) {
                    for (int i = 0; i < nArray2.length; ++i) {
                        nArray2[i] = 0;
                    }
                }
                boolean[] blArray = new boolean[n6];
                int[] nArray3 = new int[n6];
                boolean[] blArray2 = new boolean[n6];
                int n7 = -1;
                stringArray2 = new String[n6];
                for (n4 = 1; n4 <= n5; ++n4) {
                    if (nArray != null) {
                        bl3 = true;
                        for (n3 = 0; n3 < nArray.length; ++n3) {
                            if (n4 != nArray[n3]) continue;
                            bl3 = false;
                        }
                        if (bl3) continue;
                    }
                    stringArray2[++n7] = resultSetMetaData.getColumnLabel(n4);
                    nArray3[n7] = resultSetMetaData.getColumnType(n4);
                    blArray[n7] = false;
                    blArray2[n7] = true;
                    switch (nArray3[n7]) {
                        case -7: 
                        case -6: 
                        case -5: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: {
                            blArray[n7] = true;
                            break;
                        }
                        case -4: 
                        case -3: 
                        case -1: 
                        case 12: 
                        case 2003: 
                        case 2004: 
                        case 2005: {
                            blArray2[n7] = false;
                        }
                    }
                    if (this.htmlMode || stringArray2[n7].length() <= nArray2[n7]) continue;
                    nArray2[n7] = stringArray2[n7].length();
                }
                while (resultSet.next()) {
                    stringArray = new String[n6];
                    n7 = -1;
                    n4 = string != null ? 1 : 0;
                    for (n3 = 1; n3 <= n5; ++n3) {
                        if (nArray != null) {
                            bl3 = true;
                            for (n2 = 0; n2 < nArray.length; ++n2) {
                                if (n3 != nArray[n2]) continue;
                                bl3 = false;
                            }
                            if (bl3) continue;
                        }
                        if (!SqlFile.canDisplayType(nArray3[++n7])) {
                            bl2 = true;
                        }
                        String string2 = null;
                        if (!bl2) {
                            switch (nArray3[n7]) {
                                case 91: 
                                case 92: 
                                case 93: {
                                    Timestamp timestamp = resultSet.getTimestamp(n3);
                                    String string3 = string2 = timestamp == null ? null : timestamp.toString();
                                    if (nArray3[n7] == 93 || string2 == null) break;
                                    int n8 = string2.lastIndexOf(46);
                                    for (n2 = n8 + 1; n2 < string2.length(); ++n2) {
                                        if (string2.charAt(n2) == '0') continue;
                                        n8 = 0;
                                        break;
                                    }
                                    if (n8 <= 1) break;
                                    string2 = string2.substring(0, n8);
                                    break;
                                }
                                default: {
                                    string2 = resultSet.getString(n3);
                                    if (string2 != null) break;
                                    try {
                                        string2 = this.streamToString(resultSet.getAsciiStream(n3), this.charset);
                                        break;
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            }
                        }
                        if (bl2 || string2 == null && !resultSet.wasNull()) {
                            if (this.pwDsv != null) {
                                throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_BINCOL));
                            }
                            try {
                                this.binBuffer = SqlFile.streamToBytes(resultSet.getBinaryStream(n3));
                            }
                            catch (IOException iOException) {
                                throw new SqlToolError("Failed to read value using stream", iOException);
                            }
                            this.stdprintln(this.rb.getString(SqltoolRB.BINBUF_WRITE, Integer.toString(this.binBuffer.length), stringArray2[n7], SqlFile.sqlTypeToString(nArray3[n7])));
                            return;
                        }
                        if (this.excludeSysSchemas && string2 != null && n3 == 2) {
                            for (int i = 0; i < oracleSysSchemas.length; ++i) {
                                if (!string2.equals(oracleSysSchemas[i])) continue;
                                n4 = 1;
                                break;
                            }
                        }
                        this.userVars.put("?", string2 == null ? this.nullRepToken : string2);
                        if (this.fetchingVar != null) {
                            this.userVars.put(this.fetchingVar, this.userVars.get("?"));
                            this.updateUserSettings();
                            this.fetchingVar = null;
                        }
                        if (bl) {
                            return;
                        }
                        if (string != null && (string2 == null || string2.indexOf(string) > -1)) {
                            n4 = 0;
                        }
                        stringArray[n7] = string2 == null && this.pwDsv == null ? (nArray3[n7] == 12 ? (this.htmlMode ? "<I>null</I>" : this.nullRepToken) : "") : string2;
                        if (this.htmlMode || this.pwDsv != null || stringArray[n7].length() <= nArray2[n7]) continue;
                        nArray2[n7] = stringArray[n7].length();
                    }
                    if (n4 != 0) continue;
                    arrayList.add(stringArray);
                }
                if (this.pwDsv == null) {
                    this.condlPrintln("<TABLE border='1'>", true);
                    if (n6 > 1) {
                        this.condlPrint(SqlFile.htmlRow(0) + LS + PRE_TD, true);
                        for (n3 = 0; n3 < stringArray2.length; ++n3) {
                            this.condlPrint("<TD>" + stringArray2[n3] + "</TD>", true);
                            this.condlPrint((n3 > 0 ? SqlFile.spaces(2) : "") + SqlFile.pad(stringArray2[n3], nArray2[n3], blArray[n3], n3 < stringArray2.length - 1 || blArray[n3]), false);
                        }
                        this.condlPrintln(LS + PRE_TR + "</TR>", true);
                        this.condlPrintln("", false);
                        if (!this.htmlMode) {
                            for (n3 = 0; n3 < stringArray2.length; ++n3) {
                                this.condlPrint((n3 > 0 ? SqlFile.spaces(2) : "") + SqlFile.divider(nArray2[n3]), false);
                            }
                            this.condlPrintln("", false);
                        }
                    }
                    for (n3 = 0; n3 < arrayList.size(); ++n3) {
                        this.condlPrint(SqlFile.htmlRow(n3 % 2 == 0 ? 2 : 1) + LS + PRE_TD, true);
                        stringArray = (String[])arrayList.get(n3);
                        for (n2 = 0; n2 < stringArray.length; ++n2) {
                            this.condlPrint("<TD>" + stringArray[n2] + "</TD>", true);
                            this.condlPrint((n2 > 0 ? SqlFile.spaces(2) : "") + SqlFile.pad(stringArray[n2], nArray2[n2], blArray[n2], n2 < stringArray.length - 1 || blArray[n2]), false);
                        }
                        this.condlPrintln(LS + PRE_TR + "</TR>", true);
                        this.condlPrintln("", false);
                    }
                    this.condlPrintln("</TABLE>", true);
                    if (arrayList.size() != 1) {
                        this.stdprintln(LS + this.rb.getString(SqltoolRB.ROWS_FETCHED, arrayList.size()), true);
                    }
                    this.condlPrintln("<HR>", true);
                    break;
                }
                if (n6 > 0) {
                    for (n3 = 0; n3 < stringArray2.length; ++n3) {
                        this.dsvSafe(stringArray2[n3]);
                        this.pwDsv.print(stringArray2[n3]);
                        if (n3 >= stringArray2.length - 1) continue;
                        this.pwDsv.print(this.dsvColDelim);
                    }
                    this.pwDsv.print(this.dsvRowDelim);
                }
                for (n3 = 0; n3 < arrayList.size(); ++n3) {
                    stringArray = (String[])arrayList.get(n3);
                    for (n2 = 0; n2 < stringArray.length; ++n2) {
                        this.dsvSafe(stringArray[n2]);
                        this.pwDsv.print(stringArray[n2] == null ? (blArray2[n2] ? "" : this.nullRepToken) : stringArray[n2]);
                        if (n2 >= stringArray.length - 1) continue;
                        this.pwDsv.print(this.dsvColDelim);
                    }
                    this.pwDsv.print(this.dsvRowDelim);
                }
                this.stdprintln(this.rb.getString(SqltoolRB.ROWS_FETCHED_DSV, arrayList.size()));
                break;
            }
            default: {
                this.userVars.put("?", Integer.toString(n));
                if (this.fetchingVar != null) {
                    this.userVars.put(this.fetchingVar, this.userVars.get("?"));
                    this.updateUserSettings();
                    this.fetchingVar = null;
                }
                if (n == 0) break;
                this.stdprintln(n == 1 ? this.rb.getString(SqltoolRB.ROW_UPDATE_SINGULAR) : this.rb.getString(SqltoolRB.ROW_UPDATE_MULTIPLE, n));
            }
        }
    }

    private static String htmlRow(int n) {
        switch (n) {
            case 0: {
                return PRE_TR + "<TR style='font-weight: bold;'>";
            }
            case 1: {
                return PRE_TR + "<TR style='background: #94d6ef; font: normal normal 10px/10px Arial, Helvitica, sans-serif;'>";
            }
            case 2: {
                return PRE_TR + "<TR style='background: silver; font: normal normal 10px/10px Arial, Helvitica, sans-serif;'>";
            }
        }
        return null;
    }

    private static String divider(int n) {
        return n > DIVIDER.length() ? DIVIDER : DIVIDER.substring(0, n);
    }

    private static String spaces(int n) {
        return n > SPACES.length() ? SPACES : SPACES.substring(0, n);
    }

    private static String pad(String string, int n, boolean bl, boolean bl2) {
        if (!bl2) {
            return string;
        }
        int n2 = n - string.length();
        if (n2 < 1) {
            return string;
        }
        String string2 = SqlFile.spaces(n2);
        return (bl ? string2 : "") + string + (bl ? "" : string2);
    }

    private void showHistory() throws BadSpecial {
        if (this.history == null) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.HISTORY_UNAVAILABLE));
        }
        if (this.history.size() < 1) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.HISTORY_NONE));
        }
        for (int i = 0; i < this.history.size(); ++i) {
            this.psStd.println(DEFAULT_SKIP_PREFIX + (i + this.oldestHist) + " or " + (i - this.history.size()) + ':');
            this.psStd.println((String)this.history.get(i));
        }
        if (this.buffer != null) {
            this.psStd.println(this.rb.getString(SqltoolRB.EDITBUFFER_CONTENTS, this.buffer));
        }
        this.psStd.println();
        this.psStd.println(this.rb.getString(SqltoolRB.BUFFER_INSTRUCTIONS));
    }

    private String commandFromHistory(int n) throws BadSpecial {
        int n2 = n;
        if (this.history == null) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.HISTORY_UNAVAILABLE));
        }
        if (n2 == 0) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.HISTORY_NUMBER_REQ));
        }
        if (n2 > 0) {
            if ((n2 -= this.oldestHist) < 0) {
                throw new BadSpecial(this.rb.getString(SqltoolRB.HISTORY_BACKTO, this.oldestHist));
            }
            if (n2 >= this.history.size()) {
                throw new BadSpecial(this.rb.getString(SqltoolRB.HISTORY_UPTO, this.history.size() + this.oldestHist - 1));
            }
        } else if ((n2 += this.history.size()) < 0) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.HISTORY_BACK, this.history.size()));
        }
        return (String)this.history.get(n2);
    }

    private Integer historySearch(String string) throws BadSpecial {
        if (this.history == null) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.HISTORY_UNAVAILABLE));
        }
        Pattern pattern = Pattern.compile("(?ims)" + string);
        for (int i = this.history.size() - 1; i >= 0; --i) {
            if (!pattern.matcher((String)this.history.get(i)).find()) continue;
            return new Integer(i + this.oldestHist);
        }
        return null;
    }

    private void setBuf(String string) {
        this.buffer = new String(string);
    }

    private void historize() {
        if (this.history == null || this.buffer == null) {
            return;
        }
        if (this.history.size() > 0 && this.history.get(this.history.size() - 1).equals(this.buffer)) {
            return;
        }
        this.history.add(this.buffer);
        if (this.history.size() <= this.maxHistoryLength) {
            return;
        }
        this.history.remove(0);
        ++this.oldestHist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void describe(String string, String string2) throws SQLException {
        String string3 = string2;
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        String[] stringArray = new String[]{this.rb.getString(SqltoolRB.DESCRIBE_TABLE_NAME), this.rb.getString(SqltoolRB.DESCRIBE_TABLE_DATATYPE), this.rb.getString(SqltoolRB.DESCRIBE_TABLE_WIDTH), this.rb.getString(SqltoolRB.DESCRIBE_TABLE_NONULLS)};
        int[] nArray = new int[]{0, 0, 0, 0};
        boolean[] blArray = new boolean[]{false, false, true, false};
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.htmlMode || stringArray[i].length() <= nArray[i]) continue;
            nArray[i] = stringArray[i].length();
        }
        Statement statement = this.curConn.createStatement();
        ResultSet resultSet = null;
        try {
            int n;
            String[] stringArray2;
            int n2;
            statement.execute("SELECT * FROM " + string + " WHERE 1 = 2");
            resultSet = statement.getResultSet();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n3 = resultSetMetaData.getColumnCount();
            for (n2 = 0; n2 < n3; ++n2) {
                stringArray2 = new String[4];
                stringArray2[0] = resultSetMetaData.getColumnName(n2 + 1);
                if (string3 != null && stringArray2[0].indexOf(string3) < 0) continue;
                stringArray2[1] = resultSetMetaData.getColumnTypeName(n2 + 1);
                stringArray2[2] = Integer.toString(resultSetMetaData.getColumnDisplaySize(n2 + 1));
                stringArray2[3] = resultSetMetaData.isNullable(n2 + 1) == 1 ? (this.htmlMode ? "&nbsp;" : "") : "*";
                arrayList.add(stringArray2);
                for (n = 0; n < stringArray2.length; ++n) {
                    if (stringArray2[n].length() <= nArray[n]) continue;
                    nArray[n] = stringArray2[n].length();
                }
            }
            this.condlPrint("<TABLE border='1'>" + LS + SqlFile.htmlRow(0) + LS + PRE_TD, true);
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                this.condlPrint("<TD>" + stringArray[n2] + "</TD>", true);
                this.condlPrint((n2 > 0 ? SqlFile.spaces(2) : "") + SqlFile.pad(stringArray[n2], nArray[n2], blArray[n2], n2 < stringArray.length - 1 || blArray[n2]), false);
            }
            this.condlPrintln(LS + PRE_TR + "</TR>", true);
            this.condlPrintln("", false);
            if (!this.htmlMode) {
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    this.condlPrint((n2 > 0 ? SqlFile.spaces(2) : "") + SqlFile.divider(nArray[n2]), false);
                }
                this.condlPrintln("", false);
            }
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                this.condlPrint(SqlFile.htmlRow(n2 % 2 == 0 ? 2 : 1) + LS + PRE_TD, true);
                stringArray2 = (String[])arrayList.get(n2);
                for (n = 0; n < stringArray2.length; ++n) {
                    this.condlPrint("<TD>" + stringArray2[n] + "</TD>", true);
                    this.condlPrint((n > 0 ? SqlFile.spaces(2) : "") + SqlFile.pad(stringArray2[n], nArray[n], blArray[n], n < stringArray2.length - 1 || blArray[n]), false);
                }
                this.condlPrintln(LS + PRE_TR + "</TR>", true);
                this.condlPrintln("", false);
            }
            this.condlPrintln(LS + "</TABLE>" + LS + "<HR>", true);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                    resultSet = null;
                }
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    private boolean eval(String[] stringArray) throws BadSpecial {
        boolean bl = stringArray.length > 0 && stringArray[0].equals("!");
        String[] stringArray2 = new String[bl ? stringArray.length - 1 : stringArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            String string = stringArray[i + (bl ? 1 : 0)];
            stringArray2[i] = string.length() > 1 && string.charAt(0) == '*' ? (String)this.userVars.get(string.substring(1)) : stringArray[i + (bl ? 1 : 0)];
            if (stringArray2[i] != null) continue;
            stringArray2[i] = "";
        }
        if (stringArray2.length == 1) {
            return (stringArray2[0].length() > 0 && !stringArray2[0].equals("0")) ^ bl;
        }
        if (stringArray2.length == 3) {
            if (stringArray2[1].equals("==")) {
                return stringArray2[0].equals(stringArray2[2]) ^ bl;
            }
            if (stringArray2[1].equals("!=") || stringArray2[1].equals("<>") || stringArray2[1].equals("><")) {
                return !stringArray2[0].equals(stringArray2[2]) ^ bl;
            }
            if (stringArray2[1].equals(">")) {
                return (stringArray2[0].length() > stringArray2[2].length() || stringArray2[0].length() == stringArray2[2].length() && stringArray2[0].compareTo(stringArray2[2]) > 0) ^ bl;
            }
            if (stringArray2[1].equals("<")) {
                return (stringArray2[2].length() > stringArray2[0].length() || stringArray2[2].length() == stringArray2[0].length() && stringArray2[2].compareTo(stringArray2[0]) > 0) ^ bl;
            }
        }
        throw new BadSpecial(this.rb.getString(SqltoolRB.LOGICAL_UNRECOGNIZED));
    }

    private void closeQueryOutputStream() {
        if (this.pwQuery == null) {
            return;
        }
        if (this.htmlMode) {
            this.pwQuery.println("</BODY></HTML>");
            this.pwQuery.flush();
        }
        this.pwQuery.close();
        this.pwQuery = null;
    }

    private void condlPrintln(String string, boolean bl) {
        if (bl && !this.htmlMode || this.htmlMode && !bl) {
            return;
        }
        this.psStd.println(string);
        if (this.pwQuery != null) {
            this.pwQuery.println(string);
            this.pwQuery.flush();
        }
    }

    private void condlPrint(String string, boolean bl) {
        if (bl && !this.htmlMode || this.htmlMode && !bl) {
            return;
        }
        this.psStd.print(string);
        if (this.pwQuery != null) {
            this.pwQuery.print(string);
            this.pwQuery.flush();
        }
    }

    private String formatNicely(Map map, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = new TreeMap(map).keySet().iterator();
        if (bl) {
            SqlFile.appendLine(stringBuffer, this.rb.getString(SqltoolRB.PL_LIST_PARENS));
        } else {
            SqlFile.appendLine(stringBuffer, this.rb.getString(SqltoolRB.PL_LIST_LENGTHS));
        }
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)map.get(string);
            SqlFile.appendLine(stringBuffer, "    " + string + ": " + (bl ? "(" + string2 + ')' : Integer.toString(string2.length())));
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dump(String string, File file) throws IOException, BadSpecial {
        String string2 = (String)this.userVars.get(string);
        if (string2 == null) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.PLVAR_UNDEFINED, string));
        }
        OutputStreamWriter outputStreamWriter = this.charset == null ? new OutputStreamWriter(new FileOutputStream(file)) : new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.charset);
        try {
            char c;
            outputStreamWriter.write(string2);
            if (string2.length() > 0 && (c = string2.charAt(string2.length() - 1)) != '\n' && c != '\r') {
                outputStreamWriter.write(LS);
            }
            outputStreamWriter.flush();
        }
        finally {
            outputStreamWriter.close();
        }
        this.stdprintln(this.rb.getString(SqltoolRB.FILE_WROTECHARS, Long.toString(file.length()), file.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dump(File file) throws IOException, BadSpecial {
        if (this.binBuffer == null) {
            throw new BadSpecial(this.rb.getString(SqltoolRB.BINBUFFER_EMPTY));
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        int n = 0;
        try {
            fileOutputStream.write(this.binBuffer);
            n = this.binBuffer.length;
            this.binBuffer = null;
            fileOutputStream.flush();
        }
        finally {
            fileOutputStream.close();
        }
        this.stdprintln(this.rb.getString(SqltoolRB.FILE_WROTECHARS, n, file.toString()));
    }

    /*
     * Exception decompiling
     */
    public String streamToString(InputStream var1_1, String var2_2) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void load(String string, File file, String string2) throws IOException {
        String string3 = this.streamToString(new FileInputStream(file), string2);
        this.userVars.put(string, string3);
        this.updateUserSettings();
    }

    public static byte[] streamToBytes(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[10240];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = inputStream.read(byArray)) > 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadBinary(File file) throws IOException {
        byte[] byArray = new byte[10240];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            int n;
            while ((n = fileInputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
        }
        finally {
            fileInputStream.close();
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        return byArray2;
    }

    public static boolean canDisplayType(int n) {
        switch (n) {
            case 1111: 
            case 2000: 
            case 2002: 
            case 2004: {
                return false;
            }
        }
        return true;
    }

    public static String sqlTypeToString(int n) {
        switch (n) {
            case 2003: {
                return "ARRAY";
            }
            case -5: {
                return "BIGINT";
            }
            case -2: {
                return "BINARY";
            }
            case -7: {
                return "BIT";
            }
            case 2004: {
                return "BLOB";
            }
            case 16: {
                return "BOOLEAN";
            }
            case 1: {
                return "CHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 70: {
                return "DATALINK";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 2001: {
                return "DISTINCT";
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INTEGER";
            }
            case 2000: {
                return "JAVA_OBJECT";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 0: {
                return "NULL";
            }
            case 2: {
                return "NUMERIC";
            }
            case 1111: {
                return "OTHER";
            }
            case 7: {
                return "REAL";
            }
            case 2006: {
                return "REF";
            }
            case 5: {
                return "SMALLINT";
            }
            case 2002: {
                return "STRUCT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return "VARCHAR";
            }
        }
        return "Unknown type " + n;
    }

    public void dsvSafe(String string) throws SqlToolError {
        if (this.pwDsv == null || this.dsvColDelim == null || this.dsvRowDelim == null || this.nullRepToken == null) {
            throw new RuntimeException("Assertion failed.  \ndsvSafe called when DSV settings are incomplete");
        }
        if (string == null) {
            return;
        }
        if (string.indexOf(this.dsvColDelim) > 0) {
            throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_COLDELIM_PRESENT, this.dsvColDelim));
        }
        if (string.indexOf(this.dsvRowDelim) > 0) {
            throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_ROWDELIM_PRESENT, this.dsvRowDelim));
        }
        if (string.trim().equals(this.nullRepToken)) {
            throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_NULLREP_PRESENT, this.nullRepToken));
        }
    }

    public static String convertEscapes(String string) {
        if (string == null) {
            return null;
        }
        return SqlFile.convertNumericEscapes(SqlFile.convertEscapes(SqlFile.convertEscapes(SqlFile.convertEscapes(SqlFile.convertEscapes(SqlFile.convertEscapes(string, "\\n", "\n"), "\\r", "\r"), "\\t", "\t"), "\\\\", "\\"), "\\f", "\f"));
    }

    private static String convertNumericEscapes(String string) {
        String string2 = string;
        int n = 0;
        for (char c = '0'; c <= '9'; c = (char)(c + '\u0001')) {
            while ((n = string2.indexOf("\\" + c, n)) > -1 && n < string2.length() - 1) {
                string2 = SqlFile.convertNumericEscape(string, n);
            }
            while ((n = string2.indexOf("\\x" + c, n)) > -1 && n < string2.length() - 1) {
                string2 = SqlFile.convertNumericEscape(string, n);
            }
            while ((n = string2.indexOf("\\X" + c, n)) > -1 && n < string2.length() - 1) {
                string2 = SqlFile.convertNumericEscape(string, n);
            }
        }
        return string2;
    }

    private static String convertNumericEscape(String string, int n) {
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        if (Character.toUpperCase(string.charAt(n + 1)) == 'X') {
            n3 = n + 2;
            n4 = 16;
            n2 = n3 + 2;
            if (n2 > string.length()) {
                n2 = string.length();
            }
        } else {
            n3 = n + 1;
            n4 = Character.toUpperCase(string.charAt(n3)) == '0' ? 8 : 10;
            for (n2 = n3 + 1; n2 < string.length() && Character.isDigit(string.charAt(n2)); ++n2) {
            }
        }
        return string.substring(0, n) + (char)Integer.parseInt(string.substring(n3, n2), n4) + string.substring(n2);
    }

    private static String convertEscapes(String string, String string2, String string3) {
        String string4 = string;
        int n = 0;
        int n2 = string2.length();
        while ((n = string4.indexOf(string2, n)) > -1 && n < string4.length() - 1) {
            string4 = string4.substring(0, n) + string3 + string4.substring(n + n2);
        }
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void importDsv(String string, String string2) throws SqlToolError {
        String string3;
        String[] stringArray;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        String string4;
        boolean bl;
        String string5;
        int n6;
        int n7;
        int n8;
        String string6;
        ArrayList<String> arrayList;
        String string7;
        TreeMap<String, String> treeMap;
        File file;
        block118: {
            String string8;
            String[] stringArray2;
            block117: {
                int n9;
                byte[] byArray = null;
                file = new File(string);
                treeMap = null;
                if (this.dsvConstCols != null) {
                    treeMap = new TreeMap<String, String>();
                    stringArray2 = this.dsvConstCols.split("\\Q" + this.dsvColDelim + "\\E\\s*");
                    for (int i = 0; i < stringArray2.length; ++i) {
                        int n10 = stringArray2[i].indexOf(61);
                        String string9 = stringArray2[i].substring(0, n10).trim().toLowerCase();
                        if (string9.trim().length() < 1) {
                            throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_CONSTCOLS_NULLCOL));
                        }
                        treeMap.put(string9, stringArray2[i].substring(n10 + 1));
                    }
                }
                stringArray2 = null;
                if (this.dsvSkipCols != null) {
                    stringArray2 = new HashSet();
                    String[] stringArray3 = this.dsvSkipCols.split("\\s*\\Q" + this.dsvColDelim + "\\E\\s*");
                    for (int i = 0; i < stringArray3.length; ++i) {
                        stringArray2.add(stringArray3[i].toLowerCase());
                    }
                }
                if (!file.canRead()) {
                    throw new SqlToolError(this.rb.getString(SqltoolRB.FILE_READFAIL, file.toString()));
                }
                try {
                    byArray = new byte[(int)file.length()];
                }
                catch (RuntimeException runtimeException) {
                    throw new SqlToolError(this.rb.getString(SqltoolRB.READ_TOOBIG), runtimeException);
                }
                FileInputStream fileInputStream = null;
                try {
                    int n11;
                    fileInputStream = new FileInputStream(file);
                    for (n9 = 0; n9 < byArray.length && (n11 = ((InputStream)fileInputStream).read(byArray, n9, byArray.length - n9)) > 0; n9 += n11) {
                    }
                }
                catch (IOException iOException) {
                    throw new SqlToolError(iOException);
                }
                finally {
                    if (fileInputStream != null) {
                        try {
                            ((InputStream)fileInputStream).close();
                        }
                        catch (IOException iOException) {
                            this.errprintln(this.rb.getString(SqltoolRB.INPUTFILE_CLOSEFAIL) + ": " + iOException);
                        }
                    }
                }
                if (n9 != byArray.length) {
                    throw new SqlToolError(this.rb.getString(SqltoolRB.READ_PARTIAL, n9, byArray.length));
                }
                string7 = null;
                try {
                    string7 = this.charset == null ? new String(byArray) : new String(byArray, this.charset);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new RuntimeException(unsupportedEncodingException);
                }
                catch (RuntimeException runtimeException) {
                    throw new SqlToolError(this.rb.getString(SqltoolRB.READ_CONVERTFAIL), runtimeException);
                }
                arrayList = new ArrayList<String>();
                string6 = this.dsvTargetTable;
                n8 = -1000;
                n7 = 0;
                n6 = -1;
                string5 = null;
                bl = false;
                while (true) {
                    int n12 = n6 = n6 < 0 ? 0 : n8 + this.dsvRowDelim.length();
                    if (n6 > string7.length() - 2) {
                        throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_HEADER_NONE));
                    }
                    n8 = string7.indexOf(this.dsvRowDelim, n6);
                    ++n7;
                    if (n8 < 0) {
                        n8 = string7.length();
                    }
                    if ((string5 = string7.substring(n6, n8).trim()).length() < 1 || string2 != null && string5.startsWith(string2)) continue;
                    if (string5.startsWith("targettable=")) {
                        if (string6 != null) continue;
                        string6 = string5.substring("targettable=".length()).trim();
                        continue;
                    }
                    if (string5.equals("headerswitch{")) {
                        if (string6 == null) {
                            throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_HEADER_NOSWITCHTARG, n7));
                        }
                        bl = true;
                        continue;
                    }
                    if (string5.equals("}")) {
                        throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_HEADER_NOSWITCHMATCH, n7));
                    }
                    if (!bl) break block117;
                    int n13 = string5.indexOf(58);
                    if (n13 < 1) throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_HEADER_NONSWITCHED, n7));
                    if (n13 == string5.length() - 1) {
                        throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_HEADER_NONSWITCHED, n7));
                    }
                    string8 = string5.substring(0, n13).trim();
                    if (string8.equals("*") || string8.equalsIgnoreCase(string6)) break;
                }
                n6 = 1 + string7.indexOf(58, n6);
            }
            string4 = string7.substring(n6, n8);
            n5 = n6;
            n4 = -1;
            while (true) {
                if (n4 == n8) {
                    if (stringArray2 != null) {
                        break;
                    }
                    break block118;
                }
                n4 = string7.indexOf(this.dsvColDelim, n5);
                if (n4 < 0 || n4 > n8) {
                    n4 = n8;
                }
                if (n4 - n5 < 1) {
                    throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_NOCOLHEADER, arrayList.size() + 1, n7));
                }
                string8 = string7.substring(n5, n4).trim().toLowerCase();
                arrayList.add(string8.equals("-") || stringArray2 != null && stringArray2.remove(string8) || treeMap != null && treeMap.containsKey(string8) ? (String)null : string8);
                n5 = n4 + this.dsvColDelim.length();
            }
            if (stringArray2.size() > 0) {
                throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_SKIPCOLS_MISSING, stringArray2.toString()));
            }
        }
        boolean bl2 = false;
        for (n3 = 0; n3 < arrayList.size(); ++n3) {
            if (arrayList.get(n3) == null) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_NOCOLSLEFT, this.dsvSkipCols));
        }
        n3 = arrayList.size();
        if (treeMap != null) {
            arrayList.addAll(treeMap.keySet());
        }
        String[] stringArray4 = arrayList.toArray(new String[0]);
        if (string6 == null && (n2 = (string6 = file.getName()).lastIndexOf(46)) > 0) {
            string6 = string6.substring(0, n2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n14 = 0;
        for (int i = 0; i < stringArray4.length; ++i) {
            if (stringArray4[i] == null) {
                ++n14;
                continue;
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(stringArray4[i]);
            arrayList2.add(stringArray4[i]);
        }
        boolean[] blArray = new boolean[stringArray4.length - n14];
        boolean[] blArray2 = new boolean[blArray.length];
        boolean[] blArray3 = new boolean[blArray.length];
        String[] stringArray5 = arrayList2.toArray(new String[0]);
        StringBuffer stringBuffer2 = new StringBuffer("INSERT INTO " + string6 + " (" + stringBuffer + ") VALUES (");
        StringBuffer stringBuffer3 = new StringBuffer("SELECT " + stringBuffer + " FROM " + string6 + " WHERE 1 = 2");
        try {
            ResultSetMetaData resultSetMetaData = this.curConn.createStatement().executeQuery(stringBuffer3.toString()).getMetaData();
            if (resultSetMetaData.getColumnCount() != blArray.length) {
                throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_METADATA_MISMATCH));
            }
            block48: for (int i = 0; i < blArray.length; ++i) {
                blArray[i] = true;
                blArray2[i] = false;
                blArray3[i] = false;
                switch (resultSetMetaData.getColumnType(i + 1)) {
                    case 16: {
                        blArray3[i] = true;
                        continue block48;
                    }
                    case -4: 
                    case -3: 
                    case -1: 
                    case 12: 
                    case 2003: 
                    case 2004: 
                    case 2005: {
                        blArray[i] = false;
                        continue block48;
                    }
                    case 91: 
                    case 92: 
                    case 93: {
                        blArray2[i] = true;
                        continue block48;
                    }
                }
            }
        }
        catch (SQLException sQLException) {
            throw new SqlToolError(this.rb.getString(SqltoolRB.QUERY_METADATAFAIL, stringBuffer3.toString()), sQLException);
        }
        for (n = 0; n < blArray.length; ++n) {
            if (n > 0) {
                stringBuffer2.append(", ");
            }
            stringBuffer2.append('?');
        }
        n = 0;
        File file2 = null;
        File file3 = null;
        PrintWriter printWriter = null;
        PrintWriter printWriter2 = null;
        if (this.dsvRejectFile != null) {
            try {
                file2 = new File(this.dsvRejectFile);
                printWriter = new PrintWriter(this.charset == null ? new OutputStreamWriter(new FileOutputStream(file2)) : new OutputStreamWriter((OutputStream)new FileOutputStream(file2), this.charset));
                printWriter.print(string4 + this.dsvRowDelim);
            }
            catch (IOException iOException) {
                throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_REJECTFILE_SETUPFAIL, this.dsvRejectFile), iOException);
            }
        }
        if (this.dsvRejectReport != null) {
            try {
                file3 = new File(this.dsvRejectReport);
                printWriter2 = new PrintWriter(this.charset == null ? new OutputStreamWriter(new FileOutputStream(file3)) : new OutputStreamWriter((OutputStream)new FileOutputStream(file3), this.charset));
                printWriter2.println(this.rb.getString(SqltoolRB.REJECTREPORT_TOP, new String[]{new Date().toString(), file.getPath(), file2 == null ? this.rb.getString(SqltoolRB.NONE) : file2.getPath(), file2 == null ? null : file2.getPath()}));
            }
            catch (IOException iOException) {
                throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_REJECTREPORT_SETUPFAIL, this.dsvRejectReport), iOException);
            }
        }
        int n15 = 0;
        int n16 = 0;
        PreparedStatement preparedStatement = null;
        boolean bl3 = false;
        try {
            try {
                preparedStatement = this.curConn.prepareStatement(stringBuffer2.toString() + ')');
            }
            catch (SQLException sQLException) {
                throw new SqlToolError(this.rb.getString(SqltoolRB.INSERTION_PREPAREFAIL, stringBuffer2.toString()), sQLException);
            }
            stringArray = new String[blArray.length];
            string3 = null;
            while (true) {
                try {}
                catch (RowError rowError) {
                    String string10;
                    ++n;
                    if (printWriter != null || printWriter2 != null) {
                        if (printWriter != null) {
                            printWriter.print(string7.substring(n6, n8) + this.dsvRowDelim);
                        }
                        if (printWriter2 == null) continue;
                        this.genRejectReportRecord(printWriter2, n, n7, string3, rowError.getMessage(), rowError.getCause());
                        continue;
                    }
                    bl3 = true;
                    StringBuilder stringBuilder = new StringBuilder().append(this.rb.getString(SqltoolRB.DSV_RECIN_FAIL, n7, string3));
                    if (rowError.getMessage() == null) {
                        string10 = "";
                        throw new SqlToolError(stringBuilder.append(string10).toString(), rowError.getCause());
                    }
                    string10 = "  " + rowError.getMessage();
                    throw new SqlToolError(stringBuilder.append(string10).toString(), rowError.getCause());
                }
                break;
            }
        }
        catch (Throwable throwable) {
            String string11 = null;
            if (n15 > 0) {
                string11 = this.rb.getString(SqltoolRB.DSV_IMPORT_SUMMARY, new String[]{string2 == null ? "" : "'" + string2 + "'-", Integer.toString(n16), Integer.toString(n), Integer.toString(n15 - n), bl3 ? "importAborted" : null});
                this.stdprintln(string11);
            }
            try {
                if (n15 > n && !this.curConn.getAutoCommit()) {
                    this.stdprintln(this.rb.getString(SqltoolRB.INSERTIONS_NOTCOMMITTED));
                }
            }
            catch (SQLException sQLException) {
                this.stdprintln(this.rb.getString(SqltoolRB.AUTOCOMMIT_FETCHFAIL));
                this.stdprintln(this.rb.getString(SqltoolRB.INSERTIONS_NOTCOMMITTED));
            }
            if (printWriter != null) {
                printWriter.flush();
                printWriter.close();
            }
            if (printWriter2 != null && n > 0) {
                printWriter2.println(this.rb.getString(SqltoolRB.REJECTREPORT_BOTTOM, string11, revnum));
                printWriter2.flush();
                printWriter2.close();
            }
            if (n != 0) throw throwable;
            if (file2 != null && file2.exists() && !file2.delete()) {
                this.errprintln(this.rb.getString(SqltoolRB.DSV_REJECTFILE_PURGEFAIL, file2.toString()));
            }
            if (file3 == null) throw throwable;
            if (file3.delete()) throw throwable;
            this.errprintln(this.rb.getString(SqltoolRB.DSV_REJECTREPORT_PURGEFAIL, file2 == null ? null : file2.toString()));
            throw throwable;
        }
        try {
            while ((n6 = n8 + this.dsvRowDelim.length()) < string7.length()) {
                n8 = string7.indexOf(this.dsvRowDelim, n6);
                ++n7;
                if (n8 < 0) {
                    n8 = string7.length();
                }
                if ((string5 = string7.substring(n6, n8).trim()).length() < 1) continue;
                if (string2 != null && string5.startsWith(string2)) {
                    ++n16;
                    continue;
                }
                if (bl) {
                    if (string5.equals("}")) {
                        bl = false;
                        continue;
                    }
                    int n17 = string5.indexOf(58);
                    if (n17 < 1) throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_HEADER_MATCHERNONHEAD, n7));
                    if (n17 != string5.length() - 1) continue;
                    throw new SqlToolError(this.rb.getString(SqltoolRB.DSV_HEADER_MATCHERNONHEAD, n7));
                }
                ++n15;
                n5 = n6;
                n4 = -1;
                int n18 = 0;
                int n19 = 0;
                while (true) {
                    if (n4 == n8) {
                        if (n18 < n3) {
                            throw new RowError(this.rb.getString(SqltoolRB.DSV_COLCOUNT_MISMATCH, n3, n18));
                        }
                        break;
                    }
                    n4 = string7.indexOf(this.dsvColDelim, n5);
                    if (n4 < 0 || n4 > n8) {
                        n4 = n8;
                    }
                    if (n18 == n3) {
                        throw new RowError(this.rb.getString(SqltoolRB.DSV_COLCOUNT_MISMATCH, n3, 1 + n18));
                    }
                    if (stringArray4[n18++] != null) {
                        stringArray[n19++] = string7.substring(n5, n4);
                    }
                    n5 = n4 + this.dsvColDelim.length();
                }
                if (treeMap != null) {
                    Iterator iterator = treeMap.values().iterator();
                    while (iterator.hasNext()) {
                        stringArray[n19++] = (String)iterator.next();
                    }
                }
                if (n19 != stringArray.length) {
                    throw new RowError(this.rb.getString(SqltoolRB.DSV_INSERTCOL_MISMATCH, stringArray.length, n19));
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    string3 = stringArray5[i];
                    if (blArray[i]) {
                        stringArray[i] = stringArray[i].trim();
                    }
                    if (blArray2[i]) {
                        if (stringArray[i].length() < 1 && blArray[i] || stringArray[i].equals(this.nullRepToken)) {
                            preparedStatement.setTimestamp(i + 1, null);
                        } else {
                            String string12 = stringArray[i].indexOf(58) > 0 ? stringArray[i] : stringArray[i] + " 0:00:00";
                            try {
                                preparedStatement.setTimestamp(i + 1, Timestamp.valueOf(string12));
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw new RowError(this.rb.getString(SqltoolRB.TIME_BAD, string12), illegalArgumentException);
                            }
                        }
                    } else if (blArray3[i]) {
                        if (stringArray[i].length() < 1 && blArray[i] || stringArray[i].equals(this.nullRepToken)) {
                            preparedStatement.setNull(i + 1, 16);
                        } else {
                            try {
                                preparedStatement.setBoolean(i + 1, Boolean.valueOf(stringArray[i]));
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw new RowError(this.rb.getString(SqltoolRB.BOOLEAN_BAD, stringArray[i]), illegalArgumentException);
                            }
                        }
                    } else {
                        preparedStatement.setString(i + 1, stringArray[i].length() < 1 && blArray[i] || stringArray[i].equals(this.nullRepToken) ? null : stringArray[i]);
                    }
                    string3 = null;
                }
                int n20 = preparedStatement.executeUpdate();
                if (n20 != 1) {
                    throw new RowError(this.rb.getString(SqltoolRB.INPUTREC_MODIFIED, n20));
                }
                this.possiblyUncommitteds.set(true);
            }
        }
        catch (SQLException sQLException) {
            throw new RowError(null, sQLException);
        }
        Object var44_67 = null;
        if (n15 > 0) {
            String string13 = this.rb.getString(SqltoolRB.DSV_IMPORT_SUMMARY, new String[]{string2 == null ? "" : "'" + string2 + "'-", Integer.toString(n16), Integer.toString(n), Integer.toString(n15 - n), bl3 ? "importAborted" : null});
            this.stdprintln(string13);
        }
        try {
            if (n15 > n && !this.curConn.getAutoCommit()) {
                this.stdprintln(this.rb.getString(SqltoolRB.INSERTIONS_NOTCOMMITTED));
            }
        }
        catch (SQLException sQLException) {
            this.stdprintln(this.rb.getString(SqltoolRB.AUTOCOMMIT_FETCHFAIL));
            this.stdprintln(this.rb.getString(SqltoolRB.INSERTIONS_NOTCOMMITTED));
        }
        if (printWriter != null) {
            printWriter.flush();
            printWriter.close();
        }
        if (printWriter2 != null && n > 0) {
            void var44_69;
            printWriter2.println(this.rb.getString(SqltoolRB.REJECTREPORT_BOTTOM, (String)var44_69, revnum));
            printWriter2.flush();
            printWriter2.close();
        }
        if (n != 0) return;
        if (file2 != null && file2.exists() && !file2.delete()) {
            this.errprintln(this.rb.getString(SqltoolRB.DSV_REJECTFILE_PURGEFAIL, file2.toString()));
        }
        if (file3 == null) return;
        if (file3.delete()) return;
        this.errprintln(this.rb.getString(SqltoolRB.DSV_REJECTREPORT_PURGEFAIL, file2 == null ? null : file2.toString()));
    }

    public static void appendLine(StringBuffer stringBuffer, String string) {
        stringBuffer.append(string + LS);
    }

    private static String[] genWinArgs(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("cmd.exe");
        arrayList.add("/y");
        arrayList.add("/c");
        Matcher matcher = wincmdPattern.matcher(string);
        while (matcher.find()) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                if (matcher.group(i) == null) continue;
                if (matcher.group(i).length() > 1 && matcher.group(i).charAt(0) == '\"') {
                    arrayList.add(matcher.group(i).substring(1, matcher.group(i).length() - 1));
                    continue;
                }
                String[] stringArray = matcher.group(i).split("\\s+");
                for (int j = 0; j < stringArray.length; ++j) {
                    arrayList.add(stringArray[j]);
                }
            }
        }
        return arrayList.toArray(new String[0]);
    }

    private void genRejectReportRecord(PrintWriter printWriter, int n, int n2, String string, String string2, Throwable throwable) {
        printWriter.println(this.rb.getString(SqltoolRB.REJECTREPORT_ROW, new String[]{(n % 2 == 0 ? "even" : "odd") + "row", Integer.toString(n), Integer.toString(n2), string == null ? "&nbsp;" : string, (string2 == null ? "" : string2) + (string2 == null || throwable == null ? "" : "<HR/>") + (throwable == null ? "" : (throwable instanceof SQLException && throwable.getMessage() != null ? throwable.getMessage() : throwable.toString()))}));
    }

    static {
        if (System.getProperty("os.name").startsWith("Windows")) {
            wincmdPattern = Pattern.compile("([^\"]+)?(\"[^\"]*\")?");
        }
        revnum = null;
        revnum = "354";
        DEFAULT_CHARSET = null;
        nonVarChars = new char[]{' ', '\t', '=', '}', '\n', '\r'};
        DEFAULT_ROW_DELIM = LS;
        listMDSchemaCols = new int[]{1};
        listMDIndexCols = new int[]{2, 6, 3, 9, 4, 10, 11};
        listMDTableCols = new int[][]{{2, 3}, {2, 3}, {2, 3}};
        oracleSysSchemas = new String[]{"SYS", "SYSTEM", "OUTLN", "DBSNMP", "OUTLN", "MDSYS", "ORDSYS", "ORDPLUGINS", "CTXSYS", "DSSYS", "PERFSTAT", "WKPROXY", "WKSYS", "WMSYS", "XDB", "ANONYMOUS", "ODM", "ODM_MTR", "OLAPSYS", "TRACESVR", "REPADMIN"};
        PRE_TR = SqlFile.spaces(4);
        PRE_TD = SqlFile.spaces(8);
    }

    private class RowError
    extends AppendableException {
        static final long serialVersionUID = 754346434606022750L;

        RowError(String string) {
            super(string);
        }

        RowError(Throwable throwable) {
            this(null, throwable);
        }

        RowError(String string, Throwable throwable) {
            super(string, throwable);
        }
    }

    private class BadSubst
    extends Exception {
        static final long serialVersionUID = 7325933736897253269L;

        BadSubst(String string) {
            super(string);
        }
    }

    private class ContinueException
    extends SqlToolError {
        static final long serialVersionUID = 5064604160827106014L;

        public ContinueException() {
        }

        public ContinueException(String string) {
            super(string);
        }
    }

    private class BreakException
    extends SqlToolError {
        static final long serialVersionUID = 351150072817675994L;

        public BreakException() {
        }

        public BreakException(String string) {
            super(string);
        }
    }

    private class QuitNow
    extends SqlToolError {
        static final long serialVersionUID = 1811094258670900488L;

        public QuitNow(String string) {
            super(string);
        }

        public QuitNow() {
        }
    }

    private static class BadSpecial
    extends AppendableException {
        static final long serialVersionUID = 7162440064026570590L;

        BadSpecial(String string) {
            super(string);
            if (string == null) {
                throw new RuntimeException("Must construct BadSpecials with non-null message");
            }
        }

        BadSpecial(String string, Throwable throwable) {
            super(string, throwable);
            if (string == null) {
                throw new RuntimeException("Must construct BadSpecials with non-null message");
            }
        }
    }

    private static class BooleanBucket {
        private boolean bPriv = false;

        BooleanBucket() {
        }

        public void set(boolean bl) {
            this.bPriv = bl;
        }

        public boolean get() {
            return this.bPriv;
        }
    }
}

