/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.monospace;

import java.util.HashMap;
import org.pentaho.reporting.libraries.fonts.LibFontBoot;
import org.pentaho.reporting.libraries.fonts.cache.FontCache;
import org.pentaho.reporting.libraries.fonts.monospace.MonospaceFontFamily;
import org.pentaho.reporting.libraries.fonts.monospace.MonospaceFontMetricsFactory;
import org.pentaho.reporting.libraries.fonts.registry.FontFamily;
import org.pentaho.reporting.libraries.fonts.registry.FontMetricsFactory;
import org.pentaho.reporting.libraries.fonts.registry.FontRegistry;

public class MonospaceFontRegistry
implements FontRegistry {
    private static FontCache secondLevelCache;
    private HashMap fontFamilies;
    private float lpi;
    private float cpi;
    private MonospaceFontFamily fallback;

    protected static synchronized FontCache internalGetSecondLevelCache() {
        if (secondLevelCache == null) {
            secondLevelCache = LibFontBoot.getInstance().createDefaultCache();
        }
        return secondLevelCache;
    }

    public MonospaceFontRegistry(float lpi, float cpi) {
        this.lpi = lpi;
        this.cpi = cpi;
        this.fontFamilies = new HashMap();
        this.fallback = new MonospaceFontFamily("Monospace");
    }

    @Override
    public FontCache getSecondLevelCache() {
        return MonospaceFontRegistry.internalGetSecondLevelCache();
    }

    public void add(MonospaceFontFamily family) {
        this.fontFamilies.put(family.getFamilyName(), family);
    }

    public MonospaceFontFamily getFallback() {
        return this.fallback;
    }

    public void setFallback(MonospaceFontFamily fallback) {
        this.fallback = fallback;
    }

    @Override
    public void initialize() {
    }

    @Override
    public FontFamily getFontFamily(String name) {
        FontFamily fontFamily = (FontFamily)this.fontFamilies.get(name);
        if (fontFamily != null) {
            return fontFamily;
        }
        return this.fallback;
    }

    @Override
    public String[] getRegisteredFamilies() {
        return this.fontFamilies.keySet().toArray(new String[this.fontFamilies.size()]);
    }

    @Override
    public String[] getAllRegisteredFamilies() {
        return this.fontFamilies.keySet().toArray(new String[this.fontFamilies.size()]);
    }

    @Override
    public FontMetricsFactory createMetricsFactory() {
        return new MonospaceFontMetricsFactory(this.lpi, this.cpi);
    }
}

