/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wiki;

import com.sun.star.awt.XCallback;
import com.sun.star.awt.XDialog;
import com.sun.star.awt.XMessageBox;
import com.sun.star.awt.XRequestCallback;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.uno.Any;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.wiki.WikiDialog;

public class MainThreadDialogExecutor
implements XCallback {
    private WikiDialog m_aWikiDialog;
    private XDialog m_xDialog;
    private XMessageBox m_xMessageBox;
    private boolean m_bResult = false;
    private boolean m_bCalled = false;
    private boolean m_bClose = false;

    public static boolean Show(XComponentContext xContext, WikiDialog aWikiDialog) {
        MainThreadDialogExecutor aExecutor = new MainThreadDialogExecutor(aWikiDialog);
        return MainThreadDialogExecutor.GetCallback(xContext, aExecutor);
    }

    public static boolean Execute(XComponentContext xContext, XMessageBox xMessageBox) {
        MainThreadDialogExecutor aExecutor = new MainThreadDialogExecutor(xMessageBox);
        return MainThreadDialogExecutor.GetCallback(xContext, aExecutor);
    }

    public static boolean Close(XComponentContext xContext, XDialog xDialog) {
        MainThreadDialogExecutor aExecutor = new MainThreadDialogExecutor(xDialog);
        aExecutor.m_bClose = true;
        aExecutor.m_bCalled = true;
        return MainThreadDialogExecutor.GetCallback(xContext, aExecutor);
    }

    private static boolean GetCallback(XComponentContext xContext, MainThreadDialogExecutor aExecutor) {
        if (aExecutor == null) {
            return false;
        }
        try {
            String aThreadName = null;
            Thread aCurThread = Thread.currentThread();
            if (aCurThread != null) {
                aThreadName = aCurThread.getName();
            }
            if (aThreadName != null && aThreadName.equals("com.sun.star.thread.WikiEditorSendingThread")) {
                XMultiComponentFactory xFactory = xContext.getServiceManager();
                if (xFactory == null) {
                    throw new RuntimeException();
                }
                XRequestCallback xRequest = (XRequestCallback)UnoRuntime.queryInterface(XRequestCallback.class, (Object)xFactory.createInstanceWithContext("com.sun.star.awt.AsyncCallback", xContext));
                if (xRequest != null) {
                    xRequest.addCallback((XCallback)aExecutor, (Object)Any.VOID);
                    do {
                        Thread.yield();
                    } while (!aExecutor.m_bCalled);
                }
            } else {
                aExecutor.notify(Any.VOID);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return aExecutor.GetResult();
    }

    private MainThreadDialogExecutor(WikiDialog aWikiDialog) {
        this.m_aWikiDialog = aWikiDialog;
    }

    private MainThreadDialogExecutor(XDialog xDialog) {
        this.m_xDialog = xDialog;
    }

    private MainThreadDialogExecutor(XMessageBox xMessageBox) {
        this.m_xMessageBox = xMessageBox;
    }

    private boolean GetResult() {
        return this.m_bResult;
    }

    public void notify(Object aData) {
        if (this.m_aWikiDialog != null) {
            this.m_bResult = this.m_aWikiDialog.show();
        } else if (this.m_xDialog != null) {
            if (!this.m_bClose) {
                this.m_bResult = this.m_xDialog.execute() == 1;
            } else {
                try {
                    this.m_xDialog.endExecute();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.m_bResult = true;
            }
        } else if (this.m_xMessageBox != null) {
            short nRes = this.m_xMessageBox.execute();
            this.m_bResult = nRes == 1 || nRes == 2;
        }
        this.m_bCalled = true;
    }
}

