/*
 * Decompiled with CFR 0.152.
 */
package bsh.util;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.util.StringTokenizer;

class HttpdConnection
extends Thread {
    Socket client;
    BufferedReader in;
    OutputStream out;
    PrintStream pout;
    boolean isHttp1;

    HttpdConnection(Socket socket) {
        this.client = socket;
        this.setPriority(4);
    }

    @Override
    public void run() {
        try {
            Object object;
            this.in = new BufferedReader(new InputStreamReader(this.client.getInputStream()));
            this.out = this.client.getOutputStream();
            this.pout = new PrintStream(this.out);
            String string = this.in.readLine();
            if (string == null) {
                this.error(400, "Empty Request");
            }
            if (string.toLowerCase().indexOf("http/1.") != -1) {
                while (!((String)(object = this.in.readLine())).equals("") && object != null) {
                }
                this.isHttp1 = true;
            }
            if (((StringTokenizer)(object = new StringTokenizer(string))).countTokens() < 2) {
                this.error(400, "Bad Request");
            } else {
                String string2 = ((StringTokenizer)object).nextToken();
                if (string2.equals("GET")) {
                    this.serveFile(((StringTokenizer)object).nextToken());
                } else {
                    this.error(400, "Bad Request");
                }
            }
            this.client.close();
        }
        catch (IOException iOException) {
            System.out.println("I/O error " + iOException);
            try {
                this.client.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void serveFile(String object) throws FileNotFoundException, IOException {
        if (((String)object).equals("/")) {
            object = "/remote/remote.html";
        }
        if (((String)object).startsWith("/remote/")) {
            object = "/bsh/util/lib/" + ((String)object).substring(8);
        }
        if (((String)object).startsWith("/java")) {
            this.error(404, "Object Not Found");
        } else {
            try {
                System.out.println("sending file: " + (String)object);
                this.sendFileData((String)object);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.error(404, "Object Not Found");
            }
        }
    }

    private void sendFileData(String string) throws IOException, FileNotFoundException {
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        if (inputStream == null) {
            throw new FileNotFoundException(string);
        }
        byte[] byArray = new byte[inputStream.available()];
        if (this.isHttp1) {
            this.pout.println("HTTP/1.0 200 Document follows");
            this.pout.println("Content-length: " + byArray.length);
            if (string.endsWith(".gif")) {
                this.pout.println("Content-type: image/gif");
            } else if (string.endsWith(".html") || string.endsWith(".htm")) {
                this.pout.println("Content-Type: text/html");
            } else {
                this.pout.println("Content-Type: application/octet-stream");
            }
            this.pout.println();
        }
        int n = 0;
        do {
            if ((n = inputStream.read(byArray)) <= 0) continue;
            this.pout.write(byArray, 0, n);
        } while (n != -1);
        this.pout.flush();
    }

    private void error(int n, String object) {
        object = "<html><h1>" + (String)object + "</h1></html>";
        if (this.isHttp1) {
            this.pout.println("HTTP/1.0 " + n + " " + (String)object);
            this.pout.println("Content-type: text/html");
            this.pout.println("Content-length: " + ((String)object).length() + "\n");
        }
        this.pout.println((String)object);
    }
}

