/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Method;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.PropertyException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public final class LazilyLoadedCtor {
    private static Method getter;
    private static Method setter;
    private String ctorName;
    private String className;
    private boolean sealed;
    private boolean isReplaced;

    public LazilyLoadedCtor(ScriptableObject scope, String ctorName, String className, boolean sealed) {
        this.className = className;
        this.ctorName = ctorName;
        this.sealed = sealed;
        if (getter == null) {
            Method[] methods = FunctionObject.getMethodList(this.getClass());
            getter = FunctionObject.findSingleMethod(methods, "getProperty");
            setter = FunctionObject.findSingleMethod(methods, "setProperty");
        }
        try {
            scope.defineProperty(ctorName, this, getter, setter, 2);
        }
        catch (PropertyException e) {
            throw Context.throwAsScriptRuntimeEx(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(ScriptableObject obj) {
        ScriptableObject scriptableObject = obj;
        synchronized (scriptableObject) {
            if (!this.isReplaced) {
                boolean removeOnError = false;
                Class cl = Kit.classOrNull(this.className);
                if (cl == null) {
                    removeOnError = true;
                } else {
                    try {
                        ScriptableObject.defineClass(obj, cl, this.sealed);
                        this.isReplaced = true;
                    }
                    catch (SecurityException ex) {
                        removeOnError = true;
                    }
                    catch (Exception e) {
                        throw Context.throwAsScriptRuntimeEx(e);
                    }
                }
                if (removeOnError) {
                    obj.delete(this.ctorName);
                    return Scriptable.NOT_FOUND;
                }
            }
        }
        return obj.get(this.ctorName, (Scriptable)obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object setProperty(ScriptableObject obj, Object val) {
        ScriptableObject scriptableObject = obj;
        synchronized (scriptableObject) {
            this.isReplaced = true;
            return val;
        }
    }
}

