/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.debug.DebugFrame;
import org.mozilla.javascript.debug.DebuggableScript;
import org.mozilla.javascript.tools.debugger.ContextData;
import org.mozilla.javascript.tools.debugger.Main;
import org.mozilla.javascript.tools.debugger.ScriptItem;
import org.mozilla.javascript.tools.debugger.SourceInfo;

class FrameHelper
implements DebugFrame {
    private Main db;
    private ContextData contextData;
    private Scriptable activation;
    private DebuggableScript fnOrScript;
    private SourceInfo sourceInfo;
    private int lineNumber;

    FrameHelper(Context cx, Main db, DebuggableScript fnOrScript) {
        this.db = db;
        this.contextData = ContextData.get(cx);
        this.fnOrScript = fnOrScript;
        ScriptItem item = db.getScriptItem(fnOrScript);
        if (item != null) {
            this.sourceInfo = item.getSourceInfo();
            this.lineNumber = item.getFirstLine();
        }
        this.contextData.pushFrame(this);
    }

    @Override
    public void onEnter(Context cx, Scriptable activation, Scriptable thisObj, Object[] args) {
        this.activation = activation;
        if (this.db.breakOnEnter) {
            this.db.handleBreakpointHit(cx);
        }
    }

    @Override
    public void onLineChange(Context cx, int lineno) {
        this.lineNumber = lineno;
        if (this.contextData.breakNextLine || this.sourceInfo != null && this.sourceInfo.hasBreakpoint(lineno)) {
            this.db.handleBreakpointHit(cx);
        }
    }

    @Override
    public void onExceptionThrown(Context cx, Throwable exception) {
        this.db.handleExceptionThrown(cx, exception, this);
    }

    @Override
    public void onExit(Context cx, boolean byThrow, Object resultOrException) {
        if (this.db.breakOnReturn && !byThrow) {
            this.db.handleBreakpointHit(cx);
        }
        this.contextData.popFrame();
    }

    SourceInfo getSourceInfo() {
        return this.sourceInfo;
    }

    Scriptable getVariableObject() {
        return this.activation;
    }

    String getUrl() {
        if (this.sourceInfo != null) {
            return this.sourceInfo.getUrl();
        }
        return this.db.getNormilizedUrl(this.fnOrScript);
    }

    int getLineNumber() {
        return this.lineNumber;
    }

    DebuggableScript getScript() {
        return this.fnOrScript;
    }
}

