/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.hsqldb.util.ZaurusTableForm;

public class ZaurusEditor
extends Panel
implements ActionListener {
    static TextField tStatus;
    Connection cConn;
    DatabaseMetaData dbmeta;
    Button bSearchRow;
    Button bNewRow;
    Button bCancel1;
    Button bPrev;
    Button bNext;
    Button bDelete;
    Button bNewSearch;
    Button bCancel2;
    Button bNewInsert;
    Button bNewSearch1;
    Panel pSearchButs;
    Panel pEditButs;
    Panel pInsertButs;
    Vector vHoldTableNames;
    Vector vHoldForms;
    int aktHoldNr;
    Panel pForm;
    Panel pButton;
    CardLayout lForm;
    CardLayout lButton;
    TextField fSearchWords;
    Choice cTables;
    CheckboxGroup gAllWords;
    CheckboxGroup gIgnoreCase;
    CheckboxGroup gNoMatchWhole;
    boolean lastButtonDelete;

    public static void printStatus(String string) {
        tStatus.setText(string);
    }

    public static void clearStatus() {
        tStatus.setText("");
    }

    public ZaurusEditor() {
        this.initGUI();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Button button = (Button)actionEvent.getSource();
        if (button == this.bSearchRow) {
            this.resetLastButtonDelete();
            this.aktHoldNr = this.getChoosenTableIndex();
            int n = ((ZaurusTableForm)this.vHoldForms.elementAt(this.aktHoldNr)).searchRows(this.getWords(), this.gAllWords.getSelectedCheckbox().getLabel().equals("all"), this.gIgnoreCase.getSelectedCheckbox().getLabel().equals("yes"), this.gNoMatchWhole.getSelectedCheckbox().getLabel().equals("no"));
            String string = (String)this.vHoldTableNames.elementAt(this.aktHoldNr);
            if (n > 0) {
                this.lForm.show(this.pForm, string);
                this.lButton.show(this.pButton, "edit");
                this.bPrev.setEnabled(false);
                this.bNext.setEnabled(n != 1);
                ZaurusEditor.printStatus("found " + n + " rows in table " + string);
            } else if (n == 0) {
                ZaurusEditor.printStatus("no rows found in table " + string);
            }
        } else if (button == this.bNewRow) {
            this.aktHoldNr = this.getChoosenTableIndex();
            this.lForm.show(this.pForm, (String)this.vHoldTableNames.elementAt(this.aktHoldNr));
            this.lButton.show(this.pButton, "insert");
            ((ZaurusTableForm)this.vHoldForms.elementAt(this.aktHoldNr)).insertNewRow();
        } else if (button == this.bNewInsert) {
            this.resetLastButtonDelete();
            if (((ZaurusTableForm)this.vHoldForms.elementAt(this.aktHoldNr)).saveNewRow()) {
                ((ZaurusTableForm)this.vHoldForms.elementAt(this.aktHoldNr)).insertNewRow();
            }
        } else if (button == this.bNewSearch) {
            this.resetLastButtonDelete();
            if (((ZaurusTableForm)this.vHoldForms.elementAt(this.aktHoldNr)).saveChanges()) {
                this.lForm.show(this.pForm, "search");
                this.lButton.show(this.pButton, "search");
            }
        } else if (button == this.bNewSearch1) {
            this.resetLastButtonDelete();
            if (((ZaurusTableForm)this.vHoldForms.elementAt(this.aktHoldNr)).saveNewRow()) {
                this.lForm.show(this.pForm, "search");
                this.lButton.show(this.pButton, "search");
            }
        } else if (button == this.bNext) {
            this.resetLastButtonDelete();
            ZaurusEditor.clearStatus();
            if (((ZaurusTableForm)this.vHoldForms.elementAt(this.aktHoldNr)).saveChanges()) {
                this.bPrev.setEnabled(true);
                if (!((ZaurusTableForm)this.vHoldForms.elementAt(this.aktHoldNr)).nextRow()) {
                    this.bNext.setEnabled(false);
                }
            }
        } else if (button == this.bPrev) {
            this.resetLastButtonDelete();
            ZaurusEditor.clearStatus();
            if (((ZaurusTableForm)this.vHoldForms.elementAt(this.aktHoldNr)).saveChanges()) {
                this.bNext.setEnabled(true);
                if (!((ZaurusTableForm)this.vHoldForms.elementAt(this.aktHoldNr)).prevRow()) {
                    this.bPrev.setEnabled(false);
                }
            }
        } else if (button == this.bCancel1) {
            this.resetLastButtonDelete();
            ((ZaurusTableForm)this.vHoldForms.elementAt(this.aktHoldNr)).cancelChanges();
        } else if (button == this.bCancel2) {
            this.resetLastButtonDelete();
            this.lForm.show(this.pForm, "search");
            this.lButton.show(this.pButton, "search");
        } else if (button == this.bDelete) {
            if (this.lastButtonDelete) {
                switch (((ZaurusTableForm)this.vHoldForms.elementAt(this.aktHoldNr)).deleteRow()) {
                    case 1: {
                        this.lForm.show(this.pForm, "search");
                        this.lButton.show(this.pButton, "search");
                        break;
                    }
                    case 2: {
                        this.bPrev.setEnabled(false);
                        break;
                    }
                    case 3: {
                        this.bNext.setEnabled(false);
                        break;
                    }
                }
                this.lastButtonDelete = false;
            } else {
                ZaurusEditor.printStatus("Press 'Delete' a second time to delete row.");
                this.lastButtonDelete = true;
            }
        }
    }

    public void refresh(Connection connection) {
        this.cConn = connection;
        if (this.vHoldForms == null) {
            this.initGUI();
        } else {
            this.resetTableForms();
        }
    }

    private void initGUI() {
        Vector vector = this.getAllTables();
        if (vector == null) {
            return;
        }
        this.vHoldTableNames = new Vector(20);
        this.vHoldForms = new Vector(20);
        this.setLayout(new BorderLayout(3, 3));
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout(3, 3));
        this.pForm = new Panel();
        this.lForm = new CardLayout(2, 2);
        this.pForm.setLayout(this.lForm);
        Panel panel2 = new Panel();
        panel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        panel2.add((Component)new Label("Search table"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.cTables = new Choice();
        Checkbox[] checkboxArray = vector.elements();
        while (checkboxArray.hasMoreElements()) {
            this.cTables.addItem((String)checkboxArray.nextElement());
        }
        gridBagConstraints.gridwidth = 2;
        panel2.add((Component)this.cTables, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        panel2.add((Component)new Label("Search words"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        this.fSearchWords = new TextField(8);
        panel2.add((Component)this.fSearchWords, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        panel2.add((Component)new Label("Use search words"), gridBagConstraints);
        this.gAllWords = new CheckboxGroup();
        checkboxArray = new Checkbox[2];
        checkboxArray[0] = new Checkbox("all", this.gAllWords, true);
        gridBagConstraints.gridx = 1;
        panel2.add((Component)checkboxArray[0], gridBagConstraints);
        checkboxArray[1] = new Checkbox("any ", this.gAllWords, false);
        gridBagConstraints.gridx = 2;
        panel2.add((Component)checkboxArray[1], gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 0;
        panel2.add((Component)new Label("Ignore case"), gridBagConstraints);
        this.gIgnoreCase = new CheckboxGroup();
        Checkbox[] checkboxArray2 = new Checkbox[2];
        checkboxArray2[0] = new Checkbox("yes", this.gIgnoreCase, true);
        gridBagConstraints.gridx = 1;
        panel2.add((Component)checkboxArray2[0], gridBagConstraints);
        checkboxArray2[1] = new Checkbox("no", this.gIgnoreCase, false);
        gridBagConstraints.gridx = 2;
        panel2.add((Component)checkboxArray2[1], gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridx = 0;
        panel2.add((Component)new Label("Match whole col"), gridBagConstraints);
        this.gNoMatchWhole = new CheckboxGroup();
        Checkbox[] checkboxArray3 = new Checkbox[2];
        checkboxArray3[0] = new Checkbox("no", this.gNoMatchWhole, true);
        gridBagConstraints.gridx = 1;
        panel2.add((Component)checkboxArray3[0], gridBagConstraints);
        checkboxArray3[1] = new Checkbox("yes ", this.gNoMatchWhole, false);
        gridBagConstraints.gridx = 2;
        panel2.add((Component)checkboxArray3[1], gridBagConstraints);
        this.pForm.add("search", panel2);
        panel.add("Center", this.pForm);
        this.initButtons();
        this.pButton = new Panel();
        this.lButton = new CardLayout(2, 2);
        this.pButton.setLayout(this.lButton);
        this.pButton.add("search", this.pSearchButs);
        this.pButton.add("edit", this.pEditButs);
        this.pButton.add("insert", this.pInsertButs);
        panel.add("South", this.pButton);
        this.add("Center", panel);
        Font font = new Font("Dialog", 0, 10);
        tStatus = new TextField("");
        tStatus.setEditable(false);
        this.add("South", tStatus);
    }

    private Vector getAllTables() {
        Vector<String> vector = new Vector<String>(20);
        try {
            if (this.cConn == null) {
                return null;
            }
            this.dbmeta = this.cConn.getMetaData();
            String[] stringArray = new String[]{"TABLE"};
            ResultSet resultSet = this.dbmeta.getTables(null, null, null, stringArray);
            while (resultSet.next()) {
                String string = resultSet.getString("TABLE_NAME");
                ResultSet resultSet2 = this.dbmeta.getPrimaryKeys(null, null, string);
                if (resultSet2.next()) {
                    vector.addElement(string);
                }
                resultSet2.close();
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return vector;
    }

    private int getChoosenTableIndex() {
        String string = this.cTables.getSelectedItem();
        int n = this.getTableIndex(string);
        if (n >= 0) {
            return n;
        }
        ZaurusTableForm zaurusTableForm = new ZaurusTableForm(string, this.cConn);
        this.pForm.add(string, zaurusTableForm);
        this.vHoldTableNames.addElement(string);
        this.vHoldForms.addElement(zaurusTableForm);
        return this.vHoldTableNames.size() - 1;
    }

    private int getTableIndex(String string) {
        for (int i = 0; i < this.vHoldTableNames.size(); ++i) {
            if (!string.equals((String)this.vHoldTableNames.elementAt(i))) continue;
            return i;
        }
        return -1;
    }

    private String[] getWords() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.fSearchWords.getText());
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    private void initButtons() {
        this.bSearchRow = new Button("Search Rows");
        this.bNewRow = new Button("Insert New Row");
        this.bSearchRow.addActionListener(this);
        this.bNewRow.addActionListener(this);
        this.pSearchButs = new Panel();
        this.pSearchButs.setLayout(new GridLayout(1, 0, 4, 4));
        this.pSearchButs.add(this.bSearchRow);
        this.pSearchButs.add(this.bNewRow);
        this.bCancel1 = new Button("Cancel");
        this.bPrev = new Button("Prev");
        this.bNext = new Button("Next");
        this.bDelete = new Button("Delete");
        this.lastButtonDelete = false;
        this.bNewSearch = new Button("Search");
        this.bCancel1.addActionListener(this);
        this.bPrev.addActionListener(this);
        this.bNext.addActionListener(this);
        this.bDelete.addActionListener(this);
        this.bNewSearch.addActionListener(this);
        this.pEditButs = new Panel();
        this.pEditButs.setLayout(new GridLayout(1, 0, 4, 4));
        this.pEditButs.add(this.bCancel1);
        this.pEditButs.add(this.bPrev);
        this.pEditButs.add(this.bNext);
        this.pEditButs.add(this.bDelete);
        this.pEditButs.add(this.bNewSearch);
        this.pInsertButs = new Panel();
        this.pInsertButs.setLayout(new GridLayout(1, 0, 4, 4));
        this.bCancel2 = new Button("Cancel Insert");
        this.bNewInsert = new Button("New Insert");
        this.bNewSearch1 = new Button("Search");
        this.bCancel2.addActionListener(this);
        this.bNewInsert.addActionListener(this);
        this.bNewSearch1.addActionListener(this);
        this.pInsertButs.add(this.bCancel2);
        this.pInsertButs.add(this.bNewInsert);
        this.pInsertButs.add(this.bNewSearch1);
    }

    private void resetLastButtonDelete() {
        if (this.lastButtonDelete) {
            ZaurusEditor.printStatus("");
            this.lastButtonDelete = false;
        }
    }

    private void resetTableForms() {
        this.lForm.show(this.pForm, "search");
        this.lButton.show(this.pButton, "search");
        Vector vector = this.getAllTables();
        this.cTables.removeAll();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.cTables.addItem((String)enumeration.nextElement());
        }
        enumeration = this.vHoldForms.elements();
        while (enumeration.hasMoreElements()) {
            this.pForm.remove((ZaurusTableForm)enumeration.nextElement());
        }
        this.vHoldTableNames = new Vector(20);
        this.vHoldForms = new Vector(20);
    }
}

