/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.output;

import java.awt.Image;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.layouting.input.style.parser.CSSValueFactory;
import org.jfree.layouting.input.style.parser.StyleSheetParserUtil;
import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.layouter.style.CSSValueResolverUtility;
import org.jfree.layouting.namespace.NamespaceDefinition;
import org.jfree.layouting.util.AttributeMap;
import org.jfree.layouting.util.LazyAttributeMap;
import org.jfree.report.DataFlags;
import org.jfree.report.DataSourceException;
import org.jfree.report.JFreeReportBoot;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.flow.AbstractReportTarget;
import org.jfree.report.flow.ReportJob;
import org.jfree.report.flow.ReportStructureRoot;
import org.jfree.report.flow.ReportTargetUtil;
import org.jfree.report.structure.Element;
import org.jfree.report.structure.Node;
import org.jfree.report.structure.Section;
import org.jfree.report.util.AttributeNameGenerator;
import org.jfree.report.util.IntegerCache;
import org.jfree.report.util.MemoryByteArrayOutputStream;
import org.libreoffice.report.DataSourceFactory;
import org.libreoffice.report.ImageService;
import org.libreoffice.report.InputRepository;
import org.libreoffice.report.OutputRepository;
import org.libreoffice.report.pentaho.layoutprocessor.ImageElementContext;
import org.libreoffice.report.pentaho.model.OfficeDocument;
import org.libreoffice.report.pentaho.model.OfficeStyle;
import org.libreoffice.report.pentaho.model.OfficeStyles;
import org.libreoffice.report.pentaho.model.OfficeStylesCollection;
import org.libreoffice.report.pentaho.output.ImageProducer;
import org.libreoffice.report.pentaho.output.OleProducer;
import org.libreoffice.report.pentaho.output.StyleUtilities;
import org.libreoffice.report.pentaho.output.StylesWriter;
import org.libreoffice.report.pentaho.styles.LengthCalculator;
import org.libreoffice.report.pentaho.styles.StyleMapper;
import org.pentaho.reporting.libraries.base.util.FastStack;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.DefaultTagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.TagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriterSupport;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public abstract class OfficeDocumentReportTarget
extends AbstractReportTarget {
    protected static final Log LOGGER = LogFactory.getLog(OfficeDocumentReportTarget.class);
    public static final String HORIZONTAL_POS = "horizontal-pos";
    public static final String TAG_DEF_PREFIX = "org.libreoffice.report.pentaho.output.";
    private static final int ROLE_NONE = 0;
    public static final int ROLE_REPORT_HEADER = 1;
    public static final int ROLE_REPORT_FOOTER = 2;
    public static final int ROLE_GROUP_HEADER = 3;
    public static final int ROLE_GROUP_FOOTER = 4;
    public static final int ROLE_REPEATING_GROUP_HEADER = 5;
    public static final int ROLE_REPEATING_GROUP_FOOTER = 6;
    public static final int ROLE_PAGE_HEADER = 7;
    public static final int ROLE_PAGE_FOOTER = 8;
    public static final int ROLE_DETAIL = 9;
    public static final int ROLE_VARIABLES = 10;
    public static final int ROLE_TEMPLATE = 11;
    public static final int ROLE_SPREADSHEET_PAGE_HEADER = 12;
    public static final int ROLE_SPREADSHEET_PAGE_FOOTER = 13;
    private static final int STATE_IN_DOCUMENT = 0;
    private static final int STATE_IN_BODY = 1;
    private static final int STATE_IN_CONTENT = 2;
    private static final int STATE_IN_GROUP = 3;
    private static final int STATE_IN_GROUP_BODY = 4;
    private static final int STATE_IN_SECTION = 5;
    private static final int STATE_IN_OTHER = 6;
    private static final int STATE_IN_GROUP_INSTANCE = 7;
    public static final String FAILED = "Failed";
    public static final String VERTICAL_POS = "vertical-pos";
    private static final String ZERO_CM = "0cm";
    public static final String ODF_VERSION = "1.2";
    private final FastStack states;
    private int currentRole;
    private final FastStack xmlWriters;
    private XmlWriter rootXmlWriter;
    private OfficeStylesCollection predefinedStylesCollection;
    private OfficeStylesCollection globalStylesCollection;
    private OfficeStylesCollection contentStylesCollection;
    private final OutputRepository outputRepository;
    private final InputRepository inputRepository;
    private final AttributeNameGenerator tableNameGenerator;
    private final AttributeNameGenerator frameNameGenerator;
    private final AttributeNameGenerator autoStyleNameGenerator;
    private final String target;
    private static final int INITIAL_BUFFER_SIZE = 40960;
    private StyleMapper styleMapper;
    private StyleSheetParserUtil styleSheetParserUtil;
    private final AttributeNameGenerator imageNames;
    private final ImageProducer imageProducer;
    private final OleProducer oleProducer;
    private GroupContext groupContext;
    private static final boolean DEBUG_ELEMENTS = JFreeReportBoot.getInstance().getExtendedConfig().getBoolProperty("org.libreoffice.report.pentaho.output.DebugElements");

    protected OfficeDocumentReportTarget(ReportJob reportJob, ResourceManager resourceManager, ResourceKey resourceKey, InputRepository inputRepository, OutputRepository outputRepository, String string, ImageService imageService, DataSourceFactory dataSourceFactory) throws ReportProcessingException {
        super(reportJob, resourceManager, resourceKey);
        if (imageService == null) {
            throw new NullPointerException("ImageService must not be null");
        }
        if (string == null) {
            throw new NullPointerException("Target-Name must not be null");
        }
        this.target = string;
        this.tableNameGenerator = new AttributeNameGenerator();
        this.frameNameGenerator = new AttributeNameGenerator();
        this.autoStyleNameGenerator = new AttributeNameGenerator();
        this.outputRepository = outputRepository;
        this.inputRepository = inputRepository;
        this.states = new FastStack();
        this.xmlWriters = new FastStack();
        this.imageNames = new AttributeNameGenerator();
        this.imageProducer = new ImageProducer(inputRepository, outputRepository, imageService);
        this.oleProducer = new OleProducer(inputRepository, outputRepository, imageService, dataSourceFactory, (Integer)reportJob.getParameters().get("MaxRows"));
        try {
            ResourceManager resourceManager2 = this.getResourceManager();
            this.styleMapper = StyleMapper.loadInstance(resourceManager2);
        }
        catch (ResourceException resourceException) {
            throw new ReportProcessingException("Failed to load style-mapper", (Exception)((Object)resourceException));
        }
    }

    protected abstract String getTargetMimeType();

    protected OutputRepository getOutputRepository() {
        return this.outputRepository;
    }

    private InputRepository getInputRepository() {
        return this.inputRepository;
    }

    public void startReport(ReportStructureRoot reportStructureRoot) throws DataSourceException, ReportProcessingException {
        this.imageNames.reset();
        this.groupContext = new GroupContext(null);
        DefaultTagDescription defaultTagDescription = this.createTagDescription();
        try {
            OutputStream outputStream = this.outputRepository.createOutputStream(this.target, "text/xml");
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
            this.rootXmlWriter = new XmlWriter((Writer)outputStreamWriter, (TagDescription)defaultTagDescription);
            this.rootXmlWriter.setAlwaysAddNamespace(true);
            AttributeList attributeList = new AttributeList();
            attributeList.addNamespaceDeclaration("office", "urn:oasis:names:tc:opendocument:xmlns:office:1.0");
            attributeList.addNamespaceDeclaration("style", "urn:oasis:names:tc:opendocument:xmlns:style:1.0");
            attributeList.addNamespaceDeclaration("text", "urn:oasis:names:tc:opendocument:xmlns:text:1.0");
            attributeList.addNamespaceDeclaration("table", "urn:oasis:names:tc:opendocument:xmlns:table:1.0");
            attributeList.addNamespaceDeclaration("draw", "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0");
            attributeList.addNamespaceDeclaration("fo", "urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0");
            attributeList.addNamespaceDeclaration("xlink", "http://www.w3.org/1999/xlink");
            attributeList.addNamespaceDeclaration("dc", "http://purl.org/dc/elements/1.1/");
            attributeList.addNamespaceDeclaration("meta", "urn:oasis:names:tc:opendocument:xmlns:meta:1.0");
            attributeList.addNamespaceDeclaration("number", "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0");
            attributeList.addNamespaceDeclaration("svg", "urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0");
            attributeList.addNamespaceDeclaration("chart", "urn:oasis:names:tc:opendocument:xmlns:chart:1.0");
            attributeList.addNamespaceDeclaration("chartooo", "http://openoffice.org/2010/chart");
            attributeList.addNamespaceDeclaration("dr3d", "urn:oasis:names:tc:opendocument:xmlns:dr3d:1.0");
            attributeList.addNamespaceDeclaration("math", "http://www.w3.org/1998/Math/MathML");
            attributeList.addNamespaceDeclaration("form", "urn:oasis:names:tc:opendocument:xmlns:form:1.0");
            attributeList.addNamespaceDeclaration("script", "urn:oasis:names:tc:opendocument:xmlns:script:1.0");
            attributeList.addNamespaceDeclaration("ooo", "http://openoffice.org/2004/office");
            attributeList.addNamespaceDeclaration("ooow", "http://openoffice.org/2004/writer");
            attributeList.addNamespaceDeclaration("oooc", "http://openoffice.org/2004/calc");
            attributeList.addNamespaceDeclaration("dom", "http://www.w3.org/2001/xml-events");
            attributeList.addNamespaceDeclaration("xforms", "http://www.w3.org/2002/xforms");
            attributeList.addNamespaceDeclaration("xsd", "http://www.w3.org/2001/XMLSchema");
            attributeList.addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            attributeList.addNamespaceDeclaration("grddl", "http://www.w3.org/2003/g/data-view#");
            attributeList.addNamespaceDeclaration("loext", "urn:org:documentfoundation:names:experimental:office:xmlns:loext:1.0");
            attributeList.setAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "version", ODF_VERSION);
            this.rootXmlWriter.writeXmlDeclaration("UTF-8");
            this.rootXmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "document-content", attributeList, false);
            this.states.push((Object)IntegerCache.getInteger((int)0));
            this.autoStyleNameGenerator.reset();
            this.tableNameGenerator.reset();
            this.frameNameGenerator.reset();
            OfficeDocument officeDocument = (OfficeDocument)reportStructureRoot;
            this.predefinedStylesCollection = officeDocument.getStylesCollection();
            OfficeStyles officeStyles = this.predefinedStylesCollection.getCommonStyles();
            if (!officeStyles.containsStyle("graphic", "Graphics")) {
                OfficeStyle officeStyle = new OfficeStyle();
                officeStyle.setStyleFamily("graphic");
                officeStyle.setStyleName("Graphics");
                Element element = this.produceFirstChild(officeStyle, "urn:oasis:names:tc:opendocument:xmlns:style:1.0", "graphic-properties");
                element.setAttribute("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "anchor-type", (Object)"paragraph");
                element.setAttribute("urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0", "x", (Object)ZERO_CM);
                element.setAttribute("urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0", "y", (Object)ZERO_CM);
                element.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "wrap", (Object)"dynamic");
                element.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "number-wrapped-paragraphs", (Object)"no-limit");
                element.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "wrap-contour", (Object)"false");
                element.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", VERTICAL_POS, (Object)"from-top");
                element.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "vertical-rel", (Object)"paragraph");
                element.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", HORIZONTAL_POS, (Object)"from-left");
                element.setAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "horizontal-rel", (Object)"paragraph");
                officeStyles.addStyle(officeStyle);
            }
            this.fillStyleNameGenerator(this.predefinedStylesCollection);
            this.contentStylesCollection = new OfficeStylesCollection();
            this.globalStylesCollection = new OfficeStylesCollection();
            this.startBuffering(this.contentStylesCollection, true);
        }
        catch (IOException iOException) {
            throw new ReportProcessingException(FAILED, (Exception)iOException);
        }
    }

    protected AttributeNameGenerator getAutoStyleNameGenerator() {
        return this.autoStyleNameGenerator;
    }

    private void fillStyleNameGenerator(OfficeStylesCollection officeStylesCollection) {
        OfficeStyle[] officeStyleArray;
        OfficeStyles officeStyles = officeStylesCollection.getCommonStyles();
        OfficeStyle[] officeStyleArray2 = officeStyles.getAllStyles();
        for (int i = 0; i < officeStyleArray2.length; ++i) {
            officeStyleArray = officeStyleArray2[i];
            this.autoStyleNameGenerator.generateName(officeStyleArray.getStyleName());
        }
        OfficeStyles officeStyles2 = officeStylesCollection.getAutomaticStyles();
        officeStyleArray = officeStyles2.getAllStyles();
        for (int i = 0; i < officeStyleArray.length; ++i) {
            OfficeStyle officeStyle = officeStyleArray[i];
            this.autoStyleNameGenerator.generateName(officeStyle.getStyleName());
        }
    }

    public OfficeStylesCollection getPredefinedStylesCollection() {
        return this.predefinedStylesCollection;
    }

    public OfficeStylesCollection getGlobalStylesCollection() {
        return this.globalStylesCollection;
    }

    public OfficeStylesCollection getContentStylesCollection() {
        return this.contentStylesCollection;
    }

    protected DefaultTagDescription createTagDescription() {
        DefaultTagDescription defaultTagDescription = new DefaultTagDescription();
        defaultTagDescription.configure(JFreeReportBoot.getInstance().getGlobalConfig(), TAG_DEF_PREFIX);
        return defaultTagDescription;
    }

    private int getCurrentState() {
        if (this.states.isEmpty()) {
            throw new IllegalStateException();
        }
        Integer n = (Integer)this.states.peek();
        return n;
    }

    public final void startElement(AttributeMap attributeMap) throws DataSourceException, ReportProcessingException {
        LazyAttributeMap lazyAttributeMap = new LazyAttributeMap(attributeMap);
        if (DEBUG_ELEMENTS) {
            LOGGER.debug((Object)("Starting " + this.getCurrentState() + '/' + this.states.size() + ' ' + ReportTargetUtil.getNamespaceFromAttribute((AttributeMap)lazyAttributeMap) + " -> " + ReportTargetUtil.getElemenTypeFromAttribute((AttributeMap)lazyAttributeMap)));
        }
        try {
            switch (this.getCurrentState()) {
                case 0: {
                    if (ReportTargetUtil.isElementOfType((String)"urn:oasis:names:tc:opendocument:xmlns:office:1.0", (String)"body", (AttributeMap)lazyAttributeMap)) {
                        this.states.push((Object)IntegerCache.getInteger((int)1));
                        this.startBody();
                        break;
                    }
                    this.states.push((Object)IntegerCache.getInteger((int)6));
                    if (!this.isFilteredNamespace(ReportTargetUtil.getNamespaceFromAttribute((AttributeMap)lazyAttributeMap))) {
                        this.startOther((AttributeMap)lazyAttributeMap);
                    }
                    break;
                }
                case 1: {
                    if (ReportTargetUtil.isElementOfType((String)"urn:oasis:names:tc:opendocument:xmlns:office:1.0", (String)"report", (AttributeMap)lazyAttributeMap)) {
                        this.states.push((Object)IntegerCache.getInteger((int)2));
                        this.startContent((AttributeMap)lazyAttributeMap);
                        break;
                    }
                    throw new IllegalStateException("The 'office:body' element must have exactly one child of type 'report'");
                }
                case 2: {
                    if (ReportTargetUtil.isElementOfType((String)"http://jfreereport.sourceforge.net/namespaces/engine", (String)"report-body", (AttributeMap)lazyAttributeMap)) {
                        this.states.push((Object)IntegerCache.getInteger((int)4));
                        break;
                    }
                    this.states.push((Object)IntegerCache.getInteger((int)5));
                    if (ReportTargetUtil.isElementOfType((String)"http://jfreereport.sourceforge.net/namespaces/engine", (String)"template", (AttributeMap)lazyAttributeMap)) {
                        this.currentRole = 11;
                    } else if (ReportTargetUtil.isElementOfType((String)"http://openoffice.org/2005/report", (String)"page-header", (AttributeMap)lazyAttributeMap)) {
                        this.currentRole = "spreadsheet-section".equals(lazyAttributeMap.getAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "role")) ? 12 : 7;
                    } else if (ReportTargetUtil.isElementOfType((String)"http://openoffice.org/2005/report", (String)"page-footer", (AttributeMap)lazyAttributeMap)) {
                        this.currentRole = "spreadsheet-section".equals(lazyAttributeMap.getAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "role")) ? 13 : 8;
                    } else if (ReportTargetUtil.isElementOfType((String)"http://openoffice.org/2005/report", (String)"report-header", (AttributeMap)lazyAttributeMap)) {
                        this.currentRole = 1;
                    } else if (ReportTargetUtil.isElementOfType((String)"http://openoffice.org/2005/report", (String)"report-footer", (AttributeMap)lazyAttributeMap)) {
                        this.currentRole = 2;
                    } else if (ReportTargetUtil.isElementOfType((String)"http://jfreereport.sourceforge.net/namespaces/engine", (String)"variables-section", (AttributeMap)lazyAttributeMap)) {
                        this.currentRole = 10;
                    } else {
                        throw new IllegalStateException("Expected either 'template', 'report-body', 'report-header', 'report-footer', 'variables-section', 'page-header' or 'page-footer'");
                    }
                    this.startReportSection((AttributeMap)lazyAttributeMap, this.currentRole);
                    break;
                }
                case 4: {
                    if (ReportTargetUtil.isElementOfType((String)"http://openoffice.org/2005/report", (String)"group", (AttributeMap)lazyAttributeMap)) {
                        this.states.push((Object)IntegerCache.getInteger((int)3));
                        this.groupContext = new GroupContext(this.groupContext);
                        this.startGroup((AttributeMap)lazyAttributeMap);
                        break;
                    }
                    this.states.push((Object)IntegerCache.getInteger((int)5));
                    if (ReportTargetUtil.isElementOfType((String)"http://openoffice.org/2005/report", (String)"detail", (AttributeMap)lazyAttributeMap)) {
                        this.currentRole = 9;
                    } else if (ReportTargetUtil.isElementOfType((String)"http://jfreereport.sourceforge.net/namespaces/engine", (String)"variables-section", (AttributeMap)lazyAttributeMap)) {
                        this.currentRole = 10;
                    } else {
                        throw new IllegalStateException("Expected either 'group', 'detail' or 'variables-section'");
                    }
                    this.startReportSection((AttributeMap)lazyAttributeMap, this.currentRole);
                    break;
                }
                case 3: {
                    if (ReportTargetUtil.isElementOfType((String)"http://jfreereport.sourceforge.net/namespaces/engine", (String)"group-instance", (AttributeMap)lazyAttributeMap)) {
                        this.states.push((Object)IntegerCache.getInteger((int)7));
                        this.startGroupInstance((AttributeMap)lazyAttributeMap);
                        break;
                    }
                    this.states.push((Object)IntegerCache.getInteger((int)5));
                    if (ReportTargetUtil.isElementOfType((String)"http://openoffice.org/2005/report", (String)"group-header", (AttributeMap)lazyAttributeMap) && "true".equals(lazyAttributeMap.getAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "repeated-section"))) {
                        this.currentRole = 5;
                    } else if (ReportTargetUtil.isElementOfType((String)"http://openoffice.org/2005/report", (String)"group-footer", (AttributeMap)lazyAttributeMap) && "true".equals(lazyAttributeMap.getAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "repeated-section"))) {
                        this.currentRole = 6;
                    } else {
                        throw new IllegalStateException("Expected either 'group-instance', 'repeating group-header' or 'repeating group-footer'");
                    }
                    this.startReportSection((AttributeMap)lazyAttributeMap, this.currentRole);
                    break;
                }
                case 7: {
                    if (ReportTargetUtil.isElementOfType((String)"http://jfreereport.sourceforge.net/namespaces/engine", (String)"group-body", (AttributeMap)lazyAttributeMap)) {
                        this.states.push((Object)IntegerCache.getInteger((int)4));
                        break;
                    }
                    this.states.push((Object)IntegerCache.getInteger((int)5));
                    if (ReportTargetUtil.isElementOfType((String)"http://openoffice.org/2005/report", (String)"group-header", (AttributeMap)lazyAttributeMap)) {
                        this.currentRole = 3;
                    } else if (ReportTargetUtil.isElementOfType((String)"http://openoffice.org/2005/report", (String)"group-footer", (AttributeMap)lazyAttributeMap)) {
                        this.currentRole = 4;
                    } else if (ReportTargetUtil.isElementOfType((String)"http://jfreereport.sourceforge.net/namespaces/engine", (String)"variables-section", (AttributeMap)lazyAttributeMap)) {
                        this.currentRole = 10;
                    } else {
                        throw new IllegalStateException("Expected either 'group-body', 'group-header', 'group-footer' or 'variables-section'");
                    }
                    this.startReportSection((AttributeMap)lazyAttributeMap, this.currentRole);
                    break;
                }
                case 5: 
                case 6: {
                    this.states.push((Object)IntegerCache.getInteger((int)6));
                    this.startOther((AttributeMap)lazyAttributeMap);
                    break;
                }
                default: {
                    throw new IllegalStateException("Failure: " + this.getCurrentState());
                }
            }
        }
        catch (IOException iOException) {
            LOGGER.error((Object)"ReportProcessing failed", (Throwable)iOException);
            throw new ReportProcessingException("Failed to write content", (Exception)iOException);
        }
    }

    protected GroupContext getGroupContext() {
        return this.groupContext;
    }

    protected void performStyleProcessing(AttributeMap attributeMap) throws ReportProcessingException {
        OfficeStylesCollection officeStylesCollection = this.getStylesCollection();
        OfficeStylesCollection officeStylesCollection2 = this.getPredefinedStylesCollection();
        OfficeStylesCollection officeStylesCollection3 = this.getGlobalStylesCollection();
        String string = ReportTargetUtil.getNamespaceFromAttribute((AttributeMap)attributeMap);
        String string2 = ReportTargetUtil.getElemenTypeFromAttribute((AttributeMap)attributeMap);
        String[] stringArray = attributeMap.getNameSpaces();
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            if (this.isFilteredNamespace(string3)) continue;
            Map map = attributeMap.getAttributes(string3);
            for (Map.Entry entry : map.entrySet()) {
                String string4 = (String)entry.getKey();
                String string5 = String.valueOf(entry.getValue());
                String string6 = this.styleMapper.getStyleFamilyFor(string, string2, string3, string4);
                if (string6 == null) continue;
                if (this.styleMapper.isListOfStyles(string, string2, string3, string4)) {
                    LOGGER.warn((Object)"List of styles is not yet implemented.");
                    continue;
                }
                StyleUtilities.copyStyle(string6, string5, officeStylesCollection, officeStylesCollection3, officeStylesCollection2);
            }
        }
    }

    private void startBody() throws IOException {
        this.getXmlWriter().writeTag("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "body", false);
    }

    private final boolean allowBuffering(int n) {
        return n == 6 || n == 5 || n == 11;
    }

    protected void startReportSection(AttributeMap attributeMap, int n) throws ReportProcessingException {
        if (this.allowBuffering(n)) {
            this.startBuffering(new OfficeStylesCollection(), true);
        }
    }

    protected abstract void startContent(AttributeMap var1) throws IOException, DataSourceException, ReportProcessingException;

    protected void startGroup(AttributeMap attributeMap) {
        Object object;
        Object object2 = attributeMap.getAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "repeating-header-or-footer");
        if ("true".equals(object2)) {
            this.getGroupContext().setGroupWithRepeatingSection(true);
        }
        if ((object = attributeMap.getAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "iteration-count")) instanceof Number) {
            Number number = (Number)object;
            this.getGroupContext().setIterationCount(number.intValue());
        }
    }

    protected void startGroupInstance(AttributeMap attributeMap) {
    }

    protected abstract void startOther(AttributeMap var1) throws IOException, DataSourceException, ReportProcessingException;

    public void processText(String string) throws DataSourceException, ReportProcessingException {
        try {
            XmlWriter xmlWriter = this.getXmlWriter();
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                xmlWriter.writeTextNormalized(string2, false);
                string2 = bufferedReader.readLine();
                if (string2 == null) continue;
                xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "line-break", true);
            }
        }
        catch (IOException iOException) {
            throw new ReportProcessingException(FAILED, (Exception)iOException);
        }
    }

    protected boolean isFilteredNamespace(String string) {
        if ("http://jfreereport.sourceforge.net/namespaces/layout".equals(string)) {
            return true;
        }
        if ("http://jfreereport.sourceforge.net/namespaces/engine".equals(string)) {
            return true;
        }
        if ("http://jfreereport.sourceforge.net/namespaces/engine".equals(string)) {
            return true;
        }
        if ("http://jfreereport.sourceforge.net/namespaces/engine/compatibility".equals(string)) {
            return true;
        }
        return "http://openoffice.org/2005/report".equals(string);
    }

    public void processContent(DataFlags dataFlags) throws DataSourceException, ReportProcessingException {
        Object object = dataFlags.getValue();
        if (object == null) {
            return;
        }
        if (object instanceof Image) {
            return;
        }
        XmlWriter xmlWriter = this.getXmlWriter();
        String string = String.valueOf(object);
        try {
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                xmlWriter.writeTextNormalized(string2, false);
                string2 = bufferedReader.readLine();
                if (string2 == null) continue;
                xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "line-break", true);
            }
        }
        catch (IOException iOException) {
            throw new ReportProcessingException(FAILED, (Exception)iOException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void endElement(AttributeMap attributeMap) throws DataSourceException, ReportProcessingException {
        LazyAttributeMap lazyAttributeMap = new LazyAttributeMap(attributeMap);
        try {
            switch (this.getCurrentState()) {
                case 6: {
                    this.endOther((AttributeMap)lazyAttributeMap);
                    return;
                }
                case 5: {
                    this.endReportSection((AttributeMap)lazyAttributeMap, this.currentRole);
                    this.currentRole = 0;
                    return;
                }
                case 3: {
                    this.endGroup((AttributeMap)lazyAttributeMap);
                    this.groupContext = this.groupContext.getParent();
                    return;
                }
                case 7: {
                    return;
                }
                case 4: {
                    this.endGroupBody((AttributeMap)lazyAttributeMap);
                    return;
                }
                case 2: {
                    this.endContent((AttributeMap)lazyAttributeMap);
                    return;
                }
                case 1: {
                    this.endBody();
                    return;
                }
                case 0: {
                    throw new IllegalStateException("This cannot be.");
                }
                default: {
                    throw new IllegalStateException("Invalid state encountered.");
                }
            }
        }
        catch (IOException iOException) {
            throw new ReportProcessingException("IO Error while writing content", (Exception)iOException);
        }
        finally {
            this.states.pop();
            if (DEBUG_ELEMENTS) {
                LOGGER.debug((Object)("Finished " + this.getCurrentState() + "/" + this.states.size() + " " + ReportTargetUtil.getNamespaceFromAttribute((AttributeMap)lazyAttributeMap) + ":" + ReportTargetUtil.getElemenTypeFromAttribute((AttributeMap)lazyAttributeMap)));
            }
        }
    }

    protected void endGroupBody(AttributeMap attributeMap) throws IOException {
    }

    public int getCurrentRole() {
        return this.currentRole;
    }

    protected abstract void endOther(AttributeMap var1) throws IOException, DataSourceException, ReportProcessingException;

    protected void endReportSection(AttributeMap attributeMap, int n) throws IOException, ReportProcessingException {
        if (this.allowBuffering(n)) {
            this.finishBuffering();
        }
    }

    protected void endGroup(AttributeMap attributeMap) throws ReportProcessingException {
    }

    protected abstract void endContent(AttributeMap var1) throws IOException, DataSourceException, ReportProcessingException;

    private void endBody() throws IOException {
        this.getXmlWriter().writeCloseTag();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyMeta() {
        if (this.getInputRepository().isReadable("meta.xml")) {
            InputStream inputStream = null;
            try {
                inputStream = this.getInputRepository().createInputStream("meta.xml");
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(new InputSource(inputStream));
                org.w3c.dom.Node node = document.getFirstChild().getFirstChild().getFirstChild().getFirstChild();
                String string = node.getNodeValue();
                node.setNodeValue(string + "/report_builder");
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("method", "xml");
                OutputStream outputStream = this.getOutputRepository().createOutputStream("meta.xml", "text/xml");
                StreamResult streamResult = new StreamResult(outputStream);
                DOMSource dOMSource = new DOMSource(document);
                transformer.transform(dOMSource, streamResult);
                outputStream.flush();
                outputStream.close();
            }
            catch (Exception exception) {
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        Logger.getLogger(OfficeDocumentReportTarget.class.getName()).log(Level.SEVERE, null, iOException);
                    }
                }
            }
        }
    }

    public void endReport(ReportStructureRoot reportStructureRoot) throws DataSourceException, ReportProcessingException {
        if (this.xmlWriters.size() != 1) {
            throw new IllegalStateException("Invalid writer-stack state");
        }
        try {
            StylesWriter stylesWriter = new StylesWriter(this.rootXmlWriter);
            stylesWriter.writeContentStyles(this.contentStylesCollection);
            BufferState bufferState = this.finishBuffering();
            this.rootXmlWriter.writeStream(bufferState.getXmlAsReader());
            OutputStream outputStream = this.outputRepository.createOutputStream("styles.xml", "text/xml");
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
            StylesWriter stylesWriter2 = new StylesWriter(outputStreamWriter);
            stylesWriter2.writeGlobalStyles(this.globalStylesCollection);
            stylesWriter2.close();
            this.rootXmlWriter.writeCloseTag();
            this.rootXmlWriter.close();
        }
        catch (IOException iOException) {
            throw new ReportProcessingException(FAILED, (Exception)iOException);
        }
    }

    public XmlWriter getXmlWriter() {
        BufferState bufferState = (BufferState)this.xmlWriters.peek();
        return bufferState.getXmlWriter();
    }

    public OfficeStylesCollection getStylesCollection() {
        BufferState bufferState = (BufferState)this.xmlWriters.peek();
        return bufferState.getStylesCollection();
    }

    public void startBuffering(OfficeStylesCollection officeStylesCollection, boolean bl) throws ReportProcessingException {
        BufferState bufferState;
        XmlWriter xmlWriter;
        if (this.xmlWriters.isEmpty()) {
            xmlWriter = this.rootXmlWriter;
        } else {
            bufferState = (BufferState)this.xmlWriters.peek();
            xmlWriter = bufferState.getXmlWriter();
        }
        try {
            bufferState = new MemoryByteArrayOutputStream(40960, 0xA00000);
            DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)((Object)bufferState));
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)deflaterOutputStream, "UTF-16");
            XmlWriter xmlWriter2 = new XmlWriter((Writer)outputStreamWriter, (TagDescription)this.createTagDescription());
            xmlWriter2.copyNamespaces((XmlWriterSupport)xmlWriter);
            if (bl) {
                xmlWriter2.setAdditionalIndent(xmlWriter.getCurrentIndentLevel());
                xmlWriter2.setWriteFinalLinebreak(true);
            } else {
                xmlWriter2.setWriteFinalLinebreak(false);
            }
            xmlWriter2.setAlwaysAddNamespace(true);
            this.xmlWriters.push((Object)new BufferState(xmlWriter2, (MemoryByteArrayOutputStream)bufferState, officeStylesCollection));
        }
        catch (IOException iOException) {
            throw new ReportProcessingException("Unable to create the buffer", (Exception)iOException);
        }
    }

    public BufferState finishBuffering() {
        BufferState bufferState = (BufferState)this.xmlWriters.pop();
        try {
            bufferState.getXmlWriter().close();
        }
        catch (IOException iOException) {
            LOGGER.error((Object)"ReportProcessing failed", (Throwable)iOException);
        }
        return bufferState;
    }

    public void commit() throws ReportProcessingException {
    }

    public NamespaceDefinition getNamespaceByUri(String string) {
        return null;
    }

    protected AttributeList buildAttributeList(AttributeMap attributeMap) {
        String string = ReportTargetUtil.getElemenTypeFromAttribute((AttributeMap)attributeMap);
        AttributeList attributeList = new AttributeList();
        String[] stringArray = attributeMap.getNameSpaces();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (this.isFilteredNamespace(string2)) continue;
            Map map = attributeMap.getAttributes(string2);
            for (Map.Entry entry : map.entrySet()) {
                String string3;
                String string4 = String.valueOf(entry.getKey());
                if ("urn:oasis:names:tc:opendocument:xmlns:table:1.0".equals(string2) && "name".equals(string4)) {
                    string3 = String.valueOf(entry.getValue());
                    String string5 = this.sanitizeName(string3);
                    attributeList.setAttribute(string2, string4, this.tableNameGenerator.generateName(string5));
                    continue;
                }
                if ("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0".equals(string2) && "name".equals(string4) && !"equation".equals(string)) {
                    string3 = String.valueOf(entry.getValue());
                    attributeList.setAttribute(string2, string4, this.frameNameGenerator.generateName(string3));
                    continue;
                }
                attributeList.setAttribute(string2, string4, String.valueOf(entry.getValue()));
            }
        }
        return attributeList;
    }

    private String sanitizeName(String string) {
        if (string == null) {
            return "";
        }
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (Character.isWhitespace(c)) {
                stringBuffer.append('_');
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    protected CSSNumericValue parseLength(String string) {
        LexicalUnit lexicalUnit;
        if (this.styleSheetParserUtil == null) {
            this.styleSheetParserUtil = StyleSheetParserUtil.getInstance();
        }
        if ((lexicalUnit = this.styleSheetParserUtil.parseLexicalStyleValue(string)) == null) {
            CSSNumericValue cSSNumericValue = CSSNumericValue.createValue((CSSNumericType)CSSNumericType.CM, (double)0.0);
            return cSSNumericValue;
        }
        return CSSValueFactory.createLengthValue((LexicalUnit)lexicalUnit);
    }

    protected boolean isRepeatingSection() {
        return this.currentRole == 6 || this.currentRole == 5 || this.currentRole == 8 || this.currentRole == 7 || this.currentRole == 10;
    }

    protected OfficeStyle deriveStyle(String string, String string2) throws ReportProcessingException {
        OfficeStyle officeStyle = StyleUtilities.deriveStyle(string, string2, this.getStylesCollection(), this.getGlobalStylesCollection(), this.getPredefinedStylesCollection(), this.getAutoStyleNameGenerator());
        return officeStyle;
    }

    protected void startImageProcessing(AttributeMap attributeMap) throws ReportProcessingException {
        boolean bl;
        Object object = attributeMap.getAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "image-data");
        ImageProducer.OfficeImage officeImage = this.imageProducer.produceImage(object, bl = "true".equals(attributeMap.getAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "preserve-IRI")));
        if (officeImage != null) {
            CSSNumericValue cSSNumericValue;
            AttributeList attributeList;
            CSSNumericValue cSSNumericValue2;
            CSSNumericValue cSSNumericValue3;
            ImageElementContext imageElementContext = (ImageElementContext)attributeMap.getAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "image-context");
            CSSNumericValue cSSNumericValue4 = officeImage.getWidth();
            CSSNumericValue cSSNumericValue5 = officeImage.getHeight();
            LOGGER.debug((Object)("Image " + object + " Width: " + cSSNumericValue4 + ", Height: " + cSSNumericValue5));
            if (cSSNumericValue4 == null || cSSNumericValue5 == null) {
                return;
            }
            CSSNumericValue cSSNumericValue6 = CSSNumericValue.createValue((CSSNumericType)CSSNumericType.CM, (double)0.0);
            CSSNumericValue cSSNumericValue7 = CSSNumericValue.createValue((CSSNumericType)CSSNumericType.CM, (double)0.0);
            String string = null;
            if (imageElementContext != null) {
                cSSNumericValue3 = this.computeImageWidth(imageElementContext);
                cSSNumericValue2 = this.computeImageHeight(imageElementContext);
                if (cSSNumericValue3 == null || cSSNumericValue2 == null) {
                    LOGGER.debug((Object)"Image data returned from context is invalid. Maybe this is not an image?");
                    return;
                }
                attributeList = CSSValueResolverUtility.convertLength((CSSNumericValue)cSSNumericValue4, (CSSNumericType)cSSNumericValue3.getType());
                cSSNumericValue = CSSValueResolverUtility.convertLength((CSSNumericValue)cSSNumericValue5, (CSSNumericType)cSSNumericValue2.getType());
                String string2 = (String)attributeMap.getAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "scale");
                if ("none".equals(string2) && attributeList.getValue() > 0.0 && cSSNumericValue.getValue() > 0.0) {
                    double d = attributeList.getValue() - cSSNumericValue3.getValue();
                    double d2 = cSSNumericValue.getValue() - cSSNumericValue2.getValue();
                    if (d > 0.0 && d2 > 0.0) {
                        OfficeStyle officeStyle = this.deriveStyle("graphic", "Graphics");
                        Element element = this.produceFirstChild(officeStyle, "urn:oasis:names:tc:opendocument:xmlns:style:1.0", "graphic-properties");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("rect(");
                        stringBuffer.append(d2 / 2.0);
                        stringBuffer.append(cSSNumericValue2.getType().getType());
                        stringBuffer.append(' ');
                        stringBuffer.append(d / 2.0);
                        stringBuffer.append(cSSNumericValue3.getType().getType());
                        stringBuffer.append(' ');
                        stringBuffer.append(d2 / 2.0);
                        stringBuffer.append(cSSNumericValue2.getType().getType());
                        stringBuffer.append(' ');
                        stringBuffer.append(d / 2.0);
                        stringBuffer.append(cSSNumericValue3.getType().getType());
                        stringBuffer.append(')');
                        element.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "clip", (Object)stringBuffer.toString());
                        string = officeStyle.getStyleName();
                        this.getStylesCollection().getAutomaticStyles().addStyle(officeStyle);
                    } else if (d > 0.0) {
                        OfficeStyle officeStyle = this.deriveStyle("graphic", "Graphics");
                        Element element = this.produceFirstChild(officeStyle, "urn:oasis:names:tc:opendocument:xmlns:style:1.0", "graphic-properties");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("rect(0cm ");
                        stringBuffer.append(d / 2.0);
                        stringBuffer.append(cSSNumericValue3.getType().getType());
                        stringBuffer.append(" 0cm ");
                        stringBuffer.append(d / 2.0);
                        stringBuffer.append(cSSNumericValue3.getType().getType());
                        stringBuffer.append(')');
                        element.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "clip", (Object)stringBuffer.toString());
                        string = officeStyle.getStyleName();
                        this.getStylesCollection().getAutomaticStyles().addStyle(officeStyle);
                        cSSNumericValue2 = cSSNumericValue;
                    } else if (d2 > 0.0) {
                        OfficeStyle officeStyle = this.deriveStyle("graphic", "Graphics");
                        Element element = this.produceFirstChild(officeStyle, "urn:oasis:names:tc:opendocument:xmlns:style:1.0", "graphic-properties");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("rect(");
                        stringBuffer.append(d2 / 2.0);
                        stringBuffer.append(cSSNumericValue2.getType().getType());
                        stringBuffer.append(" 0cm ");
                        stringBuffer.append(d2 / 2.0);
                        stringBuffer.append(cSSNumericValue2.getType().getType());
                        stringBuffer.append(" 0cm)");
                        element.setAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "clip", (Object)stringBuffer.toString());
                        string = officeStyle.getStyleName();
                        this.getStylesCollection().getAutomaticStyles().addStyle(officeStyle);
                        cSSNumericValue3 = attributeList;
                    } else {
                        cSSNumericValue3 = attributeList;
                        cSSNumericValue2 = cSSNumericValue;
                    }
                } else if ("isotropic".equals(string2)) {
                    double[] dArray = OfficeDocumentReportTarget.calcPaintSize(cSSNumericValue3, cSSNumericValue2, (CSSNumericValue)attributeList, cSSNumericValue);
                    cSSNumericValue6 = CSSNumericValue.createValue((CSSNumericType)cSSNumericValue3.getType(), (double)((cSSNumericValue3.getValue() - dArray[0]) * 0.5));
                    cSSNumericValue7 = CSSNumericValue.createValue((CSSNumericType)cSSNumericValue2.getType(), (double)((cSSNumericValue2.getValue() - dArray[1]) * 0.5));
                    cSSNumericValue3 = CSSNumericValue.createValue((CSSNumericType)cSSNumericValue3.getType(), (double)dArray[0]);
                    cSSNumericValue2 = CSSNumericValue.createValue((CSSNumericType)cSSNumericValue2.getType(), (double)dArray[1]);
                }
            } else {
                LOGGER.debug((Object)"There is no image-context, so we have to rely on the image's natural bounds. This may go awfully wrong.");
                cSSNumericValue3 = officeImage.getWidth();
                cSSNumericValue2 = officeImage.getHeight();
            }
            attributeList = new AttributeList();
            attributeList.setAttribute("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "name", this.imageNames.generateName("Image"));
            if (string != null) {
                attributeList.setAttribute("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "style-name", string);
            }
            attributeList.setAttribute("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "anchor-type", "paragraph");
            attributeList.setAttribute("urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0", "z-index", "0");
            attributeList.setAttribute("urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0", "x", cSSNumericValue6.getValue() + cSSNumericValue6.getType().getType());
            attributeList.setAttribute("urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0", "y", cSSNumericValue7.getValue() + cSSNumericValue7.getType().getType());
            LOGGER.debug((Object)("Image " + object + " A-Width: " + cSSNumericValue3 + ", A-Height: " + cSSNumericValue2));
            if (cSSNumericValue3 != null) {
                attributeList.setAttribute("urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0", "width", cSSNumericValue3.getValue() + cSSNumericValue3.getType().getType());
            }
            if (cSSNumericValue2 != null) {
                attributeList.setAttribute("urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0", "height", cSSNumericValue2.getValue() + cSSNumericValue2.getType().getType());
            }
            cSSNumericValue = new AttributeList();
            cSSNumericValue.setAttribute("http://www.w3.org/1999/xlink", "href", officeImage.getEmbeddableLink());
            cSSNumericValue.setAttribute("http://www.w3.org/1999/xlink", "type", "simple");
            cSSNumericValue.setAttribute("http://www.w3.org/1999/xlink", "show", "embed");
            cSSNumericValue.setAttribute("http://www.w3.org/1999/xlink", "actuate", "onLoad");
            try {
                this.getXmlWriter().writeTag("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "frame", attributeList, false);
                this.getXmlWriter().writeTag("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "image", (AttributeList)cSSNumericValue, true);
                this.getXmlWriter().writeCloseTag();
            }
            catch (IOException iOException) {
                throw new ReportProcessingException(FAILED, (Exception)iOException);
            }
        }
    }

    private CSSNumericValue computeImageWidth(ImageElementContext imageElementContext) {
        LengthCalculator lengthCalculator = new LengthCalculator();
        String[] stringArray = imageElementContext.getColStyles();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            CSSNumericValue cSSNumericValue = this.computeColumnWidth(string);
            if (cSSNumericValue == null) continue;
            lengthCalculator.add(cSSNumericValue);
        }
        return lengthCalculator.getResult();
    }

    private CSSNumericValue computeImageHeight(ImageElementContext imageElementContext) {
        LengthCalculator lengthCalculator = new LengthCalculator();
        String[] stringArray = imageElementContext.getRowStyles();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            CSSNumericValue cSSNumericValue = this.computeRowHeight(string);
            if (cSSNumericValue == null) continue;
            lengthCalculator.add(cSSNumericValue);
        }
        return lengthCalculator.getResult();
    }

    protected CSSNumericValue computeRowHeight(String string) {
        Object object;
        Element element;
        Object object2;
        Element element2;
        OfficeStylesCollection officeStylesCollection = this.getContentStylesCollection();
        OfficeStyle officeStyle = officeStylesCollection.getStyle("table-row", string);
        if (officeStyle != null) {
            element2 = officeStyle.getTableRowProperties();
            if (element2 != null && (object2 = (String)element2.getAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "row-height")) != null) {
                return this.parseLength((String)object2);
            }
            object2 = officeStyle.getStyleParent();
            if (object2 != null) {
                return this.computeRowHeight((String)object2);
            }
        }
        if ((object2 = (element2 = this.getGlobalStylesCollection()).getStyle("table-row", string)) != null) {
            element = ((OfficeStyle)((Object)object2)).getTableRowProperties();
            if (element != null && (object = (String)element.getAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "row-height")) != null) {
                return this.parseLength((String)object);
            }
            object = ((OfficeStyle)((Object)object2)).getStyleParent();
            if (object != null) {
                return this.computeRowHeight((String)object);
            }
        }
        if ((object = (element = this.getPredefinedStylesCollection()).getStyle("table-row", string)) != null) {
            String string2;
            Element element3 = ((OfficeStyle)((Object)object)).getTableRowProperties();
            if (element3 != null && (string2 = (String)element3.getAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "row-height")) != null) {
                return this.parseLength(string2);
            }
            string2 = ((OfficeStyle)((Object)object)).getStyleParent();
            if (string2 != null) {
                return this.computeRowHeight(string2);
            }
        }
        return null;
    }

    private CSSNumericValue computeColumnWidth(String string) {
        Object object;
        Element element;
        Object object2;
        Element element2;
        OfficeStylesCollection officeStylesCollection = this.getContentStylesCollection();
        OfficeStyle officeStyle = officeStylesCollection.getStyle("table-column", string);
        if (officeStyle != null) {
            element2 = officeStyle.getTableColumnProperties();
            if (element2 != null && (object2 = (String)element2.getAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "column-width")) != null) {
                return this.parseLength((String)object2);
            }
            object2 = officeStyle.getStyleParent();
            if (object2 != null) {
                return this.computeRowHeight((String)object2);
            }
        }
        if ((object2 = (element2 = this.getGlobalStylesCollection()).getStyle("table-column", string)) != null) {
            element = ((OfficeStyle)((Object)object2)).getTableColumnProperties();
            if (element != null && (object = (String)element.getAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "column-width")) != null) {
                return this.parseLength((String)object);
            }
            object = ((OfficeStyle)((Object)object2)).getStyleParent();
            if (object != null) {
                return this.computeRowHeight((String)object);
            }
        }
        if ((object = (element = this.getPredefinedStylesCollection()).getStyle("table-column", string)) != null) {
            String string2;
            Element element3 = ((OfficeStyle)((Object)object)).getTableColumnProperties();
            if (element3 != null && (string2 = (String)element3.getAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "column-width")) != null) {
                return this.parseLength(string2);
            }
            string2 = ((OfficeStyle)((Object)object)).getStyleParent();
            if (string2 != null) {
                return this.computeRowHeight(string2);
            }
        }
        return null;
    }

    protected Element produceFirstChild(Section section, String string, String string2) {
        Element element = section.findFirstChild(string, string2);
        if (element == null) {
            element = new Section();
            element.setNamespace(string);
            element.setType(string2);
            section.addNode((Node)element);
        }
        return element;
    }

    protected void startChartProcessing(AttributeMap attributeMap) throws ReportProcessingException {
        String string = (String)attributeMap.getAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "class-id");
        String string2 = (String)attributeMap.getAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "href");
        ArrayList arrayList = (ArrayList)attributeMap.getAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "master-columns");
        ArrayList arrayList2 = (ArrayList)attributeMap.getAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "master-values");
        ArrayList arrayList3 = (ArrayList)attributeMap.getAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "detail-columns");
        String string3 = this.oleProducer.produceOle(string2, arrayList, arrayList2, arrayList3);
        AttributeList attributeList = new AttributeList();
        attributeList.setAttribute("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "class-id", string);
        attributeList.setAttribute("http://www.w3.org/1999/xlink", "href", "./" + string3);
        attributeList.setAttribute("http://www.w3.org/1999/xlink", "type", "simple");
        attributeList.setAttribute("http://www.w3.org/1999/xlink", "show", "embed");
        attributeList.setAttribute("http://www.w3.org/1999/xlink", "actuate", "onLoad");
        try {
            this.getXmlWriter().writeTag("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "object-ole", attributeList, true);
        }
        catch (IOException iOException) {
            throw new ReportProcessingException(FAILED, (Exception)iOException);
        }
    }

    private static double[] calcPaintSize(CSSNumericValue cSSNumericValue, CSSNumericValue cSSNumericValue2, CSSNumericValue cSSNumericValue3, CSSNumericValue cSSNumericValue4) {
        double d = cSSNumericValue.getValue() / cSSNumericValue3.getValue();
        double d2 = cSSNumericValue2.getValue() / cSSNumericValue4.getValue();
        double d3 = Math.min(d, d2);
        double[] dArray = new double[]{cSSNumericValue3.getValue() * d3, cSSNumericValue4.getValue() * d3};
        return dArray;
    }

    protected void writeNullDate() throws IOException {
        XmlWriter xmlWriter = this.getXmlWriter();
        xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "calculation-settings", null, false);
        AttributeMap attributeMap = new AttributeMap();
        attributeMap.setAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "date-value", (Object)"1899-12-30");
        xmlWriter.writeTag("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "null-date", this.buildAttributeList(attributeMap), true);
        xmlWriter.writeCloseTag();
    }

    public static class GroupContext {
        private final GroupContext parent;
        private int iterationCount;
        private boolean groupWithRepeatingSection;

        private GroupContext(GroupContext groupContext) {
            this.parent = groupContext;
        }

        public GroupContext getParent() {
            return this.parent;
        }

        public int getIterationCount() {
            return this.iterationCount;
        }

        private void setIterationCount(int n) {
            this.iterationCount = n;
        }

        public boolean isGroupWithRepeatingSection() {
            return this.groupWithRepeatingSection;
        }

        private void setGroupWithRepeatingSection(boolean bl) {
            this.groupWithRepeatingSection = bl;
        }

        public String toString() {
            return "GroupContext{parent=" + this.parent + ", iterationCount=" + this.iterationCount + ", groupWithRepeatingSection=" + this.groupWithRepeatingSection + '}';
        }
    }

    protected static class BufferState {
        private final XmlWriter xmlWriter;
        private final MemoryByteArrayOutputStream xmlBuffer;
        private final OfficeStylesCollection stylesCollection;

        private BufferState(XmlWriter xmlWriter, MemoryByteArrayOutputStream memoryByteArrayOutputStream, OfficeStylesCollection officeStylesCollection) {
            this.stylesCollection = officeStylesCollection;
            this.xmlWriter = xmlWriter;
            this.xmlBuffer = memoryByteArrayOutputStream;
        }

        public OfficeStylesCollection getStylesCollection() {
            return this.stylesCollection;
        }

        public XmlWriter getXmlWriter() {
            return this.xmlWriter;
        }

        public String getXmlBuffer() throws ReportProcessingException {
            try {
                byte[] byArray = this.xmlBuffer.getRaw();
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new InflaterInputStream(new ByteArrayInputStream(byArray, 0, this.xmlBuffer.getLength())), "UTF-16");
                StringWriter stringWriter = new StringWriter(byArray.length / 2 + 1);
                IOUtils.getInstance().copyWriter((Reader)inputStreamReader, (Writer)stringWriter);
                return stringWriter.toString();
            }
            catch (IOException iOException) {
                throw new ReportProcessingException("Failed to copy buffer", (Exception)iOException);
            }
        }

        public Reader getXmlAsReader() throws ReportProcessingException {
            try {
                byte[] byArray = this.xmlBuffer.getRaw();
                return new InputStreamReader((InputStream)new InflaterInputStream(new ByteArrayInputStream(byArray, 0, this.xmlBuffer.getLength())), "UTF-16");
            }
            catch (IOException iOException) {
                throw new ReportProcessingException("Failed to copy buffer", (Exception)iOException);
            }
        }
    }
}

