/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.Serializable;
import org.mozilla.javascript.Interpreter;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.SecurityController;
import org.mozilla.javascript.debug.DebuggableScript;

final class InterpreterData
implements Serializable,
DebuggableScript {
    static final long serialVersionUID = 4815333329084415557L;
    static final int INITIAL_MAX_ICODE_LENGTH = 1024;
    static final int INITIAL_STRINGTABLE_SIZE = 64;
    static final int INITIAL_NUMBERTABLE_SIZE = 64;
    SecurityController securityController;
    Object securityDomain;
    String itsName;
    String itsSourceFile;
    boolean itsNeedsActivation;
    boolean itsFromEvalCode;
    boolean itsCheckThis;
    int itsFunctionType;
    String[] itsStringTable;
    double[] itsDoubleTable;
    InterpreterData[] itsNestedFunctions;
    Object[] itsRegExpLiterals;
    byte[] itsICode;
    int itsICodeTop;
    int[] itsExceptionTable;
    int itsMaxVars;
    int itsMaxLocals;
    int itsMaxStack;
    int itsMaxFrameArray;
    String[] argNames;
    int argCount;
    int itsMaxCalleeArgs;
    String encodedSource;
    int encodedSourceStart;
    int encodedSourceEnd;
    int languageVersion;
    boolean useDynamicScope;
    boolean topLevel;
    InterpreterData parentData;

    InterpreterData(SecurityController securityController, Object securityDomain, int languageVersion, String sourceFile, String encodedSource) {
        this.securityController = securityController;
        this.securityDomain = securityDomain;
        this.languageVersion = languageVersion;
        this.itsSourceFile = sourceFile;
        this.encodedSource = encodedSource;
        this.init();
    }

    InterpreterData(InterpreterData parent) {
        this.parentData = parent;
        this.securityController = parent.securityController;
        this.securityDomain = parent.securityDomain;
        this.languageVersion = parent.languageVersion;
        this.itsSourceFile = parent.itsSourceFile;
        this.encodedSource = parent.encodedSource;
        this.init();
    }

    private void init() {
        this.itsICodeTop = 1024;
        this.itsICode = new byte[this.itsICodeTop];
        this.itsStringTable = new String[64];
    }

    @Override
    public boolean isTopLevel() {
        return this.topLevel;
    }

    @Override
    public boolean isFunction() {
        return this.itsFunctionType != 0;
    }

    @Override
    public String getFunctionName() {
        return this.itsName;
    }

    @Override
    public String getSourceName() {
        return this.itsSourceFile;
    }

    @Override
    public boolean isGeneratedScript() {
        return ScriptRuntime.isGeneratedScript(this.itsSourceFile);
    }

    @Override
    public int[] getLineNumbers() {
        return Interpreter.getLineNumbers(this);
    }

    @Override
    public int getFunctionCount() {
        return this.itsNestedFunctions == null ? 0 : this.itsNestedFunctions.length;
    }

    @Override
    public DebuggableScript getFunction(int index) {
        return this.itsNestedFunctions[index];
    }

    @Override
    public DebuggableScript getParent() {
        return this.parentData;
    }
}

