/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import org.hsqldb.HsqlException;
import org.hsqldb.Node;
import org.hsqldb.rowio.RowOutputInterface;

abstract class BaseMemoryNode
extends Node {
    protected Node nLeft;
    protected Node nRight;
    protected Node nParent;

    BaseMemoryNode() {
    }

    @Override
    void delete() {
        this.iBalance = -2;
        this.nParent = null;
        this.nRight = null;
        this.nLeft = null;
    }

    @Override
    Node getLeft() throws HsqlException {
        return this.nLeft;
    }

    @Override
    void setLeft(Node node) throws HsqlException {
        this.nLeft = node;
    }

    @Override
    boolean isLeft(Node node) throws HsqlException {
        return this.nLeft == node;
    }

    @Override
    boolean isRight(Node node) throws HsqlException {
        return this.nRight == node;
    }

    @Override
    Node getRight() throws HsqlException {
        return this.nRight;
    }

    @Override
    void setRight(Node node) throws HsqlException {
        this.nRight = node;
    }

    @Override
    Node getParent() throws HsqlException {
        return this.nParent;
    }

    @Override
    boolean isRoot() {
        return this.nParent == null;
    }

    @Override
    void setParent(Node node) throws HsqlException {
        this.nParent = node;
    }

    @Override
    void setBalance(int n) throws HsqlException {
        this.iBalance = n;
    }

    @Override
    boolean isFromLeft() throws HsqlException {
        if (this.isRoot()) {
            return true;
        }
        Node node = this.getParent();
        return this.equals(node.getLeft());
    }

    @Override
    boolean equals(Node node) {
        return node == this;
    }

    @Override
    void write(RowOutputInterface rowOutputInterface) throws IOException {
    }
}

