/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.creole.Atom;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.sprite.Sprite;

public class AtomSprite
implements Atom {
    private final FontConfiguration fontConfiguration;
    private final Sprite sprite;
    private final double scale;
    private final Url url;

    public AtomSprite(double scale, FontConfiguration fontConfiguration, Sprite sprite, Url url) {
        this.scale = scale;
        this.fontConfiguration = fontConfiguration;
        this.sprite = sprite;
        this.url = url;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return this.sprite.asTextBlock(this.fontConfiguration.getColor(), this.scale).calculateDimension(stringBounder);
    }

    @Override
    public double getStartingAltitude(StringBounder stringBounder) {
        return 0.0;
    }

    @Override
    public void drawU(UGraphic ug) {
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        this.sprite.asTextBlock(this.fontConfiguration.getColor(), this.scale).drawU(ug);
        if (this.url != null) {
            ug.closeAction();
        }
    }
}

