/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.flow.layoutprocessor;

import java.util.Map;
import org.jfree.layouting.input.style.CSSDeclarationRule;
import org.jfree.layouting.input.style.CSSStyleRule;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.StyleKeyRegistry;
import org.jfree.layouting.input.style.StyleRule;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.namespace.NamespaceDefinition;
import org.jfree.layouting.util.AttributeMap;
import org.jfree.report.DataSourceException;
import org.jfree.report.EmptyReportData;
import org.jfree.report.ReportDataFactoryException;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.data.GlobalMasterRow;
import org.jfree.report.data.PrecomputeNodeKey;
import org.jfree.report.data.PrecomputedValueRegistry;
import org.jfree.report.data.ReportDataRow;
import org.jfree.report.data.StaticExpressionRuntimeData;
import org.jfree.report.expressions.Expression;
import org.jfree.report.expressions.ExpressionRuntime;
import org.jfree.report.flow.EmptyReportTarget;
import org.jfree.report.flow.FlowControlOperation;
import org.jfree.report.flow.FlowController;
import org.jfree.report.flow.LayoutExpressionRuntime;
import org.jfree.report.flow.ReportContext;
import org.jfree.report.flow.ReportJob;
import org.jfree.report.flow.ReportStructureRoot;
import org.jfree.report.flow.ReportTarget;
import org.jfree.report.flow.layoutprocessor.LayoutController;
import org.jfree.report.structure.Element;
import org.jfree.report.structure.Group;
import org.jfree.report.structure.Node;
import org.jfree.report.structure.Section;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;

public class LayoutControllerUtil {
    public static final EmptyReportData EMPTY_REPORT_DATA = new EmptyReportData();

    private LayoutControllerUtil() {
    }

    public static int findNodeInParent(Section section, Node node) {
        Node[] nodeArray = section.getNodeArray();
        for (int i = 0; i < nodeArray.length; ++i) {
            Node node2 = nodeArray[i];
            if (node2 != node) continue;
            return i;
        }
        return -1;
    }

    public static StaticExpressionRuntimeData getStaticExpressionRuntime(FlowController flowController, Object object) {
        GlobalMasterRow globalMasterRow = flowController.getMasterRow();
        ReportJob reportJob = flowController.getReportJob();
        StaticExpressionRuntimeData staticExpressionRuntimeData = new StaticExpressionRuntimeData();
        staticExpressionRuntimeData.setData(globalMasterRow.getReportDataRow().getReportData());
        staticExpressionRuntimeData.setDeclaringParent(object);
        staticExpressionRuntimeData.setConfiguration((Configuration)reportJob.getConfiguration());
        staticExpressionRuntimeData.setReportContext(flowController.getReportContext());
        return staticExpressionRuntimeData;
    }

    public static LayoutExpressionRuntime getExpressionRuntime(FlowController flowController, Object object) {
        LayoutExpressionRuntime layoutExpressionRuntime = new LayoutExpressionRuntime();
        layoutExpressionRuntime.setConfiguration((Configuration)flowController.getReportJob().getConfiguration());
        layoutExpressionRuntime.setReportContext(flowController.getReportContext());
        GlobalMasterRow globalMasterRow = flowController.getMasterRow();
        layoutExpressionRuntime.setDataRow(globalMasterRow.getGlobalView());
        ReportDataRow reportDataRow = globalMasterRow.getReportDataRow();
        if (reportDataRow == null) {
            layoutExpressionRuntime.setData(EMPTY_REPORT_DATA);
            layoutExpressionRuntime.setCurrentRow(-1);
        } else {
            layoutExpressionRuntime.setData(reportDataRow.getReportData());
            layoutExpressionRuntime.setCurrentRow(reportDataRow.getCursor());
        }
        layoutExpressionRuntime.setDeclaringParent(object);
        return layoutExpressionRuntime;
    }

    public static FlowController processFlowOperations(FlowController flowController, FlowControlOperation[] flowControlOperationArray) throws DataSourceException {
        for (int i = 0; i < flowControlOperationArray.length; ++i) {
            FlowControlOperation flowControlOperation = flowControlOperationArray[i];
            flowController = flowController.performOperation(flowControlOperation);
        }
        return flowController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isGroupFinished(FlowController flowController, Node node) throws DataSourceException {
        Node node2 = node.getParent();
        if (node2 == null) {
            return false;
        }
        Group group = node2.getGroup();
        if (group == null) {
            return false;
        }
        LayoutExpressionRuntime layoutExpressionRuntime = null;
        while (group != null) {
            Object object;
            if (layoutExpressionRuntime == null) {
                layoutExpressionRuntime = LayoutControllerUtil.getExpressionRuntime(flowController, node);
            }
            layoutExpressionRuntime.setDeclaringParent(group);
            Expression expression = group.getGroupingExpression();
            if (expression != null) {
                expression.setRuntime(layoutExpressionRuntime);
                try {
                    object = expression.computeValue();
                }
                finally {
                    expression.setRuntime(null);
                }
                if (Boolean.TRUE.equals(object)) {
                    return true;
                }
            }
            if ((object = group.getParent()) == null) {
                group = null;
                continue;
            }
            group = ((Node)object).getGroup();
        }
        return false;
    }

    private static void mergeDeclarationRule(CSSDeclarationRule cSSDeclarationRule, CSSDeclarationRule cSSDeclarationRule2) {
        StyleKey[] styleKeyArray = cSSDeclarationRule2.getPropertyKeysAsArray();
        for (int i = 0; i < styleKeyArray.length; ++i) {
            StyleKey styleKey = styleKeyArray[i];
            CSSValue cSSValue = cSSDeclarationRule2.getPropertyCSSValue(styleKey);
            if (cSSValue == null) continue;
            boolean bl = cSSDeclarationRule2.isImportant(styleKey);
            boolean bl2 = cSSDeclarationRule.isImportant(styleKey);
            if (bl2) continue;
            cSSDeclarationRule.setPropertyValue(styleKey, cSSValue);
            cSSDeclarationRule.setImportant(styleKey, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CSSDeclarationRule processStyleAttribute(Object object, Element element, ExpressionRuntime expressionRuntime, CSSDeclarationRule cSSDeclarationRule) throws DataSourceException {
        Resource resource;
        ResourceKey resourceKey;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        if (cSSDeclarationRule == null) {
            try {
                cSSDeclarationRule = (CSSDeclarationRule)element.getStyle().clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cSSDeclarationRule = new CSSStyleRule(null, null);
            }
        }
        if (object instanceof String) {
            object5 = (String)object;
            try {
                ReportContext reportContext = expressionRuntime.getReportContext();
                ReportStructureRoot object6 = reportContext.getReportStructureRoot();
                object4 = object6.getBaseResource();
                object3 = object6.getResourceManager();
                object2 = ((String)object5).getBytes("UTF-8");
                resourceKey = object3.createKey(object2);
                resource = object3.create(resourceKey, object4, StyleRule.class);
                CSSDeclarationRule cSSDeclarationRule2 = (CSSDeclarationRule)resource.getResource();
                LayoutControllerUtil.mergeDeclarationRule(cSSDeclarationRule, cSSDeclarationRule2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (object instanceof CSSStyleRule) {
            object5 = (CSSStyleRule)object;
            LayoutControllerUtil.mergeDeclarationRule(cSSDeclarationRule, (CSSDeclarationRule)object5);
        }
        object5 = element.getStyleExpressions();
        for (Map.Entry entry : object5.entrySet()) {
            object4 = (String)entry.getKey();
            object3 = (Expression)entry.getValue();
            try {
                object3.setRuntime(expressionRuntime);
                object2 = object3.computeValue();
                resourceKey = StyleKeyRegistry.getRegistry().findKeyByName((String)object4);
                if (object2 instanceof CSSValue) {
                    resource = (CSSValue)object2;
                    if (resourceKey != null) {
                        cSSDeclarationRule.setPropertyValue((StyleKey)resourceKey, (CSSValue)resource);
                        continue;
                    }
                    cSSDeclarationRule.setPropertyValueAsString((String)object4, resource.getCSSText());
                    continue;
                }
                if (object2 == null) continue;
                cSSDeclarationRule.setPropertyValueAsString((String)object4, String.valueOf(object2));
            }
            finally {
                object3.setRuntime(null);
            }
        }
        return cSSDeclarationRule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AttributeMap collectAttributes(Element element, ExpressionRuntime expressionRuntime) throws DataSourceException {
        AttributeMap attributeMap = element.getAttributeMap();
        AttributeMap attributeMap2 = element.getAttributeExpressionMap();
        if (attributeMap2.isEmpty()) {
            return attributeMap;
        }
        String[] stringArray = attributeMap2.getNameSpaces();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Map map = attributeMap2.getAttributes(string);
            for (Map.Entry entry : map.entrySet()) {
                String string2 = (String)entry.getKey();
                Expression expression = (Expression)entry.getValue();
                try {
                    expression.setRuntime(expressionRuntime);
                    Object object = expression.computeValue();
                    if (attributeMap.isReadOnly()) {
                        attributeMap = new AttributeMap(attributeMap);
                    }
                    attributeMap.setAttribute(string, string2, object);
                }
                finally {
                    expression.setRuntime(null);
                }
            }
        }
        return attributeMap.createUnmodifiableMap();
    }

    public static AttributeMap processAttributes(Element element, ReportTarget reportTarget, ExpressionRuntime expressionRuntime) throws DataSourceException {
        AttributeMap attributeMap = LayoutControllerUtil.collectAttributes(element, expressionRuntime);
        CSSDeclarationRule cSSDeclarationRule = null;
        String[] stringArray = attributeMap.getNameSpaces();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Map map = attributeMap.getAttributes(string);
            if (map == null || map.isEmpty()) continue;
            NamespaceDefinition namespaceDefinition = reportTarget.getNamespaceByUri(string);
            for (Map.Entry entry : map.entrySet()) {
                String string2 = (String)entry.getKey();
                if (!LayoutControllerUtil.isStyleAttribute(namespaceDefinition, element.getType(), string2)) continue;
                Object v = entry.getValue();
                cSSDeclarationRule = LayoutControllerUtil.processStyleAttribute(v, element, expressionRuntime, cSSDeclarationRule);
            }
        }
        if (cSSDeclarationRule == null) {
            cSSDeclarationRule = LayoutControllerUtil.processStyleAttribute(null, element, expressionRuntime, cSSDeclarationRule);
        }
        if (cSSDeclarationRule != null && !cSSDeclarationRule.isEmpty()) {
            AttributeMap attributeMap2 = new AttributeMap(attributeMap);
            attributeMap2.setAttribute("http://jfreereport.sourceforge.net/namespaces/layout", "style", (Object)cSSDeclarationRule);
            attributeMap2.makeReadOnly();
            return attributeMap2;
        }
        return attributeMap;
    }

    private static boolean isStyleAttribute(NamespaceDefinition namespaceDefinition, String string, String string2) {
        if (namespaceDefinition == null) {
            return false;
        }
        String[] stringArray = namespaceDefinition.getStyleAttribute(string);
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            if (!string2.equals(string3)) continue;
            return true;
        }
        return false;
    }

    public static AttributeMap createEmptyMap(String string, String string2) {
        AttributeMap attributeMap = new AttributeMap();
        attributeMap.setAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "namespace", (Object)string);
        attributeMap.setAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "type", (Object)string2);
        return attributeMap;
    }

    public static Object performPrecompute(int n, PrecomputeNodeKey precomputeNodeKey, LayoutController layoutController, FlowController flowController) throws ReportProcessingException, ReportDataFactoryException, DataSourceException {
        Object object;
        FlowController flowController2 = flowController.createPrecomputeInstance();
        PrecomputedValueRegistry precomputedValueRegistry = flowController2.getPrecomputedValueRegistry();
        precomputedValueRegistry.startElementPrecomputation(precomputeNodeKey);
        LayoutController layoutController2 = layoutController.createPrecomputeInstance(flowController2);
        LayoutController layoutController3 = layoutController2.getParent();
        EmptyReportTarget emptyReportTarget = new EmptyReportTarget(flowController2.getReportJob(), flowController2.getExportDescriptor());
        LayoutController layoutController4 = layoutController2;
        while (layoutController4.isAdvanceable()) {
            layoutController4 = layoutController4.advance(emptyReportTarget);
            while (!layoutController4.isAdvanceable() && layoutController4.getParent() != null) {
                object = layoutController4.getParent();
                layoutController4 = object.join(layoutController4.getFlowController());
            }
        }
        emptyReportTarget.commit();
        object = precomputedValueRegistry.currentNode();
        Object object2 = object.getFunctionResult(n);
        precomputedValueRegistry.finishElementPrecomputation(precomputeNodeKey);
        return object2;
    }

    public static LayoutController skipInvisibleElement(LayoutController layoutController) throws ReportProcessingException, ReportDataFactoryException, DataSourceException {
        FlowController flowController = layoutController.getFlowController();
        EmptyReportTarget emptyReportTarget = new EmptyReportTarget(flowController.getReportJob(), flowController.getExportDescriptor());
        LayoutController layoutController2 = layoutController.getParent();
        LayoutController layoutController3 = layoutController;
        while (layoutController3.isAdvanceable()) {
            layoutController3 = layoutController3.advance(emptyReportTarget);
            while (!layoutController3.isAdvanceable() && layoutController3.getParent() != null) {
                LayoutController layoutController4 = layoutController3.getParent();
                layoutController3 = layoutController4.join(layoutController3.getFlowController());
                if (layoutController4 != layoutController2) continue;
                emptyReportTarget.commit();
                return layoutController3;
            }
        }
        emptyReportTarget.commit();
        throw new IllegalStateException("Ups - we did not get to the root parent again. This is awful and we cannot continue.");
    }

    public static Object evaluateExpression(FlowController flowController, Object object, Expression expression) throws DataSourceException {
        LayoutExpressionRuntime layoutExpressionRuntime = LayoutControllerUtil.getExpressionRuntime(flowController, object);
        try {
            expression.setRuntime(layoutExpressionRuntime);
            Object object2 = expression.computeValue();
            return object2;
        }
        catch (DataSourceException dataSourceException) {
            throw dataSourceException;
        }
        catch (Exception exception) {
            throw new DataSourceException("Failed to evaluate expression", exception);
        }
        finally {
            expression.setRuntime(null);
        }
    }
}

