/*
 * Decompiled with CFR 0.152.
 */
package sax;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.ext.Locator2;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.ParserAdapter;
import org.xml.sax.helpers.ParserFactory;
import org.xml.sax.helpers.XMLReaderFactory;
import sax.helpers.AttributesImpl;

public class Writer
extends DefaultHandler
implements LexicalHandler {
    protected static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected static final String NAMESPACE_PREFIXES_FEATURE_ID = "http://xml.org/sax/features/namespace-prefixes";
    protected static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String HONOUR_ALL_SCHEMA_LOCATIONS_ID = "http://apache.org/xml/features/honour-all-schemaLocations";
    protected static final String VALIDATE_ANNOTATIONS_ID = "http://apache.org/xml/features/validate-annotations";
    protected static final String GENERATE_SYNTHETIC_ANNOTATIONS_ID = "http://apache.org/xml/features/generate-synthetic-annotations";
    protected static final String DYNAMIC_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/dynamic";
    protected static final String LOAD_EXTERNAL_DTD_FEATURE_ID = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    protected static final String XINCLUDE_FEATURE_ID = "http://apache.org/xml/features/xinclude";
    protected static final String XINCLUDE_FIXUP_BASE_URIS_FEATURE_ID = "http://apache.org/xml/features/xinclude/fixup-base-uris";
    protected static final String XINCLUDE_FIXUP_LANGUAGE_FEATURE_ID = "http://apache.org/xml/features/xinclude/fixup-language";
    protected static final String LEXICAL_HANDLER_PROPERTY_ID = "http://xml.org/sax/properties/lexical-handler";
    protected static final String DEFAULT_PARSER_NAME = "org.apache.xerces.parsers.SAXParser";
    protected static final boolean DEFAULT_NAMESPACES = true;
    protected static final boolean DEFAULT_NAMESPACE_PREFIXES = false;
    protected static final boolean DEFAULT_VALIDATION = false;
    protected static final boolean DEFAULT_LOAD_EXTERNAL_DTD = true;
    protected static final boolean DEFAULT_SCHEMA_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_FULL_CHECKING = false;
    protected static final boolean DEFAULT_HONOUR_ALL_SCHEMA_LOCATIONS = false;
    protected static final boolean DEFAULT_VALIDATE_ANNOTATIONS = false;
    protected static final boolean DEFAULT_GENERATE_SYNTHETIC_ANNOTATIONS = false;
    protected static final boolean DEFAULT_DYNAMIC_VALIDATION = false;
    protected static final boolean DEFAULT_XINCLUDE = false;
    protected static final boolean DEFAULT_XINCLUDE_FIXUP_BASE_URIS = true;
    protected static final boolean DEFAULT_XINCLUDE_FIXUP_LANGUAGE = true;
    protected static final boolean DEFAULT_CANONICAL = false;
    protected PrintWriter fOut;
    protected boolean fCanonical;
    protected int fElementDepth;
    protected Locator fLocator;
    protected boolean fXML11;
    protected boolean fInCDATA;

    public void setCanonical(boolean bl) {
        this.fCanonical = bl;
    }

    public void setOutput(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        if (string == null) {
            string = "UTF8";
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string);
        this.fOut = new PrintWriter(outputStreamWriter);
    }

    public void setOutput(java.io.Writer writer) {
        this.fOut = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.fLocator = locator;
    }

    @Override
    public void startDocument() throws SAXException {
        this.fElementDepth = 0;
        this.fXML11 = false;
        this.fInCDATA = false;
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.fElementDepth > 0) {
            this.fOut.print("<?");
            this.fOut.print(string);
            if (string2 != null && string2.length() > 0) {
                this.fOut.print(' ');
                this.fOut.print(string2);
            }
            this.fOut.print("?>");
            this.fOut.flush();
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.fElementDepth == 0) {
            String string4 = "UTF-8";
            if (this.fLocator != null) {
                if (this.fLocator instanceof Locator2) {
                    Locator2 locator2 = (Locator2)this.fLocator;
                    this.fXML11 = "1.1".equals(locator2.getXMLVersion());
                    string4 = locator2.getEncoding();
                    if (string4 == null) {
                        string4 = "UTF-8";
                    }
                }
                this.fLocator = null;
            }
            if (!this.fCanonical) {
                this.fOut.print("<?xml version=\"");
                this.fOut.print(this.fXML11 ? "1.1" : "1.0");
                this.fOut.print("\" encoding=\"");
                this.fOut.print(string4);
                this.fOut.println("\"?>");
                this.fOut.flush();
            }
        }
        ++this.fElementDepth;
        this.fOut.print('<');
        this.fOut.print(string3);
        if (attributes != null) {
            attributes = this.sortAttributes(attributes);
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                this.fOut.print(' ');
                this.fOut.print(attributes.getQName(i));
                this.fOut.print("=\"");
                this.normalizeAndPrint(attributes.getValue(i), true);
                this.fOut.print('\"');
            }
        }
        this.fOut.print('>');
        this.fOut.flush();
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (!this.fInCDATA) {
            this.normalizeAndPrint(cArray, n, n2, false);
        } else {
            for (int i = 0; i < n2; ++i) {
                this.fOut.print(cArray[n + i]);
            }
        }
        this.fOut.flush();
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.characters(cArray, n, n2);
        this.fOut.flush();
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        --this.fElementDepth;
        this.fOut.print("</");
        this.fOut.print(string3);
        this.fOut.print('>');
        this.fOut.flush();
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.printError("Warning", sAXParseException);
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        this.printError("Error", sAXParseException);
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.printError("Fatal Error", sAXParseException);
        throw sAXParseException;
    }

    @Override
    public void startDTD(String string, String string2, String string3) throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void startEntity(String string) throws SAXException {
    }

    @Override
    public void endEntity(String string) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
        if (!this.fCanonical) {
            this.fOut.print("<![CDATA[");
            this.fInCDATA = true;
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        if (!this.fCanonical) {
            this.fInCDATA = false;
            this.fOut.print("]]>");
        }
    }

    @Override
    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (!this.fCanonical && this.fElementDepth > 0) {
            this.fOut.print("<!--");
            for (int i = 0; i < n2; ++i) {
                this.fOut.print(cArray[n + i]);
            }
            this.fOut.print("-->");
            this.fOut.flush();
        }
    }

    protected Attributes sortAttributes(Attributes attributes) {
        AttributesImpl attributesImpl = new AttributesImpl();
        int n = attributes != null ? attributes.getLength() : 0;
        for (int i = 0; i < n; ++i) {
            int n2;
            String string = attributes.getQName(i);
            int n3 = attributesImpl.getLength();
            for (n2 = 0; n2 < n3 && string.compareTo(attributesImpl.getQName(n2)) >= 0; ++n2) {
            }
            attributesImpl.insertAttributeAt(n2, string, attributes.getType(i), attributes.getValue(i));
        }
        return attributesImpl;
    }

    protected void normalizeAndPrint(String string, boolean bl) {
        int n = string != null ? string.length() : 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            this.normalizeAndPrint(c, bl);
        }
    }

    protected void normalizeAndPrint(char[] cArray, int n, int n2, boolean bl) {
        for (int i = 0; i < n2; ++i) {
            this.normalizeAndPrint(cArray[n + i], bl);
        }
    }

    protected void normalizeAndPrint(char c, boolean bl) {
        switch (c) {
            case '<': {
                this.fOut.print("&lt;");
                break;
            }
            case '>': {
                this.fOut.print("&gt;");
                break;
            }
            case '&': {
                this.fOut.print("&amp;");
                break;
            }
            case '\"': {
                if (bl) {
                    this.fOut.print("&quot;");
                    break;
                }
                this.fOut.print("\"");
                break;
            }
            case '\r': {
                this.fOut.print("&#xD;");
                break;
            }
            case '\n': {
                if (this.fCanonical) {
                    this.fOut.print("&#xA;");
                    break;
                }
            }
            default: {
                if (this.fXML11 && (c >= '\u0001' && c <= '\u001f' && c != '\t' && c != '\n' || c >= '\u007f' && c <= '\u009f' || c == '\u2028') || bl && (c == '\t' || c == '\n')) {
                    this.fOut.print("&#x");
                    this.fOut.print(Integer.toHexString(c).toUpperCase());
                    this.fOut.print(";");
                    break;
                }
                this.fOut.print(c);
            }
        }
    }

    protected void printError(String string, SAXParseException sAXParseException) {
        System.err.print("[");
        System.err.print(string);
        System.err.print("] ");
        String string2 = sAXParseException.getSystemId();
        if (string2 != null) {
            int n = string2.lastIndexOf(47);
            if (n != -1) {
                string2 = string2.substring(n + 1);
            }
            System.err.print(string2);
        }
        System.err.print(':');
        System.err.print(sAXParseException.getLineNumber());
        System.err.print(':');
        System.err.print(sAXParseException.getColumnNumber());
        System.err.print(": ");
        System.err.print(sAXParseException.getMessage());
        System.err.println();
        System.err.flush();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            Writer.printUsage();
            System.exit(1);
        }
        Writer writer = null;
        XMLReader xMLReader = null;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = true;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = false;
        boolean bl12 = true;
        boolean bl13 = true;
        boolean bl14 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            Object object2;
            String string = stringArray[i];
            if (string.startsWith("-")) {
                object2 = string.substring(1);
                if (((String)object2).equals("p")) {
                    if (++i == stringArray.length) {
                        System.err.println("error: Missing argument to -p option.");
                    }
                    object = stringArray[i];
                    try {
                        xMLReader = XMLReaderFactory.createXMLReader((String)object);
                    }
                    catch (Exception exception) {
                        try {
                            Parser parser = ParserFactory.makeParser((String)object);
                            xMLReader = new ParserAdapter(parser);
                            System.err.println("warning: Features and properties not supported on SAX1 parsers.");
                        }
                        catch (Exception exception2) {
                            xMLReader = null;
                            System.err.println("error: Unable to instantiate parser (" + (String)object + ")");
                            exception.printStackTrace(System.err);
                        }
                    }
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("n")) {
                    bl = ((String)object2).equals("n");
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("np")) {
                    bl2 = ((String)object2).equals("np");
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("v")) {
                    bl3 = ((String)object2).equals("v");
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("xd")) {
                    bl4 = ((String)object2).equals("xd");
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("s")) {
                    bl5 = ((String)object2).equals("s");
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("f")) {
                    bl6 = ((String)object2).equals("f");
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("hs")) {
                    bl7 = ((String)object2).equals("hs");
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("va")) {
                    bl8 = ((String)object2).equals("va");
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("ga")) {
                    bl9 = ((String)object2).equals("ga");
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("dv")) {
                    bl10 = ((String)object2).equals("dv");
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("xi")) {
                    bl11 = ((String)object2).equals("xi");
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("xb")) {
                    bl12 = ((String)object2).equals("xb");
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("xl")) {
                    bl13 = ((String)object2).equals("xl");
                    continue;
                }
                if (((String)object2).equalsIgnoreCase("c")) {
                    bl14 = ((String)object2).equals("c");
                    continue;
                }
                if (((String)object2).equals("h")) {
                    Writer.printUsage();
                    continue;
                }
            }
            if (xMLReader == null) {
                try {
                    xMLReader = XMLReaderFactory.createXMLReader(DEFAULT_PARSER_NAME);
                }
                catch (Exception exception) {
                    System.err.println("error: Unable to instantiate parser (org.apache.xerces.parsers.SAXParser)");
                    exception.printStackTrace(System.err);
                    continue;
                }
            }
            try {
                xMLReader.setFeature(NAMESPACES_FEATURE_ID, bl);
            }
            catch (SAXException sAXException) {
                System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/namespaces)");
            }
            try {
                xMLReader.setFeature(NAMESPACE_PREFIXES_FEATURE_ID, bl2);
            }
            catch (SAXException sAXException) {
                System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/namespace-prefixes)");
            }
            try {
                xMLReader.setFeature(VALIDATION_FEATURE_ID, bl3);
            }
            catch (SAXException sAXException) {
                System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/validation)");
            }
            try {
                xMLReader.setFeature(LOAD_EXTERNAL_DTD_FEATURE_ID, bl4);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                System.err.println("warning: Parser does not recognize feature (http://apache.org/xml/features/nonvalidating/load-external-dtd)");
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/nonvalidating/load-external-dtd)");
            }
            try {
                xMLReader.setFeature(SCHEMA_VALIDATION_FEATURE_ID, bl5);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                System.err.println("warning: Parser does not recognize feature (http://apache.org/xml/features/validation/schema)");
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema)");
            }
            try {
                xMLReader.setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, bl6);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                System.err.println("warning: Parser does not recognize feature (http://apache.org/xml/features/validation/schema-full-checking)");
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema-full-checking)");
            }
            try {
                xMLReader.setFeature(HONOUR_ALL_SCHEMA_LOCATIONS_ID, bl7);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                System.err.println("warning: Parser does not recognize feature (http://apache.org/xml/features/honour-all-schemaLocations)");
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/honour-all-schemaLocations)");
            }
            try {
                xMLReader.setFeature(VALIDATE_ANNOTATIONS_ID, bl8);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                System.err.println("warning: Parser does not recognize feature (http://apache.org/xml/features/validate-annotations)");
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validate-annotations)");
            }
            try {
                xMLReader.setFeature(GENERATE_SYNTHETIC_ANNOTATIONS_ID, bl9);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                System.err.println("warning: Parser does not recognize feature (http://apache.org/xml/features/generate-synthetic-annotations)");
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/generate-synthetic-annotations)");
            }
            try {
                xMLReader.setFeature(DYNAMIC_VALIDATION_FEATURE_ID, bl10);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                System.err.println("warning: Parser does not recognize feature (http://apache.org/xml/features/validation/dynamic)");
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/dynamic)");
            }
            try {
                xMLReader.setFeature(XINCLUDE_FEATURE_ID, bl11);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                System.err.println("warning: Parser does not recognize feature (http://apache.org/xml/features/xinclude)");
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/xinclude)");
            }
            try {
                xMLReader.setFeature(XINCLUDE_FIXUP_BASE_URIS_FEATURE_ID, bl12);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                System.err.println("warning: Parser does not recognize feature (http://apache.org/xml/features/xinclude/fixup-base-uris)");
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/xinclude/fixup-base-uris)");
            }
            try {
                xMLReader.setFeature(XINCLUDE_FIXUP_LANGUAGE_FEATURE_ID, bl13);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                System.err.println("warning: Parser does not recognize feature (http://apache.org/xml/features/xinclude/fixup-language)");
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/xinclude/fixup-language)");
            }
            if (writer == null) {
                writer = new Writer();
                try {
                    writer.setOutput(System.out, "UTF8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    System.err.println("error: Unable to set output. Exiting.");
                    System.exit(1);
                }
            }
            xMLReader.setContentHandler(writer);
            xMLReader.setErrorHandler(writer);
            try {
                xMLReader.setProperty(LEXICAL_HANDLER_PROPERTY_ID, writer);
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
            writer.setCanonical(bl14);
            try {
                xMLReader.parse(string);
                continue;
            }
            catch (SAXParseException sAXParseException) {
                continue;
            }
            catch (Exception exception) {
                System.err.println("error: Parse error occurred - " + exception.getMessage());
                if (exception instanceof SAXException && (object = ((SAXException)exception).getException()) != null) {
                    object2 = object;
                }
                ((Throwable)object2).printStackTrace(System.err);
            }
        }
    }

    private static void printUsage() {
        System.err.println("usage: java sax.Writer (options) uri ...");
        System.err.println();
        System.err.println("options:");
        System.err.println("  -p name     Select parser by name.");
        System.err.println("  -n  | -N    Turn on/off namespace processing.");
        System.err.println("  -np | -NP   Turn on/off namespace prefixes.");
        System.err.println("              NOTE: Requires use of -n.");
        System.err.println("  -v  | -V    Turn on/off validation.");
        System.err.println("  -xd | -XD   Turn on/off loading of external DTDs.");
        System.err.println("              NOTE: Always on when -v in use and not supported by all parsers.");
        System.err.println("  -s  | -S    Turn on/off Schema validation support.");
        System.err.println("              NOTE: Not supported by all parsers.");
        System.err.println("  -f  | -F    Turn on/off Schema full checking.");
        System.err.println("              NOTE: Requires use of -s and not supported by all parsers.");
        System.err.println("  -hs | -HS   Turn on/off honouring of all schema locations.");
        System.err.println("              NOTE: Requires use of -s and not supported by all parsers.");
        System.err.println("  -va | -VA   Turn on/off validation of schema annotations.");
        System.err.println("              NOTE: Requires use of -s and not supported by all parsers.");
        System.err.println("  -ga | -GA   Turn on/off generation of synthetic schema annotations.");
        System.err.println("              NOTE: Requires use of -s and not supported by all parsers.");
        System.err.println("  -dv | -DV   Turn on/off dynamic validation.");
        System.err.println("              NOTE: Not supported by all parsers.");
        System.err.println("  -xi | -XI   Turn on/off XInclude processing.");
        System.err.println("              NOTE: Not supported by all parsers.");
        System.err.println("  -xb | -XB   Turn on/off base URI fixup during XInclude processing.");
        System.err.println("              NOTE: Requires use of -xi and not supported by all parsers.");
        System.err.println("  -xl | -XL   Turn on/off language fixup during XInclude processing.");
        System.err.println("              NOTE: Requires use of -xi and not supported by all parsers.");
        System.err.println("  -c | -C     Turn on/off Canonical XML output.");
        System.err.println("              NOTE: This is not W3C canonical output.");
        System.err.println("  -h          This help screen.");
        System.err.println();
        System.err.println("defaults:");
        System.err.println("  Parser:     org.apache.xerces.parsers.SAXParser");
        System.err.print("  Namespaces: ");
        System.err.println("on");
        System.err.print("  Prefixes:   ");
        System.err.println("off");
        System.err.print("  Validation: ");
        System.err.println("off");
        System.err.print("  Load External DTD: ");
        System.err.println("on");
        System.err.print("  Schema:     ");
        System.err.println("off");
        System.err.print("  Schema full checking:     ");
        System.err.println("off");
        System.err.print("  Dynamic:    ");
        System.err.println("off");
        System.err.print("  Canonical:  ");
        System.err.println("off");
        System.err.print("  Honour all schema locations:       ");
        System.err.println("off");
        System.err.print("  Validate Annotations:              ");
        System.err.println("off");
        System.err.print("  Generate Synthetic Annotations:    ");
        System.err.println("off");
        System.err.print("  XInclude:   ");
        System.err.println("off");
        System.err.print("  XInclude base URI fixup:  ");
        System.err.println("on");
        System.err.print("  XInclude language fixup:  ");
        System.err.println("on");
    }
}

